/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.statistics.BloomFilter;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.proto.OrcProto;
import com.facebook.presto.orc.protobuf.CodedInputStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcBloomFilters {
    private static final String TEST_STRING = "ORC_STRING";
    private static final String TEST_STRING_NOT_WRITTEN = "ORC_STRING_not";
    private static final int TEST_INTEGER = 12345;
    private static final String COLUMN_0 = "bigint_0";
    private static final String COLUMN_1 = "bigint_1";
    private static final Map<Object, Type> TEST_VALUES = ImmutableMap.builder().put((Object)Slices.utf8Slice((String)"ORC_STRING"), (Object)VarcharType.VARCHAR).put((Object)Slices.wrappedBuffer((byte[])new byte[]{12, 34, 56}), (Object)VarbinaryType.VARBINARY).put((Object)4312L, (Object)BigintType.BIGINT).put((Object)123, (Object)IntegerType.INTEGER).put((Object)234.567, (Object)DoubleType.DOUBLE).build();

    @Test
    public void testHiveBloomFilterSerde() {
        BloomFilter bloomFilter = new BloomFilter(1000000L, 0.05);
        bloomFilter.addString(TEST_STRING);
        Assert.assertTrue((boolean)bloomFilter.testString(TEST_STRING));
        Assert.assertFalse((boolean)bloomFilter.testString(TEST_STRING_NOT_WRITTEN));
        bloomFilter.addLong(12345L);
        Assert.assertTrue((boolean)bloomFilter.testLong(12345L));
        Assert.assertFalse((boolean)bloomFilter.testLong(12346L));
        HiveBloomFilter hiveBloomFilter = new HiveBloomFilter((List)ImmutableList.copyOf((Collection)Longs.asList((long[])bloomFilter.getBitSet())), bloomFilter.getBitSize(), bloomFilter.getNumHashFunctions());
        Assert.assertTrue((boolean)hiveBloomFilter.testString(TEST_STRING));
        Assert.assertFalse((boolean)hiveBloomFilter.testString(TEST_STRING_NOT_WRITTEN));
        Assert.assertTrue((boolean)hiveBloomFilter.testLong(12345L));
        Assert.assertFalse((boolean)hiveBloomFilter.testLong(12346L));
    }

    @Test
    public void testOrcHiveBloomFilterSerde() throws Exception {
        BloomFilter bloomFilterWrite = new BloomFilter(1000L, 0.05);
        bloomFilterWrite.addString(TEST_STRING);
        Assert.assertTrue((boolean)bloomFilterWrite.testString(TEST_STRING));
        OrcProto.BloomFilter.Builder bloomFilterBuilder = OrcProto.BloomFilter.newBuilder();
        bloomFilterBuilder.addAllBitset((Iterable)Longs.asList((long[])bloomFilterWrite.getBitSet()));
        bloomFilterBuilder.setNumHashFunctions(bloomFilterWrite.getNumHashFunctions());
        OrcProto.BloomFilter bloomFilter = bloomFilterBuilder.build();
        OrcProto.BloomFilterIndex bloomFilterIndex = OrcProto.BloomFilterIndex.getDefaultInstance();
        byte[] bytes = TestOrcBloomFilters.serializeBloomFilterToIndex(bloomFilter, bloomFilterIndex);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        OrcMetadataReader metadataReader = new OrcMetadataReader(new RuntimeStats());
        List bloomFilters = metadataReader.readBloomFilterIndexes((InputStream)inputStream);
        Assert.assertEquals((int)bloomFilters.size(), (int)1);
        Assert.assertTrue((boolean)((HiveBloomFilter)bloomFilters.get(0)).testString(TEST_STRING));
        Assert.assertFalse((boolean)((HiveBloomFilter)bloomFilters.get(0)).testString(TEST_STRING_NOT_WRITTEN));
        Assert.assertEquals((int)bloomFilterWrite.getBitSize(), (int)((HiveBloomFilter)bloomFilters.get(0)).getBitSize());
        Assert.assertEquals((int)bloomFilterWrite.getNumHashFunctions(), (int)((HiveBloomFilter)bloomFilters.get(0)).getNumHashFunctions());
        Assert.assertTrue((boolean)Arrays.equals(((HiveBloomFilter)bloomFilters.get(0)).getBitSet(), bloomFilterWrite.getBitSet()));
        CodedInputStream input = CodedInputStream.newInstance((byte[])bytes);
        OrcProto.BloomFilterIndex deserializedBloomFilterIndex = OrcProto.BloomFilterIndex.parseFrom((CodedInputStream)input);
        List bloomFilterList = deserializedBloomFilterIndex.getBloomFilterList();
        Assert.assertEquals((int)bloomFilterList.size(), (int)1);
        OrcProto.BloomFilter bloomFilterRead = (OrcProto.BloomFilter)bloomFilterList.get(0);
        Assert.assertTrue((boolean)Arrays.equals(Longs.toArray((Collection)bloomFilterRead.getBitsetList()), bloomFilterWrite.getBitSet()));
        Assert.assertEquals((int)bloomFilterWrite.getNumHashFunctions(), (int)bloomFilterRead.getNumHashFunctions());
        Assert.assertEquals((int)bloomFilterWrite.getBitSet().length, (int)bloomFilterRead.getBitsetCount());
    }

    private static byte[] serializeBloomFilterToIndex(OrcProto.BloomFilter bloomFilter, OrcProto.BloomFilterIndex bloomFilterIndex) throws IOException {
        Assert.assertTrue((boolean)bloomFilter.isInitialized());
        OrcProto.BloomFilterIndex.Builder builder = bloomFilterIndex.toBuilder();
        builder.addBloomFilter(bloomFilter);
        OrcProto.BloomFilterIndex index = builder.build();
        Assert.assertTrue((boolean)index.isInitialized());
        Assert.assertEquals((int)index.getBloomFilterCount(), (int)1);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        index.writeTo((OutputStream)os);
        os.flush();
        return os.toByteArray();
    }

    private static OrcProto.BloomFilter toOrcBloomFilter(BloomFilter bloomFilter) {
        OrcProto.BloomFilter.Builder builder = OrcProto.BloomFilter.newBuilder();
        builder.addAllBitset((Iterable)Longs.asList((long[])bloomFilter.getBitSet()));
        builder.setNumHashFunctions(bloomFilter.getNumHashFunctions());
        return builder.build();
    }

    @Test
    public void testBloomFilterPredicateValuesExisting() {
        BloomFilter bloomFilter = new BloomFilter((long)(TEST_VALUES.size() * 10), 0.01);
        for (Object object : TEST_VALUES.keySet()) {
            if (object instanceof Long) {
                bloomFilter.addLong(((Long)object).longValue());
                continue;
            }
            if (object instanceof Integer) {
                bloomFilter.addLong((long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof String) {
                bloomFilter.addString((String)object);
                continue;
            }
            if (object instanceof BigDecimal) {
                bloomFilter.addString(object.toString());
                continue;
            }
            if (object instanceof Slice) {
                bloomFilter.addString(((Slice)object).toStringUtf8());
                continue;
            }
            if (object instanceof Timestamp) {
                bloomFilter.addLong(((Timestamp)object).getTime());
                continue;
            }
            if (object instanceof Double) {
                bloomFilter.addDouble(((Double)object).doubleValue());
                continue;
            }
            Assert.fail((String)("Unsupported type " + object.getClass()));
        }
        for (Map.Entry entry : TEST_VALUES.entrySet()) {
            boolean matched = TupleDomainOrcPredicate.checkInBloomFilter((BloomFilter)bloomFilter, entry.getKey(), (Type)((Type)entry.getValue()));
            Assert.assertTrue((boolean)matched, (String)("type " + entry.getClass()));
        }
        Assert.assertTrue((boolean)TupleDomainOrcPredicate.checkInBloomFilter((BloomFilter)bloomFilter, (Object)new Date(), (Type)DateType.DATE), (String)"unsupported type DATE should always return true");
    }

    @Test
    public void testBloomFilterPredicateValuesNonExisting() {
        BloomFilter bloomFilter = new BloomFilter((long)(TEST_VALUES.size() * 10), 0.01);
        for (Map.Entry<Object, Type> testValue : TEST_VALUES.entrySet()) {
            boolean matched = TupleDomainOrcPredicate.checkInBloomFilter((BloomFilter)bloomFilter, (Object)testValue.getKey(), (Type)testValue.getValue());
            Assert.assertFalse((boolean)matched, (String)("type " + testValue.getKey().getClass()));
        }
        Assert.assertTrue((boolean)TupleDomainOrcPredicate.checkInBloomFilter((BloomFilter)bloomFilter, (Object)new Date(), (Type)DateType.DATE), (String)"unsupported type DATE should always return true");
    }

    @Test
    public void testExtractValuesFromSingleDomain() {
        ImmutableMap testValues = ImmutableMap.builder().put((Object)BooleanType.BOOLEAN, (Object)true).put((Object)IntegerType.INTEGER, (Object)1234L).put((Object)BigintType.BIGINT, (Object)4321L).put((Object)DoubleType.DOUBLE, (Object)0.123).put((Object)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)TEST_STRING)).build();
        for (Map.Entry testValue : testValues.entrySet()) {
            Domain predicateDomain = Domain.singleValue((Type)((Type)testValue.getKey()), testValue.getValue());
            Optional discreteValues = TupleDomainOrcPredicate.extractDiscreteValues((ValueSet)predicateDomain.getValues());
            Assert.assertTrue((boolean)discreteValues.isPresent());
            Collection objects = (Collection)discreteValues.get();
            Assert.assertEquals((int)objects.size(), (int)1);
            Assert.assertEquals(objects.iterator().next(), testValue.getValue());
        }
    }

    @Test
    public void testMatches() {
        Domain testingColumnHandleDomain = Domain.singleValue((Type)BigintType.BIGINT, (Object)1234L);
        TupleDomain.ColumnDomain column0 = new TupleDomain.ColumnDomain((Object)COLUMN_0, testingColumnHandleDomain);
        TupleDomain effectivePredicate = TupleDomain.fromColumnDomains(Optional.of(ImmutableList.of((Object)column0)));
        TupleDomain emptyEffectivePredicate = TupleDomain.all();
        ImmutableList columnReferences = ImmutableList.builder().add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)COLUMN_0, 0, (Type)BigintType.BIGINT)).add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)COLUMN_1, 1, (Type)BigintType.BIGINT)).build();
        TupleDomainOrcPredicate predicate = new TupleDomainOrcPredicate(effectivePredicate, (List)columnReferences, true, Optional.empty());
        TupleDomainOrcPredicate emptyPredicate = new TupleDomainOrcPredicate(emptyEffectivePredicate, (List)columnReferences, true, Optional.empty());
        HiveBloomFilter hiveBloomFilter = new HiveBloomFilter(new BloomFilter(1000L, 0.01));
        OrcProto.BloomFilter emptyOrcBloomFilter = TestOrcBloomFilters.toOrcBloomFilter((BloomFilter)hiveBloomFilter);
        hiveBloomFilter.addLong(1234L);
        OrcProto.BloomFilter orcBloomFilter = TestOrcBloomFilters.toOrcBloomFilter((BloomFilter)hiveBloomFilter);
        ImmutableMap matchingStatisticsByColumnIndex = ImmutableMap.of((Object)0, (Object)new IntegerColumnStatistics(null, TestOrcBloomFilters.toHiveBloomFilter(orcBloomFilter), new IntegerStatistics(Long.valueOf(10L), Long.valueOf(2000L), null)));
        ImmutableMap nonMatchingStatisticsByColumnIndex = ImmutableMap.of((Object)0, (Object)new IntegerColumnStatistics(null, TestOrcBloomFilters.toHiveBloomFilter(emptyOrcBloomFilter), new IntegerStatistics(Long.valueOf(10L), Long.valueOf(2000L), null)));
        ImmutableMap withoutBloomFilterStatisticsByColumnIndex = ImmutableMap.of((Object)0, (Object)new IntegerColumnStatistics(null, null, new IntegerStatistics(Long.valueOf(10L), Long.valueOf(2000L), null)));
        Assert.assertTrue((boolean)predicate.matches(1L, (Map)matchingStatisticsByColumnIndex));
        Assert.assertTrue((boolean)predicate.matches(1L, (Map)withoutBloomFilterStatisticsByColumnIndex));
        Assert.assertFalse((boolean)predicate.matches(1L, (Map)nonMatchingStatisticsByColumnIndex));
        Assert.assertTrue((boolean)emptyPredicate.matches(1L, (Map)matchingStatisticsByColumnIndex));
    }

    private static HiveBloomFilter toHiveBloomFilter(OrcProto.BloomFilter emptyOrcBloomFilter) {
        return new HiveBloomFilter(emptyOrcBloomFilter.getBitsetList(), emptyOrcBloomFilter.getBitsetCount() * 64, emptyOrcBloomFilter.getNumHashFunctions());
    }
}

