/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.orc.cache.OrcCacheConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestOrcCacheConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OrcCacheConfig)ConfigAssertions.recordDefaults(OrcCacheConfig.class)).setFileTailCacheEnabled(false).setFileTailCacheSize(new DataSize(0.0, DataSize.Unit.BYTE)).setFileTailCacheTtlSinceLastAccess(new Duration(0.0, TimeUnit.SECONDS)).setStripeMetadataCacheEnabled(false).setStripeFooterCacheSize(new DataSize(0.0, DataSize.Unit.BYTE)).setStripeFooterCacheTtlSinceLastAccess(new Duration(0.0, TimeUnit.SECONDS)).setStripeStreamCacheSize(new DataSize(0.0, DataSize.Unit.BYTE)).setStripeStreamCacheTtlSinceLastAccess(new Duration(0.0, TimeUnit.SECONDS)).setRowGroupIndexCacheEnabled(false).setRowGroupIndexCacheSize(new DataSize(0.0, DataSize.Unit.BYTE)).setRowGroupIndexCacheTtlSinceLastAccess(new Duration(0.0, TimeUnit.SECONDS)).setDwrfStripeCacheEnabled(false).setExpectedFileTailSize(new DataSize(16384.0, DataSize.Unit.BYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"orc.file-tail-cache-enabled", (Object)"true").put((Object)"orc.file-tail-cache-size", (Object)"1GB").put((Object)"orc.file-tail-cache-ttl-since-last-access", (Object)"10m").put((Object)"orc.stripe-metadata-cache-enabled", (Object)"true").put((Object)"orc.stripe-footer-cache-size", (Object)"2GB").put((Object)"orc.stripe-footer-cache-ttl-since-last-access", (Object)"5m").put((Object)"orc.stripe-stream-cache-size", (Object)"3GB").put((Object)"orc.stripe-stream-cache-ttl-since-last-access", (Object)"10m").put((Object)"orc.row-group-index-cache-enabled", (Object)"true").put((Object)"orc.row-group-index-cache-size", (Object)"4GB").put((Object)"orc.row-group-index-cache-ttl-since-last-access", (Object)"5m").put((Object)"orc.dwrf-stripe-cache-enabled", (Object)"true").put((Object)"orc.expected-file-tail-size", (Object)"8MB").build();
        OrcCacheConfig expected = new OrcCacheConfig().setFileTailCacheEnabled(true).setFileTailCacheSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setFileTailCacheTtlSinceLastAccess(new Duration(10.0, TimeUnit.MINUTES)).setStripeMetadataCacheEnabled(true).setStripeFooterCacheSize(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setStripeFooterCacheTtlSinceLastAccess(new Duration(5.0, TimeUnit.MINUTES)).setStripeStreamCacheSize(new DataSize(3.0, DataSize.Unit.GIGABYTE)).setStripeStreamCacheTtlSinceLastAccess(new Duration(10.0, TimeUnit.MINUTES)).setRowGroupIndexCacheEnabled(true).setRowGroupIndexCacheSize(new DataSize(4.0, DataSize.Unit.GIGABYTE)).setRowGroupIndexCacheTtlSinceLastAccess(new Duration(5.0, TimeUnit.MINUTES)).setDwrfStripeCacheEnabled(true).setExpectedFileTailSize(new DataSize(8.0, DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

