/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSourceUtils;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcDataSourceUtils {
    @Test
    public void testMergeSingle() {
        List diskRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)ImmutableList.of((Object)new DiskRange(100L, 100)), (DataSize)new DataSize(0.0, DataSize.Unit.BYTE), (DataSize)new DataSize(0.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Collection)diskRanges, (Collection)ImmutableList.of((Object)new DiskRange(100L, 100)));
    }

    @Test
    public void testMergeAdjacent() {
        List diskRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)ImmutableList.of((Object)new DiskRange(100L, 100), (Object)new DiskRange(200L, 100), (Object)new DiskRange(300L, 100)), (DataSize)new DataSize(0.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE));
        Assert.assertEquals((Collection)diskRanges, (Collection)ImmutableList.of((Object)new DiskRange(100L, 300)));
    }

    @Test
    public void testMergeGap() {
        ImmutableList consistent10ByteGap = ImmutableList.of((Object)new DiskRange(100L, 90), (Object)new DiskRange(200L, 90), (Object)new DiskRange(300L, 90));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(0.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)consistent10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(9.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)consistent10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 290)));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(100.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 290)));
        ImmutableList middle10ByteGap = ImmutableList.of((Object)new DiskRange(100L, 80), (Object)new DiskRange(200L, 90), (Object)new DiskRange(300L, 80), (Object)new DiskRange(400L, 90));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(0.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)middle10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(9.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)middle10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 80), (Object)new DiskRange(200L, 180), (Object)new DiskRange(400L, 90)));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(100.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 390)));
    }

    @Test
    public void testMergeMaxSize() {
        ImmutableList consistent10ByteGap = ImmutableList.of((Object)new DiskRange(100L, 90), (Object)new DiskRange(200L, 90), (Object)new DiskRange(300L, 90));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(0.0, DataSize.Unit.BYTE)), (Collection)consistent10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(100.0, DataSize.Unit.BYTE)), (Collection)consistent10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(190.0, DataSize.Unit.BYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 190), (Object)new DiskRange(300L, 90)));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(200.0, DataSize.Unit.BYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 190), (Object)new DiskRange(300L, 90)));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)consistent10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(290.0, DataSize.Unit.BYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 290)));
        ImmutableList middle10ByteGap = ImmutableList.of((Object)new DiskRange(100L, 80), (Object)new DiskRange(200L, 90), (Object)new DiskRange(300L, 80), (Object)new DiskRange(400L, 90));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(0.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)middle10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(9.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)middle10ByteGap);
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 80), (Object)new DiskRange(200L, 180), (Object)new DiskRange(400L, 90)));
        Assert.assertEquals((Collection)OrcDataSourceUtils.mergeAdjacentDiskRanges((Collection)middle10ByteGap, (DataSize)new DataSize(100.0, DataSize.Unit.BYTE), (DataSize)new DataSize(1.0, DataSize.Unit.GIGABYTE)), (Collection)ImmutableList.of((Object)new DiskRange(100L, 390)));
    }
}

