/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.CapturingOrcFileIntrospector;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcFileIntrospection {
    @Test
    public void testFileIntrospection() throws Exception {
        IntegerType type = IntegerType.INTEGER;
        CapturingOrcFileIntrospector introspector = new CapturingOrcFileIntrospector();
        Page page = TestOrcFileIntrospection.createTestPage((Type)type, 15);
        try (TempFile tempFile = new TempFile();){
            this.writeFile((Type)type, page, tempFile);
            TestOrcFileIntrospection.readFile((Type)type, introspector, tempFile);
        }
        Assert.assertNotNull((Object)introspector.getFileTail());
        Assert.assertNotNull((Object)introspector.getFileFooter());
        Assert.assertEquals((long)introspector.getFileFooter().getNumberOfRows(), (long)15L);
        Assert.assertEquals((int)introspector.getStripes().size(), (int)2);
        Assert.assertEquals((long)introspector.getStripes().get(0).getRowCount(), (long)10L);
        Assert.assertEquals((long)introspector.getStripes().get(1).getRowCount(), (long)5L);
        Assert.assertEquals((int)introspector.getStripeInformations().size(), (int)2);
        Assert.assertEquals((long)introspector.getStripeInformations().get(0).getNumberOfRows(), (long)10L);
        Assert.assertEquals((long)introspector.getStripeInformations().get(1).getNumberOfRows(), (long)5L);
        Assert.assertEquals((int)introspector.getRowGroupIndexesByStripeOffset().size(), (int)2);
        Assert.assertEquals((int)introspector.getFileFooter().getFileStats().size(), (int)2);
        Map<StreamId, List<RowGroupIndex>> stripeRowGroupIndexes1 = introspector.getRowGroupIndexesByStripeOffset().get(introspector.getStripeInformations().get(0).getOffset());
        Map<StreamId, List<RowGroupIndex>> stripeRowGroupIndexes2 = introspector.getRowGroupIndexesByStripeOffset().get(introspector.getStripeInformations().get(1).getOffset());
        List<RowGroupIndex> rowGroupIndexes1 = stripeRowGroupIndexes1.get(new StreamId(1, 0, Stream.StreamKind.ROW_INDEX));
        List<RowGroupIndex> rowGroupIndexes2 = stripeRowGroupIndexes2.get(new StreamId(1, 0, Stream.StreamKind.ROW_INDEX));
        Assert.assertEquals((int)rowGroupIndexes1.size(), (int)2);
        Assert.assertEquals((int)rowGroupIndexes2.size(), (int)1);
        Assert.assertNotNull((Object)rowGroupIndexes1.get(0).getColumnStatistics());
        Assert.assertNotNull((Object)rowGroupIndexes1.get(1).getColumnStatistics());
        Assert.assertNotNull((Object)rowGroupIndexes2.get(0).getColumnStatistics());
    }

    private void writeFile(Type type, Page page, TempFile tempFile) throws IOException {
        DefaultOrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(10).build();
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)flushPolicy).withRowGroupMaxRowCount(5).build();
        try (OrcWriter orcWriter = OrcTester.createOrcWriter(tempFile.getFile(), OrcEncoding.DWRF, CompressionKind.ZSTD, Optional.empty(), (List<Type>)ImmutableList.of((Object)type), writerOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);){
            orcWriter.write(page);
        }
    }

    private static void readFile(Type type, CapturingOrcFileIntrospector introspector, TempFile tempFile) throws IOException {
        FileOrcDataSource dataSource = new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReaderOptions readerOptions = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).build();
        OrcReader reader = new OrcReader((OrcDataSource)dataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), Optional.empty(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, readerOptions, false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats(), Optional.of(introspector));
        OrcSelectiveRecordReader recordReader = reader.createSelectiveRecordReader((Map)ImmutableMap.of((Object)0, (Object)type), (List)ImmutableList.of((Object)0), Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), OrcPredicate.TRUE, 0L, dataSource.getSize(), DateTimeZone.UTC, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, Optional.empty(), 1000);
        while (recordReader.getNextPage() != null) {
        }
        recordReader.close();
    }

    private static Page createTestPage(Type type, int positionCount) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            type.writeLong(blockBuilder, (long)i);
        }
        return new Page(new Block[]{blockBuilder.build()});
    }
}

