/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.orc.AbstractOrcDataSource;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.units.DataSize;
import java.net.URL;
import java.util.Map;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcLz4 {
    private static final DataSize SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);

    @Test
    public void testReadLz4() throws Exception {
        int batchSize;
        byte[] data = Resources.toByteArray((URL)Resources.getResource((String)"apache-lz4.orc"));
        OrcReader orcReader = new OrcReader((OrcDataSource)new InMemoryOrcDataSource(data), OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(SIZE).withTinyStripeThreshold(SIZE).withMaxBlockSize(SIZE).build(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
        Assert.assertEquals((Object)orcReader.getCompressionKind(), (Object)CompressionKind.LZ4);
        Assert.assertEquals((long)orcReader.getFooter().getNumberOfRows(), (long)10000L);
        ImmutableMap includedColumns = ImmutableMap.builder().put((Object)0, (Object)BigintType.BIGINT).put((Object)1, (Object)IntegerType.INTEGER).put((Object)2, (Object)BigintType.BIGINT).build();
        OrcBatchRecordReader reader = orcReader.createBatchRecordReader((Map)includedColumns, OrcPredicate.TRUE, DateTimeZone.UTC, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), 1);
        int rows = 0;
        while ((batchSize = reader.nextBatch()) > 0) {
            rows += batchSize;
            Block xBlock = reader.readBlock(0);
            Block yBlock = reader.readBlock(1);
            Block zBlock = reader.readBlock(2);
            for (int position = 0; position < batchSize; ++position) {
                BigintType.BIGINT.getLong(xBlock, position);
                IntegerType.INTEGER.getLong(yBlock, position);
                BigintType.BIGINT.getLong(zBlock, position);
            }
        }
        Assert.assertEquals((long)rows, (long)reader.getFileRowCount());
    }

    private static class InMemoryOrcDataSource
    extends AbstractOrcDataSource {
        private final byte[] data;

        public InMemoryOrcDataSource(byte[] data) {
            super(new OrcDataSourceId("memory"), (long)data.length, SIZE, SIZE, SIZE, false);
            this.data = data;
        }

        protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
            System.arraycopy(this.data, Math.toIntExact(position), buffer, bufferOffset, bufferLength);
        }
    }
}

