/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.testing.TestingEnvironment;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOrcMapNullKey {
    @DataProvider(name="mapNullKeysEnabled")
    public static Object[][] mapNullKeysEnabled() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="mapNullKeysEnabled")
    public void testMapTypeWithNullsWithBatchReader(boolean mapNullKeysEnabled) throws Exception {
        MapType mapType = TestOrcMapNullKey.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        Map<Long, Long> map = TestOrcMapNullKey.generateMap();
        HashMap<Long, Long> expectedToRead = new HashMap<Long, Long>(map);
        if (!mapNullKeysEnabled) {
            expectedToRead.remove(null);
        }
        try (TempFile tempFile = TestOrcMapNullKey.createSingleColumnMapFileWithNullValues((Type)mapType, map);
             OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)mapType, 1, false, mapNullKeysEnabled);){
            int batchSize = reader.nextBatch();
            Assert.assertEquals((int)batchSize, (int)1);
            Assert.assertEquals(TestOrcMapNullKey.readMap(reader.readBlock(0), 0), expectedToRead);
            Assert.assertEquals((int)reader.nextBatch(), (int)-1);
        }
    }

    @Test(dataProvider="mapNullKeysEnabled")
    public void testMapTypeWithNullsWithSelectiveReader(boolean mapNullKeysEnabled) throws Exception {
        MapType mapType = TestOrcMapNullKey.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        Map<Long, Long> map = TestOrcMapNullKey.generateMap();
        HashMap<Long, Long> expectedToRead = new HashMap<Long, Long>(map);
        if (!mapNullKeysEnabled) {
            expectedToRead.remove(null);
        }
        try (TempFile tempFile = TestOrcMapNullKey.createSingleColumnMapFileWithNullValues((Type)mapType, map);
             OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)mapType, 1, mapNullKeysEnabled, false);){
            Assert.assertEquals(TestOrcMapNullKey.readMap(reader.getNextPage().getBlock(0).getLoadedBlock(), 0), expectedToRead);
            Assert.assertNull((Object)reader.getNextPage());
        }
    }

    private static Map<Long, Long> generateMap() {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (long i = 0L; i < 10L; ++i) {
            map.put(i, i + 1L);
            map.put(-i, null);
        }
        map.put(null, 0L);
        return map;
    }

    private static Map<Long, Long> readMap(Block block, int rowId) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Assert.assertFalse((boolean)columnarMap.isNull(rowId));
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        HashMap<Long, Long> actual = new HashMap<Long, Long>();
        for (int i = 0; i < columnarMap.getEntryCount(rowId); ++i) {
            int position = columnarMap.getOffset(rowId) + i;
            Long key = keysBlock.isNull(position) ? null : Long.valueOf(BigintType.BIGINT.getLong(keysBlock, position));
            Long value = valuesBlock.isNull(position) ? null : Long.valueOf(BigintType.BIGINT.getLong(valuesBlock, position));
            actual.put(key, value);
        }
        return actual;
    }

    public static MapType createMapType(Type keyType, Type valueType) {
        MethodHandle keyNativeEquals = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{keyType, keyType});
        MethodHandle keyBlockEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeHashCode = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{keyType});
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        return new MapType(keyType, valueType, keyBlockEquals, keyBlockHashCode);
    }

    private static TempFile createSingleColumnMapFileWithNullValues(Type mapType, Map<Long, Long> map) throws IOException {
        OrcSerde serde = new OrcSerde();
        TempFile tempFile = new TempFile();
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(tempFile.getFile(), OrcTester.Format.ORC_12, CompressionKind.NONE, mapType);
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", mapType);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        objectInspector.setStructFieldData(row, field, map);
        Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
        writer.write(record);
        writer.close(false);
        return tempFile;
    }
}

