/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.NoopOrcLocalMemoryContext;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.facebook.presto.orc.writer.CompressionBufferPool;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcOutputBuffer {
    private static final OrcDataSourceId DATA_SOURCE_ID = new OrcDataSourceId("test");

    @Test
    public void testWriteHugeByteChucks() {
        int size = 0x100000;
        byte[] largeByteArray = new byte[size];
        Arrays.fill(largeByteArray, (byte)10);
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.NONE).build();
        OrcOutputBuffer orcOutputBuffer = new OrcOutputBuffer(columnWriterOptions, Optional.empty());
        DynamicSliceOutput output = new DynamicSliceOutput(size);
        orcOutputBuffer.writeBytes(largeByteArray, 10, size - 10);
        orcOutputBuffer.flush();
        Assert.assertEquals((int)orcOutputBuffer.writeDataTo((SliceOutput)output), (int)(size - 10));
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])largeByteArray, (int)10, (int)(size - 10)));
        orcOutputBuffer.reset();
        output.reset();
        orcOutputBuffer.writeBytes(Slices.wrappedBuffer((byte[])largeByteArray), 100, size - 100);
        orcOutputBuffer.flush();
        Assert.assertEquals((int)orcOutputBuffer.writeDataTo((SliceOutput)output), (int)(size - 100));
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])largeByteArray, (int)100, (int)(size - 100)));
    }

    @Test
    public void testWriteHugeByteChucksUsesMaxCompressionBufferSizeChunks() {
        int size = 0x100000;
        byte[] largeByteArray = new byte[size];
        Arrays.fill(largeByteArray, (byte)10);
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZSTD).setCompressionLevel(OptionalInt.of(7)).setCompressionMaxBufferSize(new DataSize(256.0, DataSize.Unit.KILOBYTE)).build();
        OrcOutputBuffer orcOutputBuffer = new OrcOutputBuffer(columnWriterOptions, Optional.empty());
        DynamicSliceOutput output = new DynamicSliceOutput(size);
        orcOutputBuffer.writeBytes(largeByteArray, 10, size - 10);
        orcOutputBuffer.flush();
        Assert.assertTrue((orcOutputBuffer.writeDataTo((SliceOutput)output) < 200 ? 1 : 0) != 0);
        orcOutputBuffer.reset();
        output.reset();
        orcOutputBuffer.writeBytes(Slices.wrappedBuffer((byte[])largeByteArray), 100, size - 100);
        orcOutputBuffer.flush();
        Assert.assertTrue((orcOutputBuffer.writeDataTo((SliceOutput)output) < 200 ? 1 : 0) != 0);
    }

    @Test
    public void testGrowCapacity() {
        byte[] largeByteArray = new byte[4096];
        DataSize maxCompressionSize = new DataSize(3000.0, DataSize.Unit.BYTE);
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.NONE).setCompressionMaxBufferSize(maxCompressionSize).build();
        OrcOutputBuffer sliceOutput = new OrcOutputBuffer(columnWriterOptions, Optional.empty());
        sliceOutput.writeBytes(largeByteArray, 0, 200);
        Assert.assertEquals((int)sliceOutput.getBufferCapacity(), (int)256);
        sliceOutput.writeBytes(largeByteArray, 0, 200);
        Assert.assertEquals((int)sliceOutput.getBufferCapacity(), (int)512);
        sliceOutput.writeBytes(largeByteArray, 0, 1200);
        Assert.assertEquals((int)sliceOutput.getBufferCapacity(), (int)1600);
        sliceOutput.writeBytes(largeByteArray, 0, 2500);
        Assert.assertEquals((int)sliceOutput.getBufferCapacity(), (int)3000);
        DynamicSliceOutput output = new DynamicSliceOutput(6000);
        sliceOutput.close();
        Assert.assertEquals((int)sliceOutput.writeDataTo((SliceOutput)output), (int)4100);
    }

    @Test
    public void testMinCompressibleSize() {
        int size = 1024;
        byte[] byteArray = new byte[size];
        Arrays.fill(byteArray, (byte)10);
        CapturingCompressionBufferPool pool = new CapturingCompressionBufferPool();
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZSTD).setCompressionBufferPool((CompressionBufferPool)pool).build();
        OrcOutputBuffer orcOutputBuffer = new OrcOutputBuffer(columnWriterOptions, Optional.empty());
        orcOutputBuffer.writeBytes(byteArray, 0, CompressionKind.ZSTD.getMinCompressibleSize() - 1);
        orcOutputBuffer.flush();
        Assert.assertEquals((int)pool.getLastUsedSize(), (int)0);
        orcOutputBuffer.reset();
        orcOutputBuffer.writeBytes(byteArray, 0, CompressionKind.ZSTD.getMinCompressibleSize());
        orcOutputBuffer.flush();
        Assert.assertTrue((pool.getLastUsedSize() > CompressionKind.ZSTD.getMinCompressibleSize() ? 1 : 0) != 0);
        orcOutputBuffer.reset();
        orcOutputBuffer.writeBytes(byteArray, 0, CompressionKind.ZSTD.getMinCompressibleSize() + 10);
        orcOutputBuffer.flush();
        Assert.assertTrue((pool.getLastUsedSize() > CompressionKind.ZSTD.getMinCompressibleSize() + 10 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteZeros() {
        DataSize chunkSize = new DataSize(700.0, DataSize.Unit.BYTE);
        DataSize maxCompressionSize = new DataSize((double)(chunkSize.toBytes() + 3L), DataSize.Unit.BYTE);
        DataSize dataSize = new DataSize(1410.0, DataSize.Unit.BYTE);
        byte[] testData = new byte[(int)dataSize.toBytes()];
        Arrays.fill(testData, (byte)0);
        List<DataSize> expectedChunkSizes = TestOrcOutputBuffer.buildExpectedChunks(chunkSize, dataSize);
        List<List<DataSize>> allWritePieces = TestOrcOutputBuffer.buildWriteChunksCombos(dataSize, 3);
        for (List<DataSize> pieces : allWritePieces) {
            OrcOutputBuffer sliceOutput = TestOrcOutputBuffer.createOrcOutputBuffer(maxCompressionSize);
            for (DataSize piece : pieces) {
                sliceOutput.writeZero((int)piece.toBytes());
            }
            sliceOutput.close();
            this.assertCompressedContent(sliceOutput, testData, expectedChunkSizes);
        }
    }

    @Test
    public void testWriteBytesFromInputStream() throws IOException {
        DataSize chunkSize = new DataSize(700.0, DataSize.Unit.BYTE);
        DataSize maxCompressionSize = new DataSize((double)(chunkSize.toBytes() + 3L), DataSize.Unit.BYTE);
        DataSize dataSize = new DataSize(1410.0, DataSize.Unit.BYTE);
        byte[] testData = TestOrcOutputBuffer.createTestData(dataSize);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testData);
        List<DataSize> expectedChunkSizes = TestOrcOutputBuffer.buildExpectedChunks(chunkSize, dataSize);
        List<List<DataSize>> allWriteChunks = TestOrcOutputBuffer.buildWriteChunksCombos(dataSize, 3);
        for (List<DataSize> writeChunks : allWriteChunks) {
            OrcOutputBuffer sliceOutput = TestOrcOutputBuffer.createOrcOutputBuffer(maxCompressionSize);
            ((InputStream)inputStream).reset();
            for (DataSize writeChunk : writeChunks) {
                sliceOutput.writeBytes((InputStream)inputStream, (int)writeChunk.toBytes());
            }
            this.assertCompressedContent(sliceOutput, testData, expectedChunkSizes);
        }
    }

    @Test
    public void testWriteBytes() {
        DataSize chunkSize = new DataSize(700.0, DataSize.Unit.BYTE);
        DataSize maxCompressionSize = new DataSize((double)(chunkSize.toBytes() + 3L), DataSize.Unit.BYTE);
        DataSize dataSize = new DataSize(1410.0, DataSize.Unit.BYTE);
        byte[] testData = TestOrcOutputBuffer.createTestData(dataSize);
        List<DataSize> expectedChunkSizes = TestOrcOutputBuffer.buildExpectedChunks(chunkSize, dataSize);
        List<List<DataSize>> allWriteChunks = TestOrcOutputBuffer.buildWriteChunksCombos(dataSize, 3);
        for (List<DataSize> writeChunks : allWriteChunks) {
            this.assertWriteBytes(testData, maxCompressionSize, writeChunks, expectedChunkSizes);
        }
    }

    @Test
    public void testWriteBytesSliceView() {
        DataSize chunkSize = new DataSize(700.0, DataSize.Unit.BYTE);
        DataSize maxCompressionSize = new DataSize((double)(chunkSize.toBytes() + 3L), DataSize.Unit.BYTE);
        DataSize dataSize = new DataSize(1410.0, DataSize.Unit.BYTE);
        byte[] testData = TestOrcOutputBuffer.createTestData(dataSize);
        byte[] testDataEx = new byte[testData.length + 10];
        System.arraycopy(testData, 0, testDataEx, 5, testData.length);
        Slice slice = Slices.wrappedBuffer((byte[])testDataEx).slice(5, testData.length);
        List<DataSize> expectedChunkSizes = TestOrcOutputBuffer.buildExpectedChunks(chunkSize, dataSize);
        ArrayList<DataSize> writeChunks = new ArrayList<DataSize>(expectedChunkSizes);
        Collections.reverse(writeChunks);
        OrcOutputBuffer orcOutputBuffer = TestOrcOutputBuffer.createOrcOutputBuffer(maxCompressionSize);
        int offset = 0;
        for (DataSize size : writeChunks) {
            int sizeBytes = (int)size.toBytes();
            orcOutputBuffer.writeBytes(slice, offset, sizeBytes);
            offset += sizeBytes;
        }
        this.assertCompressedContent(orcOutputBuffer, testData, expectedChunkSizes);
    }

    @Test
    public void testWriteBytesEmptySlice() {
        OrcOutputBuffer orcOutputBuffer = TestOrcOutputBuffer.createOrcOutputBuffer(new DataSize(256.0, DataSize.Unit.KILOBYTE));
        orcOutputBuffer.writeBytes(Slices.EMPTY_SLICE);
        this.assertCompressedContent(orcOutputBuffer, new byte[0], (List<DataSize>)ImmutableList.of());
        orcOutputBuffer = TestOrcOutputBuffer.createOrcOutputBuffer(new DataSize(256.0, DataSize.Unit.KILOBYTE));
        orcOutputBuffer.writeBytes(Slices.EMPTY_SLICE, 0, 0);
        this.assertCompressedContent(orcOutputBuffer, new byte[0], (List<DataSize>)ImmutableList.of());
    }

    @Test
    public void testWriteBytesEmptyBytes() {
        OrcOutputBuffer orcOutputBuffer = TestOrcOutputBuffer.createOrcOutputBuffer(new DataSize(256.0, DataSize.Unit.KILOBYTE));
        orcOutputBuffer.writeBytes(new byte[0]);
        this.assertCompressedContent(orcOutputBuffer, new byte[0], (List<DataSize>)ImmutableList.of());
        orcOutputBuffer = TestOrcOutputBuffer.createOrcOutputBuffer(new DataSize(256.0, DataSize.Unit.KILOBYTE));
        orcOutputBuffer.writeBytes(new byte[0], 0, 0);
        this.assertCompressedContent(orcOutputBuffer, new byte[0], (List<DataSize>)ImmutableList.of());
    }

    private void assertWriteBytes(byte[] byteArray, DataSize maxCompressionBufferSize, List<DataSize> writeChunks, List<DataSize> expectedDecompressedChunks) {
        OrcOutputBuffer orcOutputBufferBytes = this.writeToOrcOutputBuffer(byteArray, maxCompressionBufferSize, WriteMode.BYTES, writeChunks);
        this.assertCompressedContent(orcOutputBufferBytes, byteArray, expectedDecompressedChunks);
        OrcOutputBuffer orcOutputBufferSlice = this.writeToOrcOutputBuffer(byteArray, maxCompressionBufferSize, WriteMode.SLICE, writeChunks);
        this.assertCompressedContent(orcOutputBufferSlice, byteArray, expectedDecompressedChunks);
    }

    private OrcOutputBuffer writeToOrcOutputBuffer(byte[] bytes, DataSize maxBufferSize, WriteMode writeMode, List<DataSize> sizes) {
        OrcOutputBuffer orcOutputBuffer = TestOrcOutputBuffer.createOrcOutputBuffer(maxBufferSize);
        int offset = 0;
        Slice slice = Slices.wrappedBuffer((byte[])bytes);
        for (DataSize size : sizes) {
            int sizeBytes = (int)size.toBytes();
            if (writeMode == WriteMode.BYTES) {
                orcOutputBuffer.writeBytes(bytes, offset, sizeBytes);
            } else {
                orcOutputBuffer.writeBytes(slice, offset, sizeBytes);
            }
            offset += sizeBytes;
        }
        orcOutputBuffer.flush();
        return orcOutputBuffer;
    }

    private void assertCompressedContent(OrcOutputBuffer orcOutputBuffer, byte[] expectedBytes, List<DataSize> expectedChunkSizes) {
        orcOutputBuffer.flush();
        DynamicSliceOutput output = new DynamicSliceOutput(orcOutputBuffer.size());
        orcOutputBuffer.writeDataTo((SliceOutput)output);
        List expectedSizes = expectedChunkSizes.stream().map(size -> (int)size.toBytes()).collect(Collectors.toList());
        DecompressionResult result = this.decompress(output.slice());
        Assert.assertEquals((Object)Slices.wrappedBuffer((byte[])result.bytes), (Object)Slices.wrappedBuffer((byte[])expectedBytes));
        Assert.assertEquals(result.sizes, expectedSizes);
    }

    private DecompressionResult decompress(Slice slice) {
        OrcDecompressor decompressor = (OrcDecompressor)OrcDecompressor.createOrcDecompressor((OrcDataSourceId)DATA_SOURCE_ID, (CompressionKind)CompressionKind.ZSTD, (int)262144).get();
        SharedBuffer decompressionBuffer = new SharedBuffer((OrcLocalMemoryContext)NoopOrcLocalMemoryContext.NOOP_ORC_LOCAL_MEMORY_CONTEXT);
        ImmutableList.Builder sizes = ImmutableList.builder();
        BasicSliceInput input = slice.getInput();
        DecompressorOutputBuffer decompressorOutputBuffer = new DecompressorOutputBuffer();
        ByteArrayOutputStream decompressedStream = new ByteArrayOutputStream();
        while (input.isReadable()) {
            int b0 = input.readUnsignedByte();
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            int chunkLength = b2 << 15 | b1 << 7 | b0 >>> 1;
            boolean isUncompressed = (b0 & 1) == 1;
            decompressionBuffer.ensureCapacity(chunkLength);
            byte[] compressedBuffer = decompressionBuffer.get();
            int readCompressed = input.read(compressedBuffer, 0, chunkLength);
            if (isUncompressed) {
                decompressedStream.write(compressedBuffer, 0, chunkLength);
                sizes.add((Object)chunkLength);
                continue;
            }
            int length = decompressor.decompress(compressedBuffer, 0, readCompressed, (OrcDecompressor.OutputBuffer)decompressorOutputBuffer);
            decompressedStream.write(decompressorOutputBuffer.buffer, 0, length);
            sizes.add((Object)length);
        }
        return new DecompressionResult((List<Integer>)sizes.build(), decompressedStream.toByteArray());
    }

    private static OrcOutputBuffer createOrcOutputBuffer(DataSize compressionMaxBufferSize) {
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.ZSTD).setCompressionLevel(OptionalInt.of(1)).setCompressionMaxBufferSize(compressionMaxBufferSize).build();
        return new OrcOutputBuffer(columnWriterOptions, Optional.empty());
    }

    private static List<List<DataSize>> buildWriteChunksCombos(DataSize dataSize, int maxDepth) {
        int totalSize = (int)dataSize.toBytes();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int levels = 1; levels <= maxDepth; ++levels) {
            DataSize[] bus = new DataSize[levels];
            TestOrcOutputBuffer.buildWriteChunksCombos(totalSize, levels - 1, bus, (ImmutableList.Builder<List<DataSize>>)builder);
        }
        return builder.build();
    }

    private static void buildWriteChunksCombos(int remaining, int level, DataSize[] bus, ImmutableList.Builder<List<DataSize>> builder) {
        if (level == 0) {
            bus[level] = new DataSize((double)remaining, DataSize.Unit.BYTE);
            builder.add((Object)ImmutableList.copyOf((Object[])bus));
            return;
        }
        for (int i = 1; i < remaining; ++i) {
            bus[level] = new DataSize((double)i, DataSize.Unit.BYTE);
            TestOrcOutputBuffer.buildWriteChunksCombos(remaining - i, level - 1, bus, builder);
        }
    }

    private static List<DataSize> buildExpectedChunks(DataSize chunkSize, DataSize totalSize) {
        long next;
        long chunkSizeBytes = chunkSize.toBytes();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long totalSizeBytes = totalSize.toBytes(); totalSizeBytes > 0L; totalSizeBytes -= next) {
            next = Math.min(chunkSizeBytes, totalSizeBytes);
            builder.add((Object)new DataSize((double)next, DataSize.Unit.BYTE));
        }
        return builder.build();
    }

    private static byte[] createTestData(DataSize size) {
        int sizeInBytes = (int)size.toBytes();
        byte[] bytes = new byte[sizeInBytes];
        for (int i = 0; i < sizeInBytes; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }

    private static class DecompressorOutputBuffer
    implements OrcDecompressor.OutputBuffer {
        byte[] buffer;

        private DecompressorOutputBuffer() {
        }

        public byte[] initialize(int size) {
            this.buffer = com.facebook.presto.common.array.Arrays.ensureCapacity((byte[])this.buffer, (int)size);
            return this.buffer;
        }

        public byte[] grow(int size) {
            if (size > this.buffer.length) {
                this.buffer = Arrays.copyOfRange(this.buffer, 0, size);
            }
            return this.buffer;
        }
    }

    private static class DecompressionResult {
        final List<Integer> sizes;
        final byte[] bytes;

        public DecompressionResult(List<Integer> sizes, byte[] bytes) {
            this.sizes = sizes;
            this.bytes = bytes;
        }
    }

    private static class CapturingCompressionBufferPool
    implements CompressionBufferPool {
        private int lastUsedSize;

        private CapturingCompressionBufferPool() {
        }

        public int getLastUsedSize() {
            return this.lastUsedSize;
        }

        public byte[] checkOut(int length) {
            this.lastUsedSize = length;
            return new byte[length];
        }

        public void checkIn(byte[] buffer) {
        }

        public long getRetainedBytes() {
            return 0L;
        }
    }

    private static enum WriteMode {
        BYTES,
        SLICE;

    }
}

