/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.AbstractTestDwrfStripeCaching;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.DwrfStripeCache;
import com.facebook.presto.orc.proto.DwrfProto;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcReaderDwrfStripeCaching
extends AbstractTestDwrfStripeCaching {
    private static final int READ_TAIL_SIZE_IN_BYTES = 0x100000;
    private static final OrcDataSourceId TEST_DATA_SOURCE_ID = new OrcDataSourceId("test");

    @Test(dataProvider="Stripe cache for ALL stripes with mode BOTH")
    public void testBothAllStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertTrue((boolean)optionalDwrfStripeCache.isPresent());
        DwrfStripeCache dwrfStripeCache = optionalDwrfStripeCache.get();
        DwrfProto.Footer footer = TestOrcReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        Assert.assertEquals((int)stripes.size(), (int)4);
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            for (int i = 0; i < 4; ++i) {
                DwrfProto.StripeInformation stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCachePresent(dwrfStripeCache, file, stripe);
                this.assertStripeFooterCachePresent(dwrfStripeCache, file, stripe);
            }
        }
    }

    @Test(dataProvider="Stripe cache for HALF stripes with mode BOTH")
    public void testBothHalfStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertTrue((boolean)optionalDwrfStripeCache.isPresent());
        DwrfStripeCache dwrfStripeCache = optionalDwrfStripeCache.get();
        DwrfProto.Footer footer = TestOrcReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        Assert.assertEquals((int)stripes.size(), (int)4);
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            DwrfProto.StripeInformation stripe;
            int i;
            for (i = 0; i < 2; ++i) {
                stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCachePresent(dwrfStripeCache, file, stripe);
                this.assertStripeFooterCachePresent(dwrfStripeCache, file, stripe);
            }
            for (i = 2; i < 4; ++i) {
                stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCacheAbsent(dwrfStripeCache, stripe);
                this.assertStripeFooterCacheAbsent(dwrfStripeCache, stripe);
            }
        }
    }

    @Test(dataProvider="Stripe cache for ALL stripes with mode INDEX")
    public void testIndexAllStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertTrue((boolean)optionalDwrfStripeCache.isPresent());
        DwrfStripeCache dwrfStripeCache = optionalDwrfStripeCache.get();
        DwrfProto.Footer footer = TestOrcReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        Assert.assertEquals((int)stripes.size(), (int)4);
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            for (int i = 0; i < 4; ++i) {
                DwrfProto.StripeInformation stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCachePresent(dwrfStripeCache, file, stripe);
                this.assertStripeFooterCacheAbsent(dwrfStripeCache, stripe);
            }
        }
    }

    @Test(dataProvider="Stripe cache for HALF stripes with mode INDEX")
    public void testIndexHalfStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertTrue((boolean)optionalDwrfStripeCache.isPresent());
        DwrfStripeCache dwrfStripeCache = optionalDwrfStripeCache.get();
        DwrfProto.Footer footer = TestOrcReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        Assert.assertEquals((int)stripes.size(), (int)4);
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            DwrfProto.StripeInformation stripe;
            int i;
            for (i = 0; i < 2; ++i) {
                stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCachePresent(dwrfStripeCache, file, stripe);
                this.assertStripeFooterCacheAbsent(dwrfStripeCache, stripe);
            }
            for (i = 2; i < 4; ++i) {
                stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCacheAbsent(dwrfStripeCache, stripe);
                this.assertStripeFooterCacheAbsent(dwrfStripeCache, stripe);
            }
        }
    }

    @Test(dataProvider="Stripe cache for ALL stripes with mode FOOTER")
    public void testFooterAllStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertTrue((boolean)optionalDwrfStripeCache.isPresent());
        DwrfStripeCache dwrfStripeCache = optionalDwrfStripeCache.get();
        DwrfProto.Footer footer = TestOrcReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        Assert.assertEquals((int)stripes.size(), (int)4);
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            for (int i = 0; i < 4; ++i) {
                DwrfProto.StripeInformation stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCacheAbsent(dwrfStripeCache, stripe);
                this.assertStripeFooterCachePresent(dwrfStripeCache, file, stripe);
            }
        }
    }

    @Test(dataProvider="Stripe cache for HALF stripes with mode FOOTER")
    public void testFooterHalfStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertTrue((boolean)optionalDwrfStripeCache.isPresent());
        DwrfStripeCache dwrfStripeCache = optionalDwrfStripeCache.get();
        DwrfProto.Footer footer = TestOrcReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        Assert.assertEquals((int)stripes.size(), (int)4);
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            DwrfProto.StripeInformation stripe;
            int i;
            for (i = 0; i < 2; ++i) {
                stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCacheAbsent(dwrfStripeCache, stripe);
                this.assertStripeFooterCachePresent(dwrfStripeCache, file, stripe);
            }
            for (i = 2; i < 4; ++i) {
                stripe = (DwrfProto.StripeInformation)stripes.get(i);
                this.assertStripeIndexCacheAbsent(dwrfStripeCache, stripe);
                this.assertStripeFooterCacheAbsent(dwrfStripeCache, stripe);
            }
        }
    }

    @Test(dataProvider="Stripe cache with mode NONE")
    public void testNoneAllStripes(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertFalse((boolean)optionalDwrfStripeCache.isPresent());
    }

    @Test(dataProvider="Stripe cache disabled")
    public void testStripeCacheDisabled(File orcFile) throws IOException {
        Optional<DwrfStripeCache> optionalDwrfStripeCache = this.getDwrfStripeCache(orcFile);
        Assert.assertFalse((boolean)optionalDwrfStripeCache.isPresent());
    }

    private void assertStripeIndexCachePresent(DwrfStripeCache dwrfStripeCache, RandomAccessFile file, DwrfProto.StripeInformation stripe) throws IOException {
        StripeReader.StripeId stripeId = new StripeReader.StripeId(TEST_DATA_SOURCE_ID, stripe.getOffset());
        Optional stripeIndexSlice = dwrfStripeCache.getIndexStreamsSlice(stripeId);
        Assert.assertTrue((boolean)stripeIndexSlice.isPresent());
        Assert.assertEquals((byte[])((Slice)stripeIndexSlice.get()).getBytes(), (byte[])TestOrcReaderDwrfStripeCaching.readBytes(file, stripe.getOffset(), stripe.getIndexLength()));
    }

    private void assertStripeIndexCacheAbsent(DwrfStripeCache dwrfStripeCache, DwrfProto.StripeInformation stripe) {
        StripeReader.StripeId stripeId = new StripeReader.StripeId(TEST_DATA_SOURCE_ID, stripe.getOffset());
        Optional stripeIndexSlice = dwrfStripeCache.getIndexStreamsSlice(stripeId);
        Assert.assertFalse((boolean)stripeIndexSlice.isPresent());
    }

    private void assertStripeFooterCachePresent(DwrfStripeCache dwrfStripeCache, RandomAccessFile file, DwrfProto.StripeInformation stripe) throws IOException {
        StripeReader.StripeId stripeId = new StripeReader.StripeId(TEST_DATA_SOURCE_ID, stripe.getOffset());
        Optional stripeFooterSlice = dwrfStripeCache.getStripeFooterSlice(stripeId, Math.toIntExact(stripe.getFooterLength()));
        Assert.assertTrue((boolean)stripeFooterSlice.isPresent());
        long footerOffset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        Assert.assertEquals((byte[])((Slice)stripeFooterSlice.get()).getBytes(), (byte[])TestOrcReaderDwrfStripeCaching.readBytes(file, footerOffset, stripe.getFooterLength()));
    }

    private void assertStripeFooterCacheAbsent(DwrfStripeCache dwrfStripeCache, DwrfProto.StripeInformation stripe) {
        StripeReader.StripeId stripeId = new StripeReader.StripeId(TEST_DATA_SOURCE_ID, stripe.getOffset());
        Optional stripeFooterSlice = dwrfStripeCache.getStripeFooterSlice(stripeId, Math.toIntExact(stripe.getFooterLength()));
        Assert.assertFalse((boolean)stripeFooterSlice.isPresent());
    }

    private Optional<DwrfStripeCache> getDwrfStripeCache(File orcFile) throws IOException {
        CapturingStripeMetadataSourceFactory stripeMetadataSourceFactory = new CapturingStripeMetadataSourceFactory();
        FileOrcDataSource orcDataSource = new FileOrcDataSource(orcFile, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(0x100000, true), (StripeMetadataSourceFactory)stripeMetadataSourceFactory, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
        return stripeMetadataSourceFactory.getDwrfStripeCache();
    }

    private static class CapturingStripeMetadataSourceFactory
    implements StripeMetadataSourceFactory {
        private final StorageStripeMetadataSource source = new StorageStripeMetadataSource();
        private Optional<DwrfStripeCache> dwrfStripeCache;

        private CapturingStripeMetadataSourceFactory() {
        }

        public StripeMetadataSource create(Optional<DwrfStripeCache> dwrfStripeCache) {
            this.dwrfStripeCache = dwrfStripeCache;
            return this.source;
        }

        public Optional<DwrfStripeCache> getDwrfStripeCache() {
            return this.dwrfStripeCache;
        }
    }
}

