/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.testing.TestingEnvironment;
import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcReaderMemoryUsage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVarcharTypeWithoutNulls() throws Exception {
        int rows = 5000;
        try (OrcBatchRecordReader reader = null;
             TempFile tempFile = TestOrcReaderMemoryUsage.createSingleColumnVarcharFile(rows, 10);){
            int batchSize;
            reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)VarcharType.VARCHAR, 1, false, false);
            TestOrcReaderMemoryUsage.assertInitialRetainedSizes(reader, rows);
            long stripeReaderRetainedSize = reader.getCurrentStripeRetainedSizeInBytes();
            long streamReaderRetainedSize = reader.getStreamReaderRetainedSizeInBytes();
            long readerRetainedSize = reader.getRetainedSizeInBytes();
            long readerSystemMemoryUsage = reader.getSystemMemoryUsage();
            while ((batchSize = reader.nextBatch()) != -1) {
                Block block = reader.readBlock(0);
                Assert.assertEquals((int)block.getPositionCount(), (int)batchSize);
                if (batchSize < 1024) continue;
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getCurrentStripeRetainedSizeInBytes()), (Comparable)Long.valueOf(stripeReaderRetainedSize));
                Assert.assertEquals((long)(reader.getStreamReaderRetainedSizeInBytes() - streamReaderRetainedSize), (long)49L);
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getRetainedSizeInBytes() - readerRetainedSize), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getSystemMemoryUsage() - readerSystemMemoryUsage), (Comparable)Long.valueOf(0L));
            }
        }
        TestOrcReaderMemoryUsage.assertClosedRetainedSizes(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigIntTypeWithNulls() throws Exception {
        int rows = 10000;
        try (OrcBatchRecordReader reader = null;
             TempFile tempFile = TestOrcReaderMemoryUsage.createSingleColumnFileWithNullValues(rows);){
            int batchSize;
            reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)BigintType.BIGINT, 1, false, false);
            TestOrcReaderMemoryUsage.assertInitialRetainedSizes(reader, rows);
            long stripeReaderRetainedSize = reader.getCurrentStripeRetainedSizeInBytes();
            long streamReaderRetainedSize = reader.getStreamReaderRetainedSizeInBytes();
            long readerRetainedSize = reader.getRetainedSizeInBytes();
            long readerSystemMemoryUsage = reader.getSystemMemoryUsage();
            while ((batchSize = reader.nextBatch()) != -1) {
                Block block = reader.readBlock(0);
                Assert.assertEquals((int)block.getPositionCount(), (int)batchSize);
                if (batchSize < 1024) continue;
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getCurrentStripeRetainedSizeInBytes()), (Comparable)Long.valueOf(stripeReaderRetainedSize));
                Assert.assertEquals((long)(reader.getStreamReaderRetainedSizeInBytes() - streamReaderRetainedSize), (long)0L);
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getRetainedSizeInBytes() - readerRetainedSize), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getSystemMemoryUsage() - readerSystemMemoryUsage), (Comparable)Long.valueOf(0L));
            }
        }
        TestOrcReaderMemoryUsage.assertClosedRetainedSizes(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapTypeWithNulls() throws Exception {
        BigintType keyType = BigintType.BIGINT;
        BigintType valueType = BigintType.BIGINT;
        MethodHandle keyNativeEquals = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{keyType, keyType});
        MethodHandle keyBlockEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeHashCode = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{keyType});
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MapType mapType = new MapType((Type)keyType, (Type)valueType, keyBlockEquals, keyBlockHashCode);
        int rows = 10000;
        try (OrcBatchRecordReader reader = null;
             TempFile tempFile = TestOrcReaderMemoryUsage.createSingleColumnMapFileWithNullValues((Type)mapType, rows);){
            int batchSize;
            reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)mapType, 1, false, false);
            TestOrcReaderMemoryUsage.assertInitialRetainedSizes(reader, rows);
            long stripeReaderRetainedSize = reader.getCurrentStripeRetainedSizeInBytes();
            long streamReaderRetainedSize = reader.getStreamReaderRetainedSizeInBytes();
            long readerRetainedSize = reader.getRetainedSizeInBytes();
            long readerSystemMemoryUsage = reader.getSystemMemoryUsage();
            while ((batchSize = reader.nextBatch()) != -1) {
                Block block = reader.readBlock(0);
                Assert.assertEquals((int)block.getPositionCount(), (int)batchSize);
                if (batchSize < 1024) continue;
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getCurrentStripeRetainedSizeInBytes()), (Comparable)Long.valueOf(stripeReaderRetainedSize));
                Assert.assertEquals((long)(reader.getStreamReaderRetainedSizeInBytes() - streamReaderRetainedSize), (long)0L);
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getRetainedSizeInBytes() - readerRetainedSize), (Comparable)Long.valueOf(0L));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getSystemMemoryUsage() - readerSystemMemoryUsage), (Comparable)Long.valueOf(0L));
            }
        }
        TestOrcReaderMemoryUsage.assertClosedRetainedSizes(reader);
    }

    private static TempFile createSingleColumnFileWithNullValues(int rows) throws IOException, ReflectiveOperationException, SerDeException {
        OrcSerde serde = new OrcSerde();
        TempFile tempFile = new TempFile();
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(tempFile.getFile(), OrcTester.Format.ORC_12, CompressionKind.NONE, (Type)BigintType.BIGINT);
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", (Type)BigintType.BIGINT);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        for (int i = 0; i < rows; ++i) {
            if (i % 10 == 0) {
                objectInspector.setStructFieldData(row, field, null);
            } else {
                objectInspector.setStructFieldData(row, field, (Object)i);
            }
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            writer.write(record);
        }
        writer.close(false);
        return tempFile;
    }

    private static TempFile createSingleColumnVarcharFile(int count, int length) throws Exception {
        OrcSerde serde = new OrcSerde();
        TempFile tempFile = new TempFile();
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(tempFile.getFile(), OrcTester.Format.ORC_12, CompressionKind.NONE, (Type)VarcharType.VARCHAR);
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", (Type)VarcharType.VARCHAR);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        for (int i = 0; i < count; ++i) {
            objectInspector.setStructFieldData(row, field, (Object)Strings.repeat((String)"0", (int)length));
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            writer.write(record);
        }
        writer.close(false);
        return tempFile;
    }

    private static TempFile createSingleColumnMapFileWithNullValues(Type mapType, int rows) throws IOException, ReflectiveOperationException, SerDeException {
        OrcSerde serde = new OrcSerde();
        TempFile tempFile = new TempFile();
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(tempFile.getFile(), OrcTester.Format.ORC_12, CompressionKind.NONE, mapType);
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", mapType);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        for (int i = 1; i <= rows; ++i) {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (int j = 1; j <= 8; ++j) {
                Long value = j;
                map.put(value, value);
            }
            map.put(null, 0L);
            map.put(0L, null);
            objectInspector.setStructFieldData(row, field, map);
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            writer.write(record);
        }
        writer.close(false);
        return tempFile;
    }

    private static void assertInitialRetainedSizes(OrcBatchRecordReader reader, int rows) {
        Assert.assertEquals((long)reader.getReaderRowCount(), (long)rows);
        Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
        Assert.assertEquals((long)reader.getCurrentStripeRetainedSizeInBytes(), (long)0L);
        Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getStreamReaderRetainedSizeInBytes()), (Comparable)Long.valueOf(0L));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getRetainedSizeInBytes()), (Comparable)Long.valueOf(0L));
        Assert.assertEquals((long)reader.getSystemMemoryUsage(), (long)0L);
    }

    private static void assertClosedRetainedSizes(OrcBatchRecordReader reader) {
        Assert.assertEquals((long)reader.getCurrentStripeRetainedSizeInBytes(), (long)0L);
        Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getStreamReaderRetainedSizeInBytes()), (Comparable)Long.valueOf(0L));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(reader.getRetainedSizeInBytes()), (Comparable)Long.valueOf(0L));
        Assert.assertEquals((long)reader.getSystemMemoryUsage(), (long)0L);
    }
}

