/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;
import org.apache.orc.MemoryManager;
import org.apache.orc.NullMemoryManager;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcReaderPositions {
    @Test
    public void testEntireFile() throws Exception {
        try (TempFile tempFile = new TempFile();){
            TestOrcReaderPositions.createMultiStripeFile(tempFile.getFile());
            try (OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)BigintType.BIGINT, 1024, false, false);){
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)100L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                Assert.assertEquals((long)reader.getFileRowCount(), (long)reader.getReaderRowCount());
                Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
                for (int i = 0; i < 5; ++i) {
                    Assert.assertEquals((int)reader.nextBatch(), (int)20);
                    Assert.assertEquals((long)reader.getReaderPosition(), (long)((long)i * 20L));
                    Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
                    TestOrcReaderPositions.assertCurrentBatch(reader, i);
                }
                Assert.assertEquals((int)reader.nextBatch(), (int)-1);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)100L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
            }
        }
    }

    @Test
    public void testStripeSkipping() throws Exception {
        try (TempFile tempFile = new TempFile();){
            TestOrcReaderPositions.createMultiStripeFile(tempFile.getFile());
            OrcPredicate predicate = (numberOfRows, statisticsByColumnIndex) -> {
                if (numberOfRows == 100L) {
                    return true;
                }
                IntegerStatistics stats = ((ColumnStatistics)statisticsByColumnIndex.get(0)).getIntegerStatistics();
                return stats.getMin() == 60L && stats.getMax() == 117L || stats.getMin() == 180L && stats.getMax() == 237L;
            };
            try (OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, predicate, (Type)BigintType.BIGINT, 1024, false, false);){
                Assert.assertEquals((long)reader.getFileRowCount(), (long)100L);
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)40L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)0L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                Assert.assertEquals((int)reader.nextBatch(), (int)20);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)20L);
                TestOrcReaderPositions.assertCurrentBatch(reader, 1);
                Assert.assertEquals((int)reader.nextBatch(), (int)20);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)20L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)60L);
                TestOrcReaderPositions.assertCurrentBatch(reader, 3);
                Assert.assertEquals((int)reader.nextBatch(), (int)-1);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)40L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)100L);
            }
        }
    }

    @Test
    public void testCompleteFileWithAppendRowNumber() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowCount = 142000;
            TestOrcReaderPositions.createSequentialFile(tempFile.getFile(), rowCount);
            ArrayList<Long> expectedValues = new ArrayList<Long>();
            expectedValues.addAll(LongStream.range(0L, 142000L).collect(ArrayList::new, List::add, List::addAll));
            OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)BigintType.BIGINT, 1024, false, true);
            this.verifyAppendNumber(expectedValues, reader);
        }
    }

    @Test
    public void testCompleteFileWithAppendRowNumberWithValidation() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowCount = 142000;
            TestOrcReaderPositions.createSequentialFile(tempFile.getFile(), rowCount);
            ArrayList<Long> expectedValues = new ArrayList<Long>();
            expectedValues.addAll(LongStream.range(0L, 142000L).collect(ArrayList::new, List::add, List::addAll));
            OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)BigintType.BIGINT, 1024, false, true);
            this.verifyAppendNumber(expectedValues, reader);
        }
    }

    @Test
    public void testFilterFunctionWithAppendRowNumber() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowCount = 100;
            TestOrcReaderPositions.createSequentialFile(tempFile.getFile(), rowCount);
            List expectedValues = LongStream.range(0L, 100L).boxed().filter(input -> input % 2L != 0L).collect(ArrayList::new, List::add, List::addAll);
            TestingConnectorSession session = new TestingConnectorSession((List)ImmutableList.of());
            FilterFunction filter = new FilterFunction(session.getSqlFunctionProperties(), true, (Predicate)new IsOddPredicate());
            OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile.getFile(), OrcEncoding.ORC, OrcPredicate.TRUE, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 1024, (Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of(), (List<FilterFunction>)ImmutableList.of((Object)filter), (Map<Integer, Integer>)ImmutableMap.of((Object)0, (Object)0), (Map<Integer, List<Subfield>>)ImmutableMap.of(), (Map<Integer, Object>)ImmutableMap.of(), (Map<Integer, Slice>)ImmutableMap.of(), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)BigintType.BIGINT), (List<Integer>)ImmutableList.of((Object)0), false, new TestingHiveOrcAggregatedMemoryContext(), true);
            this.verifyAppendNumber(expectedValues, reader);
        }
    }

    @Test
    public void testRowGroupSkippingWithAppendRowNumber() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowCount = 142000;
            TestOrcReaderPositions.createSequentialFile(tempFile.getFile(), rowCount);
            OrcPredicate predicate = (numberOfRows, statisticsByColumnIndex) -> {
                if (numberOfRows == (long)rowCount) {
                    return true;
                }
                IntegerStatistics stats = ((ColumnStatistics)statisticsByColumnIndex.get(0)).getIntegerStatistics();
                return stats.getMin() == 50000L || stats.getMin() == 70000L;
            };
            ArrayList<Long> expectedValues = new ArrayList<Long>();
            expectedValues.addAll(LongStream.range(50000L, 60000L).collect(ArrayList::new, List::add, List::addAll));
            expectedValues.addAll(LongStream.range(70000L, 80000L).collect(ArrayList::new, List::add, List::addAll));
            OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, OrcEncoding.ORC, predicate, (Type)BigintType.BIGINT, 1024, false, true);
            this.verifyAppendNumber(expectedValues, reader);
        }
    }

    @Test
    public void testStripeSkippingWithAppendNumber() throws Exception {
        try (TempFile tempFile = new TempFile();){
            Page returnPage;
            TestOrcReaderPositions.createMultiStripeFile(tempFile.getFile());
            OrcPredicate predicate = (numberOfRows, statisticsByColumnIndex) -> {
                if (numberOfRows == 100L) {
                    return true;
                }
                IntegerStatistics stats = ((ColumnStatistics)statisticsByColumnIndex.get(0)).getIntegerStatistics();
                return stats.getMin() == 60L && stats.getMax() == 117L || stats.getMin() == 180L && stats.getMax() == 237L;
            };
            ArrayList expectedValues = new ArrayList();
            expectedValues.addAll(LongStream.range(20L, 40L).collect(ArrayList::new, List::add, List::addAll));
            expectedValues.addAll(LongStream.range(60L, 80L).collect(ArrayList::new, List::add, List::addAll));
            ArrayList<Long> actualValues = new ArrayList<Long>();
            OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, OrcEncoding.ORC, predicate, (Type)BigintType.BIGINT, 1024, false, true);
            Assert.assertNotNull((Object)reader);
            while ((returnPage = reader.getNextPage()) != null) {
                Block rowNumberBlock = returnPage.getBlock(1);
                for (int i = 0; i < returnPage.getPositionCount(); ++i) {
                    actualValues.add(rowNumberBlock.getLong(i));
                }
            }
            Assert.assertEquals(actualValues, expectedValues);
        }
    }

    private void verifyAppendNumber(List<Long> expectedValues, OrcSelectiveRecordReader reader) throws IOException {
        Page returnPage;
        Assert.assertNotNull((Object)reader);
        Assert.assertNotNull(expectedValues);
        ArrayList<Long> actualValues = new ArrayList<Long>();
        while ((returnPage = reader.getNextPage()) != null) {
            Block dataBlock = returnPage.getBlock(0);
            Block rowNumberBlock = returnPage.getBlock(1);
            for (int i = 0; i < returnPage.getPositionCount(); ++i) {
                actualValues.add(dataBlock.getLong(i));
                Assert.assertEquals((long)dataBlock.getLong(i), (long)rowNumberBlock.getLong(i));
            }
        }
        Assert.assertEquals(actualValues, expectedValues);
    }

    @Test
    public void testRowGroupSkipping() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowCount = 142000;
            TestOrcReaderPositions.createSequentialFile(tempFile.getFile(), rowCount);
            OrcPredicate predicate = (numberOfRows, statisticsByColumnIndex) -> {
                if (numberOfRows == (long)rowCount) {
                    return true;
                }
                IntegerStatistics stats = ((ColumnStatistics)statisticsByColumnIndex.get(0)).getIntegerStatistics();
                return stats.getMin() == 50000L || stats.getMin() == 60000L;
            };
            try (OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, predicate, (Type)BigintType.BIGINT, 1024, false, false);){
                int batchSize;
                Assert.assertEquals((long)reader.getFileRowCount(), (long)rowCount);
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)rowCount);
                Assert.assertEquals((long)reader.getFilePosition(), (long)0L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                long position = 50000L;
                while ((batchSize = reader.nextBatch()) != -1) {
                    Block block = reader.readBlock(0);
                    for (int i = 0; i < batchSize; ++i) {
                        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, i), (long)(position + (long)i));
                    }
                    Assert.assertEquals((long)reader.getFilePosition(), (long)position);
                    Assert.assertEquals((long)reader.getReaderPosition(), (long)position);
                    position += (long)batchSize;
                }
                Assert.assertEquals((long)position, (long)70000L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)rowCount);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)rowCount);
            }
        }
    }

    @Test
    public void testBatchSizesForVariableWidth() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowsInRowGroup = 10000;
            int rowGroupCounts = 10;
            int baseStringBytes = 300;
            int rowCount = rowsInRowGroup * rowGroupCounts;
            TestOrcReaderPositions.createGrowingSequentialFile(tempFile.getFile(), rowCount, rowsInRowGroup, baseStringBytes);
            try (OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)VarcharType.VARCHAR, 1024, false, false);){
                int batchSize;
                Assert.assertEquals((long)reader.getFileRowCount(), (long)rowCount);
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)rowCount);
                Assert.assertEquals((long)reader.getFilePosition(), (long)0L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                int currentStringBytes = baseStringBytes + 4 + 1;
                int rowCountsInCurrentRowGroup = 0;
                while ((batchSize = reader.nextBatch()) != -1) {
                    rowCountsInCurrentRowGroup += batchSize;
                    Block block = reader.readBlock(0);
                    if ((long)(1024 * currentStringBytes) <= OrcTester.MAX_BLOCK_SIZE.toBytes()) {
                        Assert.assertTrue((block.getPositionCount() == 1024 || rowCountsInCurrentRowGroup == rowsInRowGroup ? 1 : 0) != 0);
                    } else {
                        Assert.assertTrue(((long)block.getPositionCount() == OrcTester.MAX_BLOCK_SIZE.toBytes() / (long)currentStringBytes || rowCountsInCurrentRowGroup == rowsInRowGroup ? 1 : 0) != 0);
                    }
                    if (rowCountsInCurrentRowGroup == rowsInRowGroup) {
                        rowCountsInCurrentRowGroup = 0;
                        currentStringBytes += baseStringBytes;
                        continue;
                    }
                    if (rowCountsInCurrentRowGroup <= rowsInRowGroup) continue;
                    Assert.assertTrue((boolean)false, (String)"read more rows in the current row group");
                }
            }
        }
    }

    @Test
    public void testBatchSizesForFixedWidth() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int rowsInRowGroup = 10000;
            int rowGroupCounts = 10;
            int rowCount = rowsInRowGroup * rowGroupCounts;
            TestOrcReaderPositions.createSequentialFile(tempFile.getFile(), rowCount);
            try (OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)BigintType.BIGINT, 1024, false, false);){
                int batchSize;
                Assert.assertEquals((long)reader.getFileRowCount(), (long)rowCount);
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)rowCount);
                Assert.assertEquals((long)reader.getFilePosition(), (long)0L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                int rowCountsInCurrentRowGroup = 0;
                while ((batchSize = reader.nextBatch()) != -1) {
                    Block block = reader.readBlock(0);
                    Assert.assertTrue((block.getPositionCount() == 1024 || (rowCountsInCurrentRowGroup += batchSize) == rowsInRowGroup ? 1 : 0) != 0);
                    if (rowCountsInCurrentRowGroup == rowsInRowGroup) {
                        rowCountsInCurrentRowGroup = 0;
                        continue;
                    }
                    if (rowCountsInCurrentRowGroup <= rowsInRowGroup) continue;
                    Assert.assertTrue((boolean)false, (String)"read more rows in the current row group");
                }
            }
        }
    }

    @Test
    public void testReadUserMetadata() throws Exception {
        try (TempFile tempFile = new TempFile();){
            ImmutableMap metadata = ImmutableMap.of((Object)"a", (Object)"ala", (Object)"b", (Object)"ma", (Object)"c", (Object)"kota");
            TestOrcReaderPositions.createFileWithOnlyUserMetadata(tempFile.getFile(), (Map<String, String>)metadata);
            FileOrcDataSource orcDataSource = new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
            OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
            Footer footer = orcReader.getFooter();
            Map readMetadata = Maps.transformValues((Map)footer.getUserMetadata(), Slice::toStringAscii);
            Assert.assertEquals((Map)readMetadata, (Map)metadata);
        }
    }

    @Test
    public void testBatchSizeGrowth() throws Exception {
        try (TempFile tempFile = new TempFile();){
            int totalReadRows;
            TestOrcReaderPositions.createMultiStripeFile(tempFile.getFile());
            try (OrcBatchRecordReader reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (Type)BigintType.BIGINT, 1, false, false);){
                int batchSize;
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)100L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                Assert.assertEquals((long)reader.getFileRowCount(), (long)reader.getReaderRowCount());
                Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
                totalReadRows = 0;
                while ((batchSize = reader.nextBatch()) != -1) {
                    Assert.assertEquals((int)batchSize, (int)20);
                    Assert.assertEquals((long)reader.getReaderPosition(), (long)totalReadRows);
                    Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
                    TestOrcReaderPositions.assertCurrentBatch(reader, (int)reader.getReaderPosition(), batchSize);
                    totalReadRows += batchSize;
                }
                Assert.assertEquals((long)reader.getReaderPosition(), (long)100L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
            }
            reader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), 1, false, false);
            var4_6 = null;
            try {
                int batchSize;
                Assert.assertEquals((long)reader.getReaderRowCount(), (long)100L);
                Assert.assertEquals((long)reader.getReaderPosition(), (long)0L);
                Assert.assertEquals((long)reader.getFileRowCount(), (long)reader.getReaderRowCount());
                Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
                totalReadRows = 0;
                int nextBatchSize = 1;
                int expectedBatchSize = 1;
                int rowCountsInCurrentRowGroup = 0;
                while ((batchSize = reader.nextBatch()) != -1) {
                    Assert.assertEquals((int)batchSize, (int)expectedBatchSize);
                    Assert.assertEquals((long)reader.getReaderPosition(), (long)totalReadRows);
                    Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
                    TestOrcReaderPositions.assertCurrentBatch(reader, (int)reader.getReaderPosition(), batchSize);
                    nextBatchSize = nextBatchSize > 20 - rowCountsInCurrentRowGroup ? (nextBatchSize *= 2) : batchSize * 2;
                    totalReadRows += batchSize;
                    if ((rowCountsInCurrentRowGroup += batchSize) == 20) {
                        rowCountsInCurrentRowGroup = 0;
                    } else if (rowCountsInCurrentRowGroup > 20) {
                        Assert.assertTrue((boolean)false, (String)"read more rows in the current row group");
                    }
                    expectedBatchSize = Math.min(Math.min(nextBatchSize, 1024), 20 - rowCountsInCurrentRowGroup);
                }
                Assert.assertEquals((long)reader.getReaderPosition(), (long)100L);
                Assert.assertEquals((long)reader.getFilePosition(), (long)reader.getReaderPosition());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var4_6 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }

    private static void assertCurrentBatch(OrcBatchRecordReader reader, int rowIndex, int batchSize) throws IOException {
        Block block = reader.readBlock(0);
        for (int i = 0; i < batchSize; ++i) {
            Assert.assertEquals((long)BigintType.BIGINT.getLong(block, i), (long)((rowIndex + i) * 3));
        }
    }

    private static void assertCurrentBatch(OrcBatchRecordReader reader, int stripe) throws IOException {
        Block block = reader.readBlock(0);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)BigintType.BIGINT.getLong(block, i), (long)(((long)stripe * 20L + (long)i) * 3L));
        }
    }

    private static void createMultiStripeFile(File file) throws IOException, ReflectiveOperationException, SerDeException {
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(file, OrcTester.Format.ORC_12, CompressionKind.NONE, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR));
        OrcSerde serde = new OrcSerde();
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR));
        Object row = objectInspector.create();
        StructField bigintField = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        StructField varcharField = (StructField)objectInspector.getAllStructFieldRefs().get(1);
        for (int i = 0; i < 300; i += 3) {
            if (i > 0 && i % 60 == 0) {
                TestOrcReaderPositions.flushWriter(writer);
            }
            objectInspector.setStructFieldData(row, bigintField, (Object)i);
            objectInspector.setStructFieldData(row, varcharField, (Object)String.valueOf(i));
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            writer.write(record);
        }
        writer.close(false);
    }

    private static void createFileWithOnlyUserMetadata(File file, Map<String, String> metadata) throws IOException {
        Configuration conf = new Configuration();
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Configuration)conf).memory((MemoryManager)new NullMemoryManager()).inspector((ObjectInspector)OrcTester.createSettableStructObjectInspector("test", (Type)BigintType.BIGINT)).compress(org.apache.hadoop.hive.ql.io.orc.CompressionKind.SNAPPY);
        Writer writer = OrcFile.createWriter((Path)new Path(file.toURI()), (OrcFile.WriterOptions)writerOptions);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            writer.addUserMetadata(entry.getKey(), ByteBuffer.wrap(entry.getValue().getBytes(StandardCharsets.UTF_8)));
        }
        writer.close();
    }

    private static void flushWriter(FileSinkOperator.RecordWriter writer) throws IOException, ReflectiveOperationException {
        Field field = OrcOutputFormat.class.getClassLoader().loadClass(OrcOutputFormat.class.getName() + "$OrcRecordWriter").getDeclaredField("writer");
        field.setAccessible(true);
        ((Writer)field.get(writer)).writeIntermediateFooter();
    }

    private static void createSequentialFile(File file, int count) throws IOException, SerDeException {
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(file, OrcTester.Format.ORC_12, CompressionKind.NONE, (Type)BigintType.BIGINT);
        OrcSerde serde = new OrcSerde();
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", (Type)BigintType.BIGINT);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        for (int i = 0; i < count; ++i) {
            objectInspector.setStructFieldData(row, field, (Object)i);
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            writer.write(record);
        }
        writer.close(false);
    }

    private static void createGrowingSequentialFile(File file, int count, int step, int initialLength) throws IOException, SerDeException {
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(file, OrcTester.Format.ORC_12, CompressionKind.NONE, (Type)VarcharType.VARCHAR);
        OrcSerde serde = new OrcSerde();
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", (Type)VarcharType.VARCHAR);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < initialLength; ++i) {
            builder.append("0");
        }
        String seedString = builder.toString();
        int previousLength = initialLength;
        for (int i = 0; i < count; ++i) {
            if ((i / step + 1) * initialLength > previousLength) {
                previousLength = (i / step + 1) * initialLength;
                builder.append(seedString);
            }
            objectInspector.setStructFieldData(row, field, (Object)builder.toString());
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            writer.write(record);
        }
        writer.close(false);
    }

    private static class IsOddPredicate
    implements Predicate {
        private IsOddPredicate() {
        }

        public int[] getInputChannels() {
            return new int[]{0};
        }

        public boolean evaluate(SqlFunctionProperties properties, Page page, int position) {
            long number = page.getBlock(0).getLong(position);
            return (number & 1L) == 1L;
        }
    }
}

