/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.orc.AbstractTestDwrfStripeCaching;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.DwrfAwareStripeMetadataSourceFactory;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingOrcDataSource;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.proto.DwrfProto;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcRecordReaderDwrfStripeCaching
extends AbstractTestDwrfStripeCaching {
    private static final int READ_TAIL_SIZE_IN_BYTES = 256;

    @Test(dataProvider="Stripe cache for ALL stripes with mode BOTH")
    public void testBothAllStripes(File orcFile) throws IOException {
        DwrfProto.Footer footer = TestOrcRecordReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        List<DiskRange> forbiddenRanges = this.getStripeRanges(DwrfStripeCacheMode.INDEX_AND_FOOTER, stripes);
        this.assertFileContentCachingEnabled(orcFile, forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache for HALF stripes with mode BOTH")
    public void testBothHalfStripes(File orcFile) throws IOException {
        DwrfProto.Footer footer = TestOrcRecordReaderDwrfStripeCaching.readFileFooter(orcFile);
        List<DwrfProto.StripeInformation> stripes = footer.getStripesList().subList(0, 1);
        List<DiskRange> forbiddenRanges = this.getStripeRanges(DwrfStripeCacheMode.INDEX_AND_FOOTER, stripes);
        this.assertFileContentCachingEnabled(orcFile, forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache for ALL stripes with mode INDEX")
    public void testIndexAllStripes(File orcFile) throws IOException {
        DwrfProto.Footer footer = TestOrcRecordReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        List<DiskRange> forbiddenRanges = this.getStripeRanges(DwrfStripeCacheMode.INDEX, stripes);
        this.assertFileContentCachingEnabled(orcFile, forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache for HALF stripes with mode INDEX")
    public void testIndexHalfStripes(File orcFile) throws IOException {
        DwrfProto.Footer footer = TestOrcRecordReaderDwrfStripeCaching.readFileFooter(orcFile);
        List<DwrfProto.StripeInformation> stripes = footer.getStripesList().subList(0, 1);
        List<DiskRange> forbiddenRanges = this.getStripeRanges(DwrfStripeCacheMode.INDEX, stripes);
        this.assertFileContentCachingEnabled(orcFile, forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache for ALL stripes with mode FOOTER")
    public void testFooterAllStripes(File orcFile) throws IOException {
        DwrfProto.Footer footer = TestOrcRecordReaderDwrfStripeCaching.readFileFooter(orcFile);
        List stripes = footer.getStripesList();
        List<DiskRange> forbiddenRanges = this.getStripeRanges(DwrfStripeCacheMode.FOOTER, stripes);
        this.assertFileContentCachingEnabled(orcFile, forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache for HALF stripes with mode FOOTER")
    public void testFooterHalfStripes(File orcFile) throws IOException {
        DwrfProto.Footer footer = TestOrcRecordReaderDwrfStripeCaching.readFileFooter(orcFile);
        List<DwrfProto.StripeInformation> stripes = footer.getStripesList().subList(0, 1);
        List<DiskRange> forbiddenRanges = this.getStripeRanges(DwrfStripeCacheMode.FOOTER, stripes);
        this.assertFileContentCachingEnabled(orcFile, forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache with mode NONE")
    public void testNoneAllStripes(File orcFile) throws IOException {
        ImmutableList forbiddenRanges = ImmutableList.of();
        this.assertFileContentCachingEnabled(orcFile, (List<DiskRange>)forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    @Test(dataProvider="Stripe cache disabled")
    public void testStripeCacheDisabled(File orcFile) throws IOException {
        ImmutableList forbiddenRanges = ImmutableList.of();
        this.assertFileContentCachingEnabled(orcFile, (List<DiskRange>)forbiddenRanges);
        this.assertFileContentCachingDisabled(orcFile);
    }

    private void assertFileContentCachingEnabled(File orcFile, List<DiskRange> forbiddenRanges) throws IOException {
        try (TestingOrcDataSource orcDataSource = new TestingOrcDataSource(this.createFileOrcDataSource(orcFile));){
            StripeMetadataSourceFactory delegateSourceFactory = StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource());
            DwrfAwareStripeMetadataSourceFactory dwrfAwareFactory = new DwrfAwareStripeMetadataSourceFactory(delegateSourceFactory);
            OrcReaderOptions orcReaderOptions = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(0.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(0.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).build();
            OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(256, true), (StripeMetadataSourceFactory)dwrfAwareFactory, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, orcReaderOptions, false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
            this.assertRecordValues(orcDataSource, orcReader);
            this.assertForbiddenRanges(orcDataSource, forbiddenRanges);
        }
    }

    private void assertFileContentCachingDisabled(File orcFile) throws IOException {
        try (TestingOrcDataSource orcDataSource = new TestingOrcDataSource(this.createFileOrcDataSource(orcFile));){
            StripeMetadataSourceFactory delegateSourceFactory = StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource());
            DwrfAwareStripeMetadataSourceFactory dwrfAwareFactory = new DwrfAwareStripeMetadataSourceFactory(delegateSourceFactory);
            OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(256, false), (StripeMetadataSourceFactory)dwrfAwareFactory, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
            this.assertRecordValues(orcDataSource, orcReader);
        }
    }

    private void assertRecordValues(TestingOrcDataSource orcDataSource, OrcReader orcReader) throws IOException {
        Page page;
        OrcSelectiveRecordReader recordReader = orcReader.createSelectiveRecordReader((Map)ImmutableMap.of((Object)0, (Object)IntegerType.INTEGER, (Object)1, (Object)IntegerType.INTEGER, (Object)2, (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)0, (Object)1, (Object)2), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), OrcPredicate.TRUE, 0L, orcDataSource.getSize(), OrcTester.HIVE_STORAGE_TIME_ZONE, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), Optional.empty(), 1024);
        int cnt = 0;
        while ((page = recordReader.getNextPage()) != null) {
            Block block0 = page.getBlock(0);
            Block block1 = page.getBlock(1);
            Block block2 = page.getBlock(2);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assert.assertEquals((int)block0.getInt(i), (int)cnt);
                Assert.assertEquals((int)block1.getInt(i), (int)Integer.MAX_VALUE);
                Assert.assertEquals((int)block2.getInt(i), (int)(cnt * 10));
                ++cnt;
            }
        }
        Assert.assertEquals((int)cnt, (int)400);
    }

    private void assertForbiddenRanges(TestingOrcDataSource orcDataSource, List<DiskRange> forbiddenRanges) {
        List<DiskRange> readRanges = orcDataSource.getReadRanges();
        for (DiskRange readRange : readRanges) {
            for (DiskRange forbiddenRange : forbiddenRanges) {
                if (!this.intersect(readRange, forbiddenRange)) continue;
                Assert.fail((String)("Read range " + readRange + " is not supposed to intersect with " + forbiddenRange));
            }
        }
    }

    private List<DiskRange> getStripeRanges(DwrfStripeCacheMode mode, List<DwrfProto.StripeInformation> stripes) {
        ImmutableList.Builder rangesBuilder = ImmutableList.builder();
        for (DwrfProto.StripeInformation stripe : stripes) {
            if (mode.hasFooter()) {
                long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
                rangesBuilder.add((Object)new DiskRange(offset, Math.toIntExact(stripe.getFooterLength())));
            }
            if (!mode.hasIndex()) continue;
            rangesBuilder.add((Object)new DiskRange(stripe.getOffset(), Math.toIntExact(stripe.getIndexLength())));
        }
        return rangesBuilder.build();
    }

    private boolean intersect(DiskRange r1, DiskRange r2) {
        DiskRange left = r1;
        DiskRange right = r2;
        if (r2.getOffset() < r1.getOffset()) {
            left = r2;
            right = r1;
        }
        return right.getOffset() == left.getOffset() || right.getOffset() < left.getEnd();
    }

    private OrcDataSource createFileOrcDataSource(File orcFile) throws IOException {
        return new FileOrcDataSource(orcFile, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
    }
}

