/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingOrcPredicate;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SliceSelectiveStreamReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcSelectiveStreamReaders {
    private Set<OrcTester.Format> formats = ImmutableSet.of((Object)((Object)OrcTester.Format.ORC_12), (Object)((Object)OrcTester.Format.ORC_11), (Object)((Object)OrcTester.Format.DWRF));
    private Set<CompressionKind> compressions = ImmutableSet.of((Object)CompressionKind.NONE, (Object)CompressionKind.SNAPPY, (Object)CompressionKind.ZLIB, (Object)CompressionKind.LZ4, (Object)CompressionKind.ZSTD);

    @Test
    public void testEmptyStrings() throws Exception {
        VarcharType type = VarcharType.VARCHAR;
        ImmutableList types = ImmutableList.of((Object)type);
        ImmutableList values = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)""));
        for (OrcTester.Format format : this.formats) {
            if (!types.stream().allMatch(readType -> format.supportsType((Type)readType))) {
                return;
            }
            for (CompressionKind compression : this.compressions) {
                TempFile tempFile = new TempFile();
                OrcTester.writeOrcColumnsPresto(tempFile.getFile(), format, compression, Optional.empty(), (List<Type>)types, values, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
                OrcPredicate orcPredicate = TestingOrcPredicate.createOrcPredicate((List<Type>)types, values, OrcTester.Format.DWRF, false);
                Map includedColumns = (Map)IntStream.range(0, types.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), ((List)types)::get));
                List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
                TestingHiveOrcAggregatedMemoryContext systemMemoryUsage = new TestingHiveOrcAggregatedMemoryContext();
                OrcSelectiveRecordReader recordReader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile.getFile(), format.getOrcEncoding(), orcPredicate, (List<Type>)types, 1, (Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of(), (List<FilterFunction>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of(), OrcTester.OrcReaderSettings.builder().build().getRequiredSubfields(), (Map<Integer, Object>)ImmutableMap.of(), (Map<Integer, Slice>)ImmutableMap.of(), includedColumns, outputColumns, false, systemMemoryUsage, false);
                Throwable throwable = null;
                try {
                    Assert.assertEquals((long)recordReader.getReaderPosition(), (long)0L);
                    Assert.assertEquals((long)recordReader.getFilePosition(), (long)0L);
                    SelectiveStreamReader streamReader = ((SelectiveStreamReader[])recordReader.getStreamReaders())[0];
                    int batchSize = Math.min(recordReader.prepareNextBatch(), 1);
                    int[] positions = IntStream.range(0, batchSize).toArray();
                    streamReader.read(0, positions, batchSize);
                    recordReader.batchRead(batchSize);
                    ((SliceSelectiveStreamReader)streamReader).resetDataStream();
                    batchSize = Math.min(recordReader.prepareNextBatch(), 1);
                    positions = IntStream.range(0, batchSize).toArray();
                    streamReader.read(0, positions, batchSize);
                    recordReader.batchRead(batchSize);
                    Block block = streamReader.getBlock(positions, batchSize);
                    ImmutableList expectedValues = ImmutableList.of((Object)"");
                    OrcTester.assertBlockEquals((Type)type, block, expectedValues, 0);
                    Assert.assertEquals((long)recordReader.getReaderPosition(), (long)1L);
                    Assert.assertEquals((long)recordReader.getFilePosition(), (long)1L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (recordReader == null) continue;
                    if (throwable != null) {
                        try {
                            recordReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    recordReader.close();
                }
            }
        }
    }
}

