/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.writer.StreamLayoutFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOrcWriter {
    @DataProvider(name="compressionLevels")
    public static Object[][] zstdCompressionLevels() {
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        parameters.add((Object)new Object[]{OrcEncoding.ORC, CompressionKind.NONE, OptionalInt.empty()});
        parameters.add((Object)new Object[]{OrcEncoding.DWRF, CompressionKind.ZSTD, OptionalInt.of(7)});
        parameters.add((Object)new Object[]{OrcEncoding.DWRF, CompressionKind.ZSTD, OptionalInt.empty()});
        parameters.add((Object)new Object[]{OrcEncoding.DWRF, CompressionKind.ZLIB, OptionalInt.of(5)});
        parameters.add((Object)new Object[]{OrcEncoding.DWRF, CompressionKind.ZLIB, OptionalInt.empty()});
        return (Object[][])parameters.build().toArray((Object[])new Object[0][]);
    }

    @Test(dataProvider="compressionLevels")
    public void testWriteOutputStreamsInOrder(OrcEncoding encoding, CompressionKind kind, OptionalInt level) throws IOException {
        this.testStreamOrder(encoding, kind, level, (StreamLayoutFactory)new StreamLayoutFactory.StreamSizeLayoutFactory(), () -> new Consumer<Stream>(){
            int size;

            @Override
            public void accept(Stream stream) {
                if (!StripeReader.isIndexStream((Stream)stream)) {
                    Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(stream.getLength()), (Comparable)Integer.valueOf(this.size), (String)stream.toString());
                    this.size = stream.getLength();
                }
            }
        });
    }

    @Test(dataProvider="compressionLevels")
    public void testOutputStreamsByColumnSize(OrcEncoding encoding, CompressionKind kind, OptionalInt level) throws IOException {
        this.testStreamOrder(encoding, kind, level, (StreamLayoutFactory)new StreamLayoutFactory.ColumnSizeLayoutFactory(), () -> new Consumer<Stream>(){
            int previousColumnSize;
            int currentColumnSize;
            int currentColumnId = -1;

            @Override
            public void accept(Stream stream) {
                if (!StripeReader.isIndexStream((Stream)stream)) {
                    if (stream.getColumn() == this.currentColumnId) {
                        this.currentColumnSize += stream.getLength();
                    } else {
                        Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(this.currentColumnSize), (Comparable)Integer.valueOf(this.previousColumnSize), (String)stream.toString());
                        this.previousColumnSize = this.currentColumnSize;
                        this.currentColumnSize = stream.getLength();
                        this.currentColumnId = stream.getColumn();
                    }
                }
            }
        });
    }

    private void testStreamOrder(OrcEncoding encoding, CompressionKind kind, OptionalInt level, StreamLayoutFactory streamLayoutFactory, Supplier<Consumer<Stream>> streamConsumerFactory) throws IOException {
        OrcWriterOptions orcWriterOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(new DataSize(0.0, DataSize.Unit.MEGABYTE)).withStripeMaxSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).withStripeMaxRowCount(30000).build()).withRowGroupMaxRowCount(10000).withDictionaryMaxMemory(new DataSize(32.0, DataSize.Unit.MEGABYTE)).withCompressionLevel(level).withStreamLayoutFactory(streamLayoutFactory).build();
        for (OrcWriteValidation.OrcWriteValidationMode validationMode : OrcWriteValidation.OrcWriteValidationMode.values()) {
            TempFile tempFile = new TempFile();
            OrcWriter writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(tempFile.getFile())), (List)ImmutableList.of((Object)"test1", (Object)"test2", (Object)"test3", (Object)"test4", (Object)"test5"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), encoding, kind, Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, orcWriterOptions, (Map)ImmutableMap.of(), OrcTester.HIVE_STORAGE_TIME_ZONE, true, validationMode, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
            String[] data = new String[]{"a", "bbbbb", "ccc", "dd", "eeee"};
            Block[] blocks = new Block[data.length];
            int entries = 65536;
            BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, entries);
            for (int i = 0; i < data.length; ++i) {
                byte[] bytes = data[i].getBytes();
                for (int j = 0; j < entries; ++j) {
                    bytes[0] = (byte)((bytes[0] + 1) % 128);
                    blockBuilder.writeBytes(Slices.wrappedBuffer((byte[])bytes, (int)0, (int)bytes.length), 0, bytes.length);
                    blockBuilder.closeEntry();
                }
                blocks[i] = blockBuilder.build();
                blockBuilder = blockBuilder.newBlockBuilderLike(null);
            }
            writer.write(new Page(blocks));
            writer.close();
            for (StripeFooter stripeFooter : OrcTester.getStripes(tempFile.getFile(), encoding)) {
                Consumer<Stream> streamConsumer = streamConsumerFactory.get();
                boolean dataStreamStarted = false;
                for (Stream stream : stripeFooter.getStreams()) {
                    if (StripeReader.isIndexStream((Stream)stream)) {
                        Assert.assertFalse((boolean)dataStreamStarted);
                        continue;
                    }
                    dataStreamStarted = true;
                    streamConsumer.accept(stream);
                }
            }
        }
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Dummy exception from mocked instance")
    public void testVerifyNoIllegalStateException() throws IOException {
        OrcWriter writer = new OrcWriter((DataSink)new MockDataSink(), (List)ImmutableList.of((Object)"test1"), (List)ImmutableList.of((Object)VarcharType.VARCHAR), OrcEncoding.ORC, CompressionKind.NONE, Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(new DataSize(0.0, DataSize.Unit.MEGABYTE)).withStripeMaxSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).withStripeMaxRowCount(10).build()).withRowGroupMaxRowCount(10000).withDictionaryMaxMemory(new DataSize(32.0, DataSize.Unit.MEGABYTE)).build(), (Map)ImmutableMap.of(), OrcTester.HIVE_STORAGE_TIME_ZONE, false, null, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        int entries = 65536;
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, entries);
        byte[] bytes = "dummyString".getBytes();
        for (int j = 0; j < entries; ++j) {
            bytes[0] = (byte)((bytes[0] + 1) % 128);
            blockBuilder.writeBytes(Slices.wrappedBuffer((byte[])bytes, (int)0, (int)bytes.length), 0, bytes.length);
            blockBuilder.closeEntry();
        }
        Block[] blocks = new Block[]{blockBuilder.build()};
        try {
            writer.write(new Page(blocks));
        }
        catch (IOException e) {
            writer.close();
        }
    }

    public static class MockDataSink
    implements DataSink {
        public long size() {
            return -1L;
        }

        public long getRetainedSizeInBytes() {
            return -1L;
        }

        public void write(List<DataOutput> outputData) throws IOException {
            throw new IOException("Dummy exception from mocked instance");
        }

        public void close() {
        }
    }
}

