/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfStripeCacheOptions;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.writer.StreamLayoutFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.units.DataSize;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcWriterOptions {
    private static final DwrfStripeCacheMode DWRF_STRIPE_CACHE_MODE = DwrfStripeCacheMode.INDEX_AND_FOOTER;
    private static final DataSize DWRF_STRIPE_CACHE_MAX_SIZE = new DataSize(27.0, DataSize.Unit.MEGABYTE);

    @Test
    public void testDwrfWriterOptionsProperties() {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)true, (Object)false).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean value = (Boolean)unmodifiableIterator.next();
            OrcWriterOptions options = OrcWriterOptions.builder().withDwrfStripeCacheEnabled(value).withDwrfStripeCacheMode(DWRF_STRIPE_CACHE_MODE).withDwrfStripeCacheMaxSize(DWRF_STRIPE_CACHE_MAX_SIZE).build();
            Assert.assertEquals((boolean)options.getDwrfStripeCacheOptions().isPresent(), (boolean)value);
            if (value) {
                DwrfStripeCacheOptions dwrfStripeCacheOptions = (DwrfStripeCacheOptions)options.getDwrfStripeCacheOptions().get();
                Assert.assertEquals((Object)dwrfStripeCacheOptions.getStripeCacheMode(), (Object)DWRF_STRIPE_CACHE_MODE);
                Assert.assertEquals((Object)dwrfStripeCacheOptions.getStripeCacheMaxSize(), (Object)DWRF_STRIPE_CACHE_MAX_SIZE);
                continue;
            }
            Assert.assertEquals(Optional.empty(), (Object)options.getDwrfStripeCacheOptions());
        }
    }

    @Test
    public void tesDefaultValues() {
        OrcWriterOptions options = OrcWriterOptions.builder().build();
        Assert.assertEquals((Set)options.getFlattenedColumns(), (Set)ImmutableSet.of());
        Assert.assertFalse((boolean)options.isMapStatisticsEnabled());
        Assert.assertEquals((int)options.getMaxFlattenedMapKeyCount(), (int)20000);
    }

    @Test
    public void testProperties() {
        DataSize stripeMinSize = new DataSize(13.0, DataSize.Unit.MEGABYTE);
        DataSize stripeMaxSize = new DataSize(27.0, DataSize.Unit.MEGABYTE);
        int stripeMaxRowCount = 1100000;
        int rowGroupMaxRowCount = 15000;
        DataSize dictionaryMaxMemory = new DataSize(13000.0, DataSize.Unit.KILOBYTE);
        DataSize dictionaryMemoryRange = new DataSize(1000.0, DataSize.Unit.KILOBYTE);
        int dictionaryUsefulCheckPerChunkFrequency = 9999;
        DataSize dictionaryUsefulCheckColumnSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        DataSize stringMaxStatisticsLimit = new DataSize(128.0, DataSize.Unit.BYTE);
        DataSize maxCompressionBufferSize = new DataSize(512.0, DataSize.Unit.KILOBYTE);
        OptionalInt compressionLevel = OptionalInt.of(5);
        StreamLayoutFactory.StreamSizeLayoutFactory streamLayoutFactory = new StreamLayoutFactory.StreamSizeLayoutFactory();
        boolean integerDictionaryEncodingEnabled = true;
        boolean stringDictionarySortingEnabled = false;
        boolean stringDictionaryEncodingEnabled = false;
        int preserveDirectEncodingStripeCount = 10;
        boolean mapStatisticsEnabled = true;
        int maxFlattenedMapKeyCount = 27;
        OrcWriterOptions.Builder builder = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(stripeMinSize).withStripeMaxSize(stripeMaxSize).withStripeMaxRowCount(stripeMaxRowCount).build()).withRowGroupMaxRowCount(rowGroupMaxRowCount).withDictionaryMaxMemory(dictionaryMaxMemory).withDictionaryMemoryAlmostFullRange(dictionaryMemoryRange).withDictionaryUsefulCheckPerChunkFrequency(dictionaryUsefulCheckPerChunkFrequency).withDictionaryUsefulCheckColumnSize(dictionaryUsefulCheckColumnSize).withMaxStringStatisticsLimit(stringMaxStatisticsLimit).withMaxCompressionBufferSize(maxCompressionBufferSize).withCompressionLevel(compressionLevel).withStreamLayoutFactory((StreamLayoutFactory)streamLayoutFactory).withIntegerDictionaryEncodingEnabled(integerDictionaryEncodingEnabled).withStringDictionarySortingEnabled(stringDictionarySortingEnabled).withStringDictionaryEncodingEnabled(stringDictionaryEncodingEnabled).withPreserveDirectEncodingStripeCount(preserveDirectEncodingStripeCount).withFlattenedColumns((Set)ImmutableSet.of((Object)4, (Object)3)).withMapStatisticsEnabled(mapStatisticsEnabled).withMaxFlattenedMapKeyCount(maxFlattenedMapKeyCount);
        OrcWriterOptions options = builder.build();
        Assert.assertEquals((int)Math.toIntExact(stripeMinSize.toBytes()), (int)options.getFlushPolicy().getStripeMinBytes());
        Assert.assertEquals((int)Math.toIntExact(stripeMaxSize.toBytes()), (int)options.getFlushPolicy().getStripeMaxBytes());
        Assert.assertEquals((int)stripeMaxRowCount, (int)options.getFlushPolicy().getStripeMaxRowCount());
        Assert.assertEquals((int)rowGroupMaxRowCount, (int)options.getRowGroupMaxRowCount());
        Assert.assertEquals((Object)dictionaryMaxMemory, (Object)options.getDictionaryMaxMemory());
        Assert.assertEquals((Object)dictionaryMemoryRange, (Object)options.getDictionaryMemoryAlmostFullRange());
        Assert.assertEquals((int)dictionaryUsefulCheckPerChunkFrequency, (int)options.getDictionaryUsefulCheckPerChunkFrequency());
        Assert.assertEquals((Object)dictionaryUsefulCheckColumnSize, (Object)options.getDictionaryUsefulCheckColumnSize());
        Assert.assertEquals((Object)stringMaxStatisticsLimit, (Object)options.getMaxStringStatisticsLimit());
        Assert.assertEquals((Object)maxCompressionBufferSize, (Object)options.getMaxCompressionBufferSize());
        Assert.assertEquals((Object)compressionLevel, (Object)options.getCompressionLevel());
        Assert.assertEquals((Object)streamLayoutFactory, (Object)options.getStreamLayoutFactory());
        Assert.assertEquals((boolean)integerDictionaryEncodingEnabled, (boolean)options.isIntegerDictionaryEncodingEnabled());
        Assert.assertEquals((boolean)stringDictionarySortingEnabled, (boolean)options.isStringDictionarySortingEnabled());
        Assert.assertEquals((boolean)stringDictionaryEncodingEnabled, (boolean)options.isStringDictionaryEncodingEnabled());
        Assert.assertEquals(Optional.empty(), (Object)options.getDwrfStripeCacheOptions());
        Assert.assertEquals((int)preserveDirectEncodingStripeCount, (int)options.getPreserveDirectEncodingStripeCount());
        Assert.assertEquals((Set)options.getFlattenedColumns(), (Set)ImmutableSet.of((Object)4, (Object)3));
        Assert.assertEquals((boolean)options.isMapStatisticsEnabled(), (boolean)mapStatisticsEnabled);
        Assert.assertEquals((int)options.getMaxFlattenedMapKeyCount(), (int)maxFlattenedMapKeyCount);
    }

    @Test
    public void testToString() {
        DataSize stripeMinSize = new DataSize(13.0, DataSize.Unit.MEGABYTE);
        DataSize stripeMaxSize = new DataSize(27.0, DataSize.Unit.MEGABYTE);
        int stripeMaxRowCount = 1100000;
        int rowGroupMaxRowCount = 15000;
        DataSize dictionaryMaxMemory = new DataSize(13000.0, DataSize.Unit.KILOBYTE);
        DataSize dictionaryMemoryRange = new DataSize(1000.0, DataSize.Unit.KILOBYTE);
        int dictionaryUsefulCheckPerChunkFrequency = 9999;
        DataSize dictionaryUsefulCheckColumnSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        DataSize stringMaxStatisticsLimit = new DataSize(128.0, DataSize.Unit.BYTE);
        DataSize maxCompressionBufferSize = new DataSize(512.0, DataSize.Unit.KILOBYTE);
        DataSize dwrfStripeCacheMaxSize = new DataSize(4.0, DataSize.Unit.MEGABYTE);
        DwrfStripeCacheMode dwrfStripeCacheMode = DwrfStripeCacheMode.INDEX_AND_FOOTER;
        OptionalInt compressionLevel = OptionalInt.of(5);
        StreamLayoutFactory.ColumnSizeLayoutFactory streamLayoutFactory = new StreamLayoutFactory.ColumnSizeLayoutFactory();
        boolean integerDictionaryEncodingEnabled = false;
        boolean stringDictionarySortingEnabled = true;
        int preserveDirectEncodingStripeCount = 0;
        boolean mapStatisticsEnabled = true;
        int maxFlattenedMapKeyCount = 27;
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(stripeMinSize).withStripeMaxSize(stripeMaxSize).withStripeMaxRowCount(stripeMaxRowCount).build()).withRowGroupMaxRowCount(rowGroupMaxRowCount).withDictionaryMaxMemory(dictionaryMaxMemory).withDictionaryMemoryAlmostFullRange(dictionaryMemoryRange).withDictionaryUsefulCheckPerChunkFrequency(dictionaryUsefulCheckPerChunkFrequency).withDictionaryUsefulCheckColumnSize(dictionaryUsefulCheckColumnSize).withMaxStringStatisticsLimit(stringMaxStatisticsLimit).withMaxCompressionBufferSize(maxCompressionBufferSize).withCompressionLevel(compressionLevel).withStreamLayoutFactory((StreamLayoutFactory)streamLayoutFactory).withIntegerDictionaryEncodingEnabled(integerDictionaryEncodingEnabled).withStringDictionarySortingEnabled(stringDictionarySortingEnabled).withDwrfStripeCacheEnabled(true).withDwrfStripeCacheMaxSize(dwrfStripeCacheMaxSize).withDwrfStripeCacheMode(dwrfStripeCacheMode).withPreserveDirectEncodingStripeCount(preserveDirectEncodingStripeCount).withFlattenedColumns((Set)ImmutableSet.of((Object)4)).withMapStatisticsEnabled(mapStatisticsEnabled).withMaxFlattenedMapKeyCount(maxFlattenedMapKeyCount).build();
        String expectedString = "OrcWriterOptions{flushPolicy=DefaultOrcWriterFlushPolicy{stripeMaxRowCount=1100000, stripeMinBytes=13631488, stripeMaxBytes=28311552}, rowGroupMaxRowCount=15000, dictionaryMaxMemory=13000kB, dictionaryMemoryAlmostFullRange=1000kB, dictionaryUsefulCheckPerChunkFrequency=9999, dictionaryUsefulCheckColumnSize=1MB, maxStringStatisticsLimit=128B, maxCompressionBufferSize=512kB, compressionLevel=OptionalInt[5], streamLayoutFactory=ColumnSizeLayoutFactory{}, integerDictionaryEncodingEnabled=false, stringDictionarySortingEnabled=true, stringDictionaryEncodingEnabled=true, dwrfWriterOptions=Optional[DwrfStripeCacheOptions{stripeCacheMode=INDEX_AND_FOOTER, stripeCacheMaxSize=4MB}], ignoreDictionaryRowGroupSizes=false, preserveDirectEncodingStripeCount=0, flattenedColumns=[4], mapStatisticsEnabled=true, maxFlattenedMapKeyCount=27}";
        Assert.assertEquals((String)expectedString, (String)writerOptions.toString());
    }
}

