/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.testing.assertions.Assert;
import io.airlift.slice.Slices;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestPositionalFilter {
    @Test
    public void test() {
        TupleDomainFilter.PositionalFilter filter = new TupleDomainFilter.PositionalFilter();
        TupleDomainFilter[] filters = new TupleDomainFilter[]{this.equals(1), null, this.equals(3), null, this.equals(1), null, this.equals(3), null, this.equals(1), null, this.equals(3), null, null, this.equals(1), null, this.equals(3), null, null, null, this.equals(1), null, this.equals(3), null, null, null, null};
        long[] numbers = new long[]{1L, 2L, 3L, 4L, 0L, 2L, 3L, 4L, 1L, 2L, 0L, 4L, 55L, 1L, 0L, 3L, 0L, 5L, 6L, 1L, 1L, 2L, 2L, 3L, 3L, 4L};
        byte[][] values = (byte[][])Arrays.stream(numbers).mapToObj(n -> TestPositionalFilter.toBytes(Long.valueOf(n).toString())).toArray(x$0 -> new byte[x$0][]);
        boolean[] expectedResults = new boolean[]{true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, false};
        int[] offsets = new int[]{0, 4, 8, 13, 19, 26};
        filter.setFilters(filters, offsets);
        int valuesIndex = 0;
        for (int i = 0; i < expectedResults.length; ++i) {
            boolean result = filter.testLength(values[valuesIndex].length) && filter.testBytes(values[valuesIndex], 0, values[valuesIndex].length);
            Assert.assertEquals((boolean)expectedResults[i], (boolean)result);
            ++valuesIndex;
            if (expectedResults[i]) continue;
            valuesIndex += filter.getSucceedingPositionsToFail();
        }
        Assert.assertEquals((boolean[])new boolean[]{false, true, true, false, true, false}, (boolean[])filter.getFailed());
    }

    private TupleDomainFilter equals(int value) {
        byte[] bytesValue = TestPositionalFilter.toBytes(Integer.valueOf(value).toString());
        return TupleDomainFilter.BytesRange.of((byte[])bytesValue, (boolean)false, (byte[])bytesValue, (boolean)false, (boolean)false);
    }

    private static byte[] toBytes(String value) {
        return Slices.utf8Slice((String)value).getBytes();
    }
}

