/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestReadBloomFilter {
    @Test
    public void test() throws Exception {
        TestReadBloomFilter.testType((Type)TinyintType.TINYINT, ImmutableList.of((Object)1L, (Object)50L, (Object)100L), 50L, 77L);
        TestReadBloomFilter.testType((Type)SmallintType.SMALLINT, ImmutableList.of((Object)1L, (Object)5000L, (Object)10000L), 5000L, 7777L);
        TestReadBloomFilter.testType((Type)IntegerType.INTEGER, ImmutableList.of((Object)1L, (Object)500000L, (Object)1000000L), 500000L, 777777L);
        TestReadBloomFilter.testType((Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)500000L, (Object)1000000L), 500000L, 777777L);
        TestReadBloomFilter.testType((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.11, (Object)500000.55, (Object)1000000.99), 500000.55, 777777.77);
        TestReadBloomFilter.testType((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"o", (Object)"z"), Slices.utf8Slice((String)"o"), Slices.utf8Slice((String)"w"));
        TestReadBloomFilter.testType((Type)VarbinaryType.VARBINARY, ImmutableList.of((Object)new SqlVarbinary("a".getBytes(StandardCharsets.UTF_8)), (Object)new SqlVarbinary("o".getBytes(StandardCharsets.UTF_8)), (Object)new SqlVarbinary("z".getBytes(StandardCharsets.UTF_8))), Slices.utf8Slice((String)"o"), Slices.utf8Slice((String)"w"));
    }

    private static <T> void testType(Type type, List<T> uniqueValues, T inBloomFilter, T notInBloomFilter) throws Exception {
        ArrayList writeValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle(uniqueValues), (int)30000));
        try (TempFile tempFile = new TempFile();){
            OrcTester.writeOrcColumnHive(tempFile.getFile(), OrcTester.Format.ORC_12, CompressionKind.SNAPPY, type, writeValues);
            try (OrcBatchRecordReader recordReader = TestReadBloomFilter.createCustomOrcRecordReader(tempFile, type, Optional.empty(), true);){
                Assert.assertEquals((int)recordReader.nextBatch(), (int)1024);
            }
            recordReader = TestReadBloomFilter.createCustomOrcRecordReader(tempFile, type, Optional.empty(), false);
            var8_10 = null;
            try {
                Assert.assertEquals((int)recordReader.nextBatch(), (int)1024);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            finally {
                if (recordReader != null) {
                    if (var8_10 != null) {
                        try {
                            recordReader.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        recordReader.close();
                    }
                }
            }
            recordReader = TestReadBloomFilter.createCustomOrcRecordReader(tempFile, type, Optional.of(notInBloomFilter), true);
            var8_10 = null;
            try {
                Assert.assertEquals((int)recordReader.nextBatch(), (int)-1);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            finally {
                if (recordReader != null) {
                    if (var8_10 != null) {
                        try {
                            recordReader.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        recordReader.close();
                    }
                }
            }
            recordReader = TestReadBloomFilter.createCustomOrcRecordReader(tempFile, type, Optional.of(notInBloomFilter), false);
            var8_10 = null;
            try {
                Assert.assertEquals((int)recordReader.nextBatch(), (int)1024);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            finally {
                if (recordReader != null) {
                    if (var8_10 != null) {
                        try {
                            recordReader.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        recordReader.close();
                    }
                }
            }
            recordReader = TestReadBloomFilter.createCustomOrcRecordReader(tempFile, type, Optional.of(inBloomFilter), true);
            var8_10 = null;
            try {
                Assert.assertEquals((int)recordReader.nextBatch(), (int)1024);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            finally {
                if (recordReader != null) {
                    if (var8_10 != null) {
                        try {
                            recordReader.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        recordReader.close();
                    }
                }
            }
            recordReader = TestReadBloomFilter.createCustomOrcRecordReader(tempFile, type, Optional.of(inBloomFilter), false);
            var8_10 = null;
            try {
                Assert.assertEquals((int)recordReader.nextBatch(), (int)1024);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            finally {
                if (recordReader != null) {
                    if (var8_10 != null) {
                        try {
                            recordReader.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        recordReader.close();
                    }
                }
            }
        }
    }

    private static <T> OrcBatchRecordReader createCustomOrcRecordReader(TempFile tempFile, Type type, Optional<T> filterValue, boolean bloomFilterEnabled) throws IOException {
        OrcPredicate predicate = filterValue.map(value -> TestReadBloomFilter.makeOrcPredicate(type, value, bloomFilterEnabled)).map(OrcPredicate.class::cast).orElse(OrcPredicate.TRUE);
        FileOrcDataSource orcDataSource = new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
        Assert.assertEquals((Collection)orcReader.getColumnNames(), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((int)orcReader.getFooter().getRowsInRowGroup(), (int)10000);
        return orcReader.createBatchRecordReader((Map)ImmutableMap.of((Object)0, (Object)type), predicate, OrcTester.HIVE_STORAGE_TIME_ZONE, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), 1024);
    }

    private static <T> TupleDomainOrcPredicate<String> makeOrcPredicate(Type type, T value, boolean bloomFilterEnabled) {
        return new TupleDomainOrcPredicate(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)"test", (Object)NullableValue.of((Type)type, value))), (List)ImmutableList.of((Object)new TupleDomainOrcPredicate.ColumnReference((Object)"test", 0, type)), bloomFilterEnabled, Optional.empty());
    }
}

