/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.predicate.TupleDomainFilterUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingOrcPredicate;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSelectiveOrcReader {
    private static final int NUM_ROWS = 31234;
    private static final DecimalType DECIMAL_TYPE_PRECISION_2 = DecimalType.createDecimalType((int)2, (int)1);
    private static final DecimalType DECIMAL_TYPE_PRECISION_4 = DecimalType.createDecimalType((int)4, (int)2);
    private static final DecimalType DECIMAL_TYPE_PRECISION_19 = DecimalType.createDecimalType((int)19, (int)8);
    private static final CharType CHAR_10 = CharType.createCharType((long)10L);
    private final OrcTester tester = OrcTester.quickSelectiveOrcTester();

    @BeforeClass
    public void setUp() {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)OrcTester.HIVE_STORAGE_TIME_ZONE);
    }

    @Test
    public void testBooleanSequence() throws Exception {
        this.tester.testRoundTrip((Type)BooleanType.BOOLEAN, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)false, (Object)false)), (int)31234)), new TupleDomainFilter[]{TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)false), TupleDomainFilter.IS_NULL});
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)false, (Object)false)), (int)31234)), (Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)true, (Object)false)), (int)31234))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)false)), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)false)), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BooleanValue.of((boolean)false, (boolean)false), (Object)1, (Object)TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)false))}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Object[])new Boolean[]{true, false, null, false, true}), (Object)Lists.newArrayList((Object[])new Object[]{null, null, null, null, null}), (Object)Lists.newArrayList((Object[])new Boolean[]{true, false, null, false, null})), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)false), (Object)1, (Object)TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)true), (Object)2, (Object)TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)true))}));
    }

    @Test
    public void testByteValues() throws Exception {
        List byteValues = ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17).stream().map(Integer::byteValue).collect(Collectors.toList());
        this.tester.testRoundTrip((Type)TinyintType.TINYINT, byteValues, new TupleDomainFilter[]{TupleDomainFilter.BigintValuesUsingHashTable.of((long)1L, (long)17L, (long[])new long[]{1L, 17L}, (boolean)false), TupleDomainFilter.IS_NULL});
        List<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters = TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)1L, (long)17L, (boolean)false)), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)7L, (long)17L, (boolean)false), (Object)1, (Object)TupleDomainFilter.BigintRange.of((long)12L, (long)14L, (boolean)false))});
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)TinyintType.TINYINT, (Object)TinyintType.TINYINT), (List<List<?>>)ImmutableList.of(byteValues, byteValues), filters);
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)TinyintType.TINYINT, (Object)TinyintType.TINYINT, (Object)TinyintType.TINYINT), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.toByteArray(Lists.newArrayList((Object[])new Integer[]{1, 2, null, 3, 4})), (Object)Lists.newArrayList((Object[])new Object[]{null, null, null, null, null}), TestSelectiveOrcReader.toByteArray(Lists.newArrayList((Object[])new Integer[]{5, 6, null, 7, null}))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintValuesUsingHashTable.of((long)1L, (long)4L, (long[])new long[]{1L, 4L}, (boolean)false), (Object)1, (Object)TupleDomainFilter.BigintValuesUsingHashTable.of((long)1L, (long)5L, (long[])new long[]{1L, 5L}, (boolean)true), (Object)2, (Object)TupleDomainFilter.BigintValuesUsingHashTable.of((long)5L, (long)7L, (long[])new long[]{5L, 7L}, (boolean)true))}));
    }

    @Test
    public void testByteValuesRepeat() throws Exception {
        List byteValues = ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17).stream().map(Integer::byteValue).collect(Collectors.toList());
        this.tester.testRoundTrip((Type)TinyintType.TINYINT, Lists.newArrayList((Iterable)Iterables.limit(TestSelectiveOrcReader.repeatEach(4, Iterables.cycle(byteValues)), (int)31234)), new TupleDomainFilter[]{TupleDomainFilter.BigintRange.of((long)1L, (long)14L, (boolean)true)});
    }

    @Test
    public void testByteValuesPatchedBase() throws Exception {
        List byteValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat(TestSelectiveOrcReader.intsBetween(0, 18), TestSelectiveOrcReader.intsBetween(0, 18), (Iterable)ImmutableList.of((Object)31234, (Object)20000, (Object)400000, (Object)31234, (Object)20000))), (int)31234)).stream().map(Integer::byteValue).collect(Collectors.toList());
        this.tester.testRoundTrip((Type)TinyintType.TINYINT, byteValues, new TupleDomainFilter[]{TupleDomainFilter.BigintRange.of((long)4L, (long)14L, (boolean)true)});
    }

    @Test
    public void testDoubleSequence() throws Exception {
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, TestSelectiveOrcReader.doubleSequence(0.0, 0.1, 31234), new TupleDomainFilter[]{TupleDomainFilter.DoubleRange.of((double)0.0, (boolean)false, (boolean)false, (double)1000.0, (boolean)false, (boolean)false, (boolean)false), TupleDomainFilter.IS_NULL, TupleDomainFilter.IS_NOT_NULL});
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.doubleSequence(0.0, 0.1, 10000), TestSelectiveOrcReader.doubleSequence(0.0, 0.1, 10000)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.DoubleRange.of((double)1.0, (boolean)false, (boolean)true, (double)7.0, (boolean)false, (boolean)true, (boolean)true), (Object)1, (Object)TupleDomainFilter.DoubleRange.of((double)3.0, (boolean)false, (boolean)true, (double)9.0, (boolean)false, (boolean)true, (boolean)false))}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Object[])new Double[]{1.0, 2.0, null, 3.0, 4.0}), (Object)Lists.newArrayList((Object[])new Object[]{null, null, null, null, null}), (Object)Lists.newArrayList((Object[])new Double[]{1.0, 2.0, null, 3.0, null})), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.DoubleRange.of((double)1.0, (boolean)false, (boolean)true, (double)7.0, (boolean)false, (boolean)true, (boolean)true), (Object)1, (Object)TupleDomainFilter.DoubleRange.of((double)1.0, (boolean)false, (boolean)true, (double)7.0, (boolean)false, (boolean)true, (boolean)true), (Object)2, (Object)TupleDomainFilter.DoubleRange.of((double)1.0, (boolean)false, (boolean)true, (double)7.0, (boolean)false, (boolean)true, (boolean)true))}));
    }

    @Test
    public void testDoubleNaNInfinity() throws Exception {
        List<Map<Subfield, TupleDomainFilter>> filters = TestSelectiveOrcReader.toSubfieldFilters(new TupleDomainFilter[]{TupleDomainFilter.DoubleRange.of((double)0.0, (boolean)false, (boolean)false, (double)1000.0, (boolean)false, (boolean)false, (boolean)false), TupleDomainFilter.IS_NULL, TupleDomainFilter.IS_NOT_NULL});
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)1000.0, (Object)-1.0, (Object)Double.POSITIVE_INFINITY), filters);
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)-1000.0, (Object)Double.NEGATIVE_INFINITY, (Object)1.0), filters);
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)0.0, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY), filters);
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)1.0), filters);
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)Double.POSITIVE_INFINITY), filters);
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)1.0), filters);
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY), filters);
    }

    @Test
    public void testLongSequence() throws Exception {
        this.testRoundTripNumeric((Iterable<? extends Number>)TestSelectiveOrcReader.intsBetween(0, 31234), (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)10L, (long)100L, (boolean)false));
    }

    @Test
    public void testNegativeLongSequence() throws Exception {
        this.testRoundTripNumeric((Iterable<? extends Number>)TestSelectiveOrcReader.intsBetween(-31234, -999), (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)-1000L, (long)-100L, (boolean)true));
    }

    @Test
    public void testLongSequenceWithHoles() throws Exception {
        this.testRoundTripNumeric(TestSelectiveOrcReader.skipEvery(5, TestSelectiveOrcReader.intsBetween(0, 31234)), (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)10L, (long)100L, (boolean)false));
    }

    @Test
    public void testLongDirect() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234), (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)4L, (long)14L, (boolean)false));
        Random random = new Random(0L);
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt(10)), TestSelectiveOrcReader.createList(31234, i -> null)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)5L, (boolean)false))}));
    }

    @Test
    public void testLongDirect2() throws Exception {
        List values = IntStream.range(0, 31234).boxed().collect(Collectors.toList());
        Collections.shuffle(values, new Random(0L));
        this.testRoundTripNumeric(values, (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)4L, (long)14L, (boolean)false));
    }

    @Test
    public void testLongDirectVarintScale() throws Exception {
        List<Long> values = TestSelectiveOrcReader.varintScaleSequence(31234);
        Collections.shuffle(values, new Random(0L));
        this.testRoundTripNumeric(values, (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)0L, (long)0x1000000000000000L, (boolean)false));
    }

    @Test
    public void testLongShortRepeat() throws Exception {
        this.testRoundTripNumeric(Iterables.limit(TestSelectiveOrcReader.repeatEach(4, Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17))), (int)31234), (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)4L, (long)14L, (boolean)true));
    }

    @Test
    public void testLongPatchedBase() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat(TestSelectiveOrcReader.intsBetween(0, 18), TestSelectiveOrcReader.intsBetween(0, 18), (Iterable)ImmutableList.of((Object)31234, (Object)20000, (Object)400000, (Object)31234, (Object)20000))), (int)31234), TupleDomainFilterUtils.toBigintValues((long[])new long[]{0L, 5L, 10L, 15L, 20000L}, (boolean)true));
    }

    @Test
    public void testLongStrideDictionary() throws Exception {
        this.testRoundTripNumeric(Iterables.concat((Iterable)ImmutableList.of((Object)1), Collections.nCopies(9999, 123), (Iterable)ImmutableList.of((Object)2), Collections.nCopies(9999, 123)), (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)123L, (long)123L, (boolean)true));
    }

    @Test
    public void testFloats() throws Exception {
        List<Map<Subfield, TupleDomainFilter>> filters = TestSelectiveOrcReader.toSubfieldFilters(new TupleDomainFilter[]{TupleDomainFilter.FloatRange.of((float)0.0f, (boolean)false, (boolean)true, (float)100.0f, (boolean)false, (boolean)true, (boolean)true), TupleDomainFilter.FloatRange.of((float)-100.0f, (boolean)false, (boolean)true, (float)0.0f, (boolean)false, (boolean)true, (boolean)false), TupleDomainFilter.IS_NULL});
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.copyOf(TestSelectiveOrcReader.repeatEach(10, ImmutableList.of((Object)Float.valueOf(-100.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(100.0f)))), filters);
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.copyOf(TestSelectiveOrcReader.repeatEach(10, ImmutableList.of((Object)Float.valueOf(1000.0f), (Object)Float.valueOf(-1.23f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)))));
        ImmutableList floatValues = ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f), (Object)Float.valueOf(4.0f), (Object)Float.valueOf(5.0f), (Object)Float.valueOf(6.0f), (Object)Float.valueOf(7.0f), (Object)Float.valueOf(8.0f), (Object)Float.valueOf(9.0f));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL), (List<List<?>>)ImmutableList.of((Object)ImmutableList.copyOf((Iterable)Iterables.limit(TestSelectiveOrcReader.repeatEach(4, Iterables.cycle((Iterable)floatValues)), (int)100)), (Object)ImmutableList.copyOf((Iterable)Iterables.limit(TestSelectiveOrcReader.repeatEach(4, Iterables.cycle((Iterable)floatValues)), (int)100))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.FloatRange.of((float)1.0f, (boolean)false, (boolean)true, (float)7.0f, (boolean)false, (boolean)true, (boolean)true), (Object)1, (Object)TupleDomainFilter.FloatRange.of((float)3.0f, (boolean)false, (boolean)true, (float)9.0f, (boolean)false, (boolean)true, (boolean)false)), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.FloatRange.of((float)1.0f, (boolean)false, (boolean)true, (float)7.0f, (boolean)false, (boolean)true, (boolean)true))}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL, (Object)RealType.REAL), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)}), (Object)Lists.newArrayList((Object[])new Object[]{null, null, null, null, null}), (Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null, Float.valueOf(3.0f), null})), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.FloatRange.of((float)2.0f, (boolean)false, (boolean)false, (float)7.0f, (boolean)false, (boolean)true, (boolean)true), (Object)1, (Object)TupleDomainFilter.FloatRange.of((float)1.0f, (boolean)false, (boolean)false, (float)7.0f, (boolean)false, (boolean)true, (boolean)true), (Object)2, (Object)TupleDomainFilter.FloatRange.of((float)1.0f, (boolean)false, (boolean)false, (float)7.0f, (boolean)false, (boolean)true, (boolean)true))}));
    }

    @Test
    public void testFilterOrder() throws Exception {
        Random random = new Random(0L);
        this.tester.testRoundTripTypesWithOrder((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11)), (int)31234)), TestSelectiveOrcReader.randomIntegers(31234, random)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)1L, (long)1L, (boolean)true), (Object)1, (Object)TupleDomainFilter.BigintRange.of((long)2L, (long)200L, (boolean)true))}), (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1)));
        this.tester.testRoundTripTypesWithOrder((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11)), (int)31234)), TestSelectiveOrcReader.randomIntegers(31234, random)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)100L, (long)100L, (boolean)false), (Object)1, (Object)TupleDomainFilter.BigintRange.of((long)2L, (long)200L, (boolean)true))}), (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)0)));
        this.tester.testRoundTripTypesWithOrder((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE, (Object)OrcTester.arrayType((Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11)), (int)31234)), TestSelectiveOrcReader.createList(31234, i -> random.nextInt(200)), TestSelectiveOrcReader.doubleSequence(0.0, 0.1, 31234), Collections.nCopies(31234, TestSelectiveOrcReader.randomIntegers(5, random))), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of((Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)1L, (long)1L, (boolean)true)), (Object)1, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)0L, (long)200L, (boolean)true)), (Object)2, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)TupleDomainFilter.DoubleRange.of((double)0.0, (boolean)false, (boolean)false, (double)0.1, (boolean)false, (boolean)false, (boolean)true)), (Object)3, TestSelectiveOrcReader.toSubfieldFilter("c[1]", (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)4L, (long)4L, (boolean)false)))), (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3)));
    }

    @Test
    public void testArrays() throws Exception {
        Random random = new Random(0L);
        this.tester.testRoundTrip(OrcTester.arrayType((Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.randomIntegers(random.nextInt(10), random)), TupleDomainFilter.IS_NULL, TupleDomainFilter.IS_NOT_NULL);
        TupleDomainFilter.BigintRange negative = TupleDomainFilter.BigintRange.of((long)Integer.MIN_VALUE, (long)0L, (boolean)false);
        TupleDomainFilter.BigintRange nonNegative = TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false);
        this.tester.testRoundTrip(OrcTester.arrayType((Type)VarcharType.VARCHAR), TestSelectiveOrcReader.createList(1000, i -> TestSelectiveOrcReader.randomStrings(5 + random.nextInt(5), random)), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of(TestSelectiveOrcReader.toSubfieldFilter("c[1]", TupleDomainFilter.IS_NULL), TestSelectiveOrcReader.toSubfieldFilter("c[1]", TestSelectiveOrcReader.stringIn(true, "a", "b", "c", "d"))));
        this.tester.testRoundTrip(OrcTester.arrayType((Type)VarcharType.VARCHAR), TestSelectiveOrcReader.createList(10, i -> TestSelectiveOrcReader.randomStringsWithNulls(5 + random.nextInt(5), random)), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of(TestSelectiveOrcReader.toSubfieldFilter("c[1]", TupleDomainFilter.IS_NULL), TestSelectiveOrcReader.toSubfieldFilter("c[1]", TestSelectiveOrcReader.stringIn(true, "a", "b", "c", "d"))));
        this.tester.testRoundTrip(OrcTester.arrayType((Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.randomIntegers(5 + random.nextInt(5), random)), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of(TestSelectiveOrcReader.toSubfieldFilter(TupleDomainFilter.IS_NULL), TestSelectiveOrcReader.toSubfieldFilter(TupleDomainFilter.IS_NOT_NULL), TestSelectiveOrcReader.toSubfieldFilter("c[1]", (TupleDomainFilter)nonNegative), (Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)nonNegative, (Object)new Subfield("c[4]"), (Object)nonNegative)));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.arrayType((Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.randomIntegers(31234, random), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.randomIntegers(random.nextInt(10), random))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)nonNegative), ImmutableMap.of((Object)0, (Object)nonNegative, (Object)1, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)0, (Object)nonNegative, (Object)1, (Object)TupleDomainFilter.IS_NOT_NULL)}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.arrayType((Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.randomIntegers(31234, random), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.randomIntegers(5 + random.nextInt(5), random))), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of((Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)nonNegative), (Object)1, TestSelectiveOrcReader.toSubfieldFilter("c[1]", (TupleDomainFilter)nonNegative)), (Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)nonNegative), (Object)1, TestSelectiveOrcReader.toSubfieldFilter("c[3]", (TupleDomainFilter)nonNegative)), (Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)nonNegative), (Object)1, (Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)nonNegative, (Object)new Subfield("c[4]"), (Object)negative))));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.arrayType(OrcTester.arrayType((Type)IntegerType.INTEGER))), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.randomIntegers(31234, random), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.createList(random.nextInt(10), index -> TestSelectiveOrcReader.randomIntegers(random.nextInt(5), random)))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)nonNegative), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NOT_NULL), ImmutableMap.of((Object)0, (Object)nonNegative, (Object)1, (Object)TupleDomainFilter.IS_NULL)}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.arrayType(OrcTester.arrayType((Type)IntegerType.INTEGER))), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.randomIntegers(31234, random), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.createList(3 + random.nextInt(10), index -> TestSelectiveOrcReader.randomIntegers(3 + random.nextInt(5), random)))), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)new Subfield("c[1]"), (Object)TupleDomainFilter.IS_NULL)), (Object)ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)TupleDomainFilter.IS_NOT_NULL, (Object)new Subfield("c[2][3]"), (Object)nonNegative)), (Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)nonNegative), (Object)1, (Object)ImmutableMap.of((Object)new Subfield("c[1]"), (Object)TupleDomainFilter.IS_NULL))));
    }

    @Test
    public void testArraysWithSubfieldPruning() throws Exception {
        this.tester.assertRoundTripWithSettings(OrcTester.arrayType((Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4)), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1]", "c[2]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2]").build()));
        Random random = new Random(0L);
        this.tester.assertRoundTripWithSettings(OrcTester.arrayType((Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> ImmutableList.of((Object)random.nextInt(10), (Object)random.nextInt(10), (Object)3, (Object)4)), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1]", "c[3]").setColumnFilters((Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)new Subfield("c[1]"), (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)4L, (boolean)false)))).build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2]", "c[3]").setColumnFilters((Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)4L, (boolean)false)))).build()));
        this.tester.assertRoundTripWithSettings(OrcTester.arrayType(OrcTester.arrayType((Type)IntegerType.INTEGER)), TestSelectiveOrcReader.createList(31234, i -> Collections.nCopies(1 + random.nextInt(5), ImmutableList.of((Object)1, (Object)2, (Object)3))), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1][1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][2]", "c[4][2]", "c[5][3]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][3]", "c[10][2]", "c[3][10]").build()));
        this.tester.assertRoundTripWithSettings(OrcTester.arrayType(OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), TestSelectiveOrcReader.createList(31234, i -> Collections.nCopies(5, ImmutableMap.of((Object)1, (Object)10, (Object)2, (Object)20))), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1][1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][1]", "c[4][1]", "c[3][2]").build()));
    }

    @Test
    public void testArrayIndexOutOfBounds() throws Exception {
        Random random = new Random(0L);
        try {
            this.tester.testRoundTrip(OrcTester.arrayType((Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.randomIntegers(random.nextInt(10), random)), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of((Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)TupleDomainFilter.IS_NULL)));
            Assert.fail((String)"Expected 'Array subscript out of bounds' exception");
        }
        catch (InvalidFunctionArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Array subscript out of bounds"));
        }
        try {
            this.tester.testRoundTrip(OrcTester.arrayType(OrcTester.arrayType((Type)IntegerType.INTEGER)), TestSelectiveOrcReader.createList(31234, i -> ImmutableList.of(TestSelectiveOrcReader.randomIntegers(random.nextInt(5), random), TestSelectiveOrcReader.randomIntegers(random.nextInt(5), random))), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of((Object)ImmutableMap.of((Object)new Subfield("c[2][3]"), (Object)TupleDomainFilter.IS_NULL)));
            Assert.fail((String)"Expected 'Array subscript out of bounds' exception");
        }
        catch (InvalidFunctionArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Array subscript out of bounds"));
        }
        try {
            this.tester.testRoundTrip(OrcTester.arrayType((Type)IntegerType.INTEGER), Collections.nCopies(31234, ImmutableList.of()), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of((Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)TupleDomainFilter.IS_NULL)));
            Assert.fail((String)"Expected 'Array subscript out of bounds' exception");
        }
        catch (InvalidFunctionArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Array subscript out of bounds"));
        }
        try {
            this.tester.testRoundTrip(OrcTester.arrayType(OrcTester.arrayType((Type)IntegerType.INTEGER)), Collections.nCopies(31234, ImmutableList.of()), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of((Object)ImmutableMap.of((Object)new Subfield("c[2][3]"), (Object)TupleDomainFilter.IS_NULL)));
            Assert.fail((String)"Expected 'Array subscript out of bounds' exception");
        }
        catch (InvalidFunctionArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Array subscript out of bounds"));
        }
    }

    @Test
    public void testArraysOfNulls() throws Exception {
        for (Type type : ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)DoubleType.DOUBLE, (Object)RealType.REAL, (Object)TimestampType.TIMESTAMP, (Object)DECIMAL_TYPE_PRECISION_19, (Object)DECIMAL_TYPE_PRECISION_4, (Object)VarcharType.VARCHAR, (Object)CHAR_10, (Object[])new Type[]{VarbinaryType.VARBINARY, OrcTester.arrayType((Type)IntegerType.INTEGER)})) {
            this.tester.testRoundTrip(OrcTester.arrayType(type), Collections.nCopies(31234, Collections.nCopies(5, null)), (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of((Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)TupleDomainFilter.IS_NULL), (Object)ImmutableMap.of((Object)new Subfield("c[2]"), (Object)TupleDomainFilter.IS_NOT_NULL)));
        }
    }

    @Test
    public void testStructs() throws Exception {
        Random random = new Random(0L);
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.rowType(new Type[]{IntegerType.INTEGER, BooleanType.BOOLEAN})), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt()), TestSelectiveOrcReader.createList(31234, i -> ImmutableList.of((Object)random.nextInt(), (Object)random.nextBoolean()))), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of((Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false))), (Object)ImmutableMap.of((Object)1, TestSelectiveOrcReader.toSubfieldFilter(TupleDomainFilter.IS_NULL)), (Object)ImmutableMap.of((Object)1, TestSelectiveOrcReader.toSubfieldFilter(TupleDomainFilter.IS_NOT_NULL)), (Object)ImmutableMap.of((Object)1, TestSelectiveOrcReader.toSubfieldFilter("c.field_0", (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false))), (Object)ImmutableMap.of((Object)1, TestSelectiveOrcReader.toSubfieldFilter("c.field_0", TupleDomainFilter.IS_NULL))));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)OrcTester.rowType(new Type[]{IntegerType.INTEGER, BooleanType.BOOLEAN}), (Object)IntegerType.INTEGER), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> i % 7 == 0 ? null : ImmutableList.of((Object)random.nextInt(), (Object)random.nextBoolean())), TestSelectiveOrcReader.createList(31234, i -> i % 11 == 0 ? null : Integer.valueOf(random.nextInt()))), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of((Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter(TupleDomainFilter.IS_NOT_NULL), (Object)1, TestSelectiveOrcReader.toSubfieldFilter(TupleDomainFilter.IS_NULL)), (Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter("c.field_0", (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false))), (Object)ImmutableMap.of((Object)0, TestSelectiveOrcReader.toSubfieldFilter("c.field_0", (TupleDomainFilter)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)true)))));
    }

    @Test
    public void testMaps() throws Exception {
        Random random = new Random(0L);
        this.tester.testRoundTrip(OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.createMap(i)));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt()), TestSelectiveOrcReader.createList(31234, i -> TestSelectiveOrcReader.createMap(i))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false)), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NOT_NULL), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NULL)}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt()), TestSelectiveOrcReader.createList(31234, i -> i % 5 == 0 ? null : TestSelectiveOrcReader.createMap(i))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false)), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NOT_NULL), ImmutableMap.of((Object)1, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false), (Object)1, (Object)TupleDomainFilter.IS_NULL), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false), (Object)1, (Object)TupleDomainFilter.IS_NOT_NULL)}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Object)IntegerType.INTEGER), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> i % 5 == 0 ? null : TestSelectiveOrcReader.createMap(i)), TestSelectiveOrcReader.createList(31234, i -> random.nextInt())), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.IS_NULL, (Object)1, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false)), ImmutableMap.of((Object)0, (Object)TupleDomainFilter.IS_NOT_NULL, (Object)1, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)Integer.MAX_VALUE, (boolean)false))}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt()), Collections.nCopies(31234, ImmutableMap.of())), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of());
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt(10)), TestSelectiveOrcReader.createList(31234, i -> null)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)5L, (boolean)false))}));
    }

    @Test
    public void testMapsWithSubfieldPruning() throws Exception {
        this.tester.assertRoundTripWithSettings(OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), TestSelectiveOrcReader.createList(31234, i -> ImmutableMap.of((Object)1, (Object)10, (Object)2, (Object)20)), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[10]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2]", "c[10]").build()));
        this.tester.assertRoundTripWithSettings(OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), TestSelectiveOrcReader.createList(31234, i -> ImmutableMap.of((Object)1, TestSelectiveOrcReader.createMap(i), (Object)2, TestSelectiveOrcReader.createMap(i + 1))), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1][1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][2]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][1]", "c[10][1]").build()));
        this.tester.assertRoundTripWithSettings(OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.arrayType((Type)IntegerType.INTEGER)), TestSelectiveOrcReader.createList(31234, i -> ImmutableMap.of((Object)1, Collections.nCopies(5, 10), (Object)2, Collections.nCopies(5, 20))), (List<OrcTester.OrcReaderSettings>)ImmutableList.of((Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[1][1]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][2]", "c[2][3]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][2]", "c[10][3]", "c[2][10]").build(), (Object)OrcTester.OrcReaderSettings.builder().addRequiredSubfields(0, "c[2][2]", "c[1][2]").build()));
    }

    private static Map<Integer, Integer> createMap(int seed) {
        int mapSize = Math.abs(seed) % 7 + 1;
        return (Map)IntStream.range(0, mapSize).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), i -> i + seed));
    }

    private static <T> List<T> createList(int size, Function<Integer, T> createElement) {
        return IntStream.range(0, size).mapToObj(createElement::apply).collect(Collectors.toList());
    }

    @Test
    public void testDecimalSequence() throws Exception {
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_4, TestSelectiveOrcReader.decimalSequence("-3000", "1", 6000, 4, 2));
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_19, TestSelectiveOrcReader.decimalSequence("-3000000000000000000", "100000000000000101", 60, 19, 8));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)DECIMAL_TYPE_PRECISION_2, (Object)DECIMAL_TYPE_PRECISION_2), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.decimalSequence("-30", "1", 60, 2, 1), TestSelectiveOrcReader.decimalSequence("-30", "1", 60, 2, 1)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)10L, (long)20L, (boolean)true))}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)DECIMAL_TYPE_PRECISION_2, (Object)DECIMAL_TYPE_PRECISION_2), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.decimalSequence("-30", "1", 60, 2, 1), TestSelectiveOrcReader.decimalSequence("-30", "1", 60, 2, 1)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)10L, (long)30L, (boolean)true), (Object)1, (Object)TupleDomainFilter.BigintRange.of((long)15L, (long)25L, (boolean)true))}));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)DECIMAL_TYPE_PRECISION_19, (Object)DECIMAL_TYPE_PRECISION_19), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.decimalSequence("-3000000000000000000", "100000000000000101", 60, 19, 8), TestSelectiveOrcReader.decimalSequence("-3000000000000000000", "100000000000000101", 60, 19, 8)), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.LongDecimalRange.of((long)-28999999999L, (long)-28999999999L, (boolean)false, (boolean)true, (long)28999999999L, (long)28999999999L, (boolean)false, (boolean)true, (boolean)true), (Object)1, (Object)TupleDomainFilter.LongDecimalRange.of((long)1000000000L, (long)1000000000L, (boolean)false, (boolean)true, (long)28999999999L, (long)28999999999L, (boolean)false, (boolean)true, (boolean)true))}));
    }

    @Test
    public void testVarchars() throws Exception {
        Random random = new Random(0L);
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Object[])new String[]{"abc", "def", null, "hij", "klm"}), (Object)Lists.newArrayList((Object[])new Object[]{null, null, null, null, null}), (Object)Lists.newArrayList((Object[])new String[]{"abc", "def", null, null, null})), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TestSelectiveOrcReader.stringIn(true, "abc", "def"), (Object)1, (Object)TestSelectiveOrcReader.stringIn(true, "10", "11"), (Object)2, (Object)TestSelectiveOrcReader.stringIn(true, "def", "abc"))}));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"apple", (Object)"apple pie", (Object)"apple\ud835\udc03", (Object)"apple\ufffd")), (int)31234)), TestSelectiveOrcReader.stringIn(false, "apple", "apple pie"));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, TestSelectiveOrcReader.intsBetween(0, 31234).stream().map(Object::toString).collect(Collectors.toList()), TestSelectiveOrcReader.stringIn(false, "10", "11"), TestSelectiveOrcReader.stringIn(true, "10", "11"), TestSelectiveOrcReader.stringBetween(false, "14", "10"));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.intsBetween(0, 31234).stream().map(Object::toString).collect(Collectors.toList()), (Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"A", (Object)"B", (Object)"C")), (int)31234))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TestSelectiveOrcReader.stringBetween(true, "16", "10"), (Object)1, (Object)TestSelectiveOrcReader.stringBetween(false, "B", "A"))}));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)"a"), Collections.nCopies(9999, "123"), (Iterable)ImmutableList.of((Object)"b"), Collections.nCopies(9999, "123"))));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Collections.nCopies(31234, ""), TestSelectiveOrcReader.stringEquals(false, ""));
        ArrayList values = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat((Iterable[])new Iterable[]{ImmutableList.of((Object)1), Collections.nCopies(9999, 123), ImmutableList.of((Object)2), Collections.nCopies(9999, 123), ImmutableList.of((Object)3), Collections.nCopies(9999, 123), Collections.nCopies(1000000, null)})), (int)200000));
        this.tester.assertRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)values).stream().map(value -> value == null ? null : String.valueOf(value)).collect(Collectors.toList()));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)200000)).stream().map(Object::toString).collect(Collectors.toList()));
        Function<Integer, String> randomStrings = i -> String.valueOf(random.nextInt(31234));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> random.nextInt(31234)), (Object)Lists.newArrayList(TestSelectiveOrcReader.createList(31234, randomStrings))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.BigintRange.of((long)10000L, (long)15000L, (boolean)true))}));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Object[])new String[]{"", null}), TestSelectiveOrcReader.toSubfieldFilters(TestSelectiveOrcReader.stringNotEquals(true, "")));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Object[])new String[]{"", ""}), TestSelectiveOrcReader.toSubfieldFilters(TestSelectiveOrcReader.stringLessThan(true, "")));
    }

    @Test
    public void testChars() throws Exception {
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)CharType.createCharType((long)5L)), (List<List<?>>)ImmutableList.of((Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"123456789", (Object)"23456789", (Object)"3456789")), (int)31234)), (Object)Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"12345", (Object)"23456", (Object)"34567")), (int)31234))), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TupleDomainFilter.IS_NOT_NULL)}));
        this.tester.testRoundTrip((Type)CharType.createCharType((long)2L), Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"aa", (Object)"bb", (Object)"cc", (Object)"dd")), (int)31234)), TupleDomainFilter.IS_NULL);
        this.tester.testRoundTrip((Type)CharType.createCharType((long)1L), Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d")), (int)31234)), TestSelectiveOrcReader.stringIn(false, "a", "b"), TestSelectiveOrcReader.stringIn(true, "a", "b"));
        this.tester.testRoundTrip((Type)CHAR_10, TestSelectiveOrcReader.intsBetween(0, 31234).stream().map(i -> TestSelectiveOrcReader.toCharValue(i, 10)).collect(Collectors.toList()));
        this.tester.testRoundTrip((Type)CHAR_10, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234)).stream().map(i -> TestSelectiveOrcReader.toCharValue(i, 10)).collect(Collectors.toList()), TestSelectiveOrcReader.stringIn(true, TestSelectiveOrcReader.toCharValue(1, 10), TestSelectiveOrcReader.toCharValue(3, 10)));
        this.tester.testRoundTrip((Type)CHAR_10, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{TestSelectiveOrcReader.toCharValue("", 10)}), (int)31234)));
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)"a"), Collections.nCopies(9999, "123"), (Iterable)ImmutableList.of((Object)"b"), Collections.nCopies(9999, "123"))), TestSelectiveOrcReader.stringIn(false, "a", "b"));
    }

    @Test
    public void testVarBinaries() throws Exception {
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, TestSelectiveOrcReader.createList(31234, i -> new SqlVarbinary(String.valueOf(i).getBytes(StandardCharsets.UTF_8))), TestSelectiveOrcReader.stringIn(false, "10", "11"));
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY), (List<List<?>>)ImmutableList.of(TestSelectiveOrcReader.createList(31234, i -> new SqlVarbinary(Ints.toByteArray((int)i))), Streams.stream((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"A", (Object)"B", (Object)"C")), (int)31234)).map(String::getBytes).map(SqlVarbinary::new).collect(ImmutableList.toImmutableList())), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)TestSelectiveOrcReader.stringBetween(true, "10", "16"), (Object)1, (Object)TestSelectiveOrcReader.stringBetween(false, "A", "B"))}));
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, TestSelectiveOrcReader.createList(31234, i -> new SqlVarbinary(String.valueOf(i).getBytes(StandardCharsets.UTF_8))), new TupleDomainFilter[]{TestSelectiveOrcReader.bytesBetween(false, new byte[]{8}, new byte[]{9})});
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, Collections.nCopies(31234, new SqlVarbinary(new byte[0])), new TupleDomainFilter[]{TestSelectiveOrcReader.bytesBetween(false, new byte[0], new byte[]{1})});
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, (List)ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234)).stream().map(String::valueOf).map(string -> string.getBytes(StandardCharsets.UTF_8)).map(SqlVarbinary::new).collect(ImmutableList.toImmutableList()), new TupleDomainFilter[]{TestSelectiveOrcReader.bytesBetween(false, new byte[]{1}, new byte[]{12})});
    }

    @Test
    public void testMemoryTracking() throws Exception {
        this.testMemoryTracking(CompressionKind.NONE, 150000L, 170000L);
        this.testMemoryTracking(CompressionKind.ZSTD, 150000L, 170000L);
        this.testMemoryTracking(CompressionKind.ZLIB, 220000L, 240000L);
    }

    private void testMemoryTracking(CompressionKind compression, long lowerRetainedMemoryBound, long upperRetainedMemoryBound) throws Exception {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        TempFile tempFile = new TempFile();
        ArrayList intValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat((Iterable[])new Iterable[]{ImmutableList.of((Object)1), Collections.nCopies(9999, 123), ImmutableList.of((Object)2), Collections.nCopies(9999, 123), ImmutableList.of((Object)3), Collections.nCopies(9999, 123), Collections.nCopies(1000000, null)})), (int)31234));
        ArrayList varcharDirectValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"A", (Object)"B", (Object)"C")), (int)31234));
        ArrayList varcharDictionaryValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"apple", (Object)"apple pie", (Object)"apple\ud835\udc03", (Object)"apple\ufffd")), (int)31234));
        ImmutableList values = ImmutableList.of((Object)intValues, (Object)varcharDirectValues, (Object)varcharDictionaryValues);
        OrcTester.writeOrcColumnsPresto(tempFile.getFile(), OrcTester.Format.DWRF, compression, Optional.empty(), (List<Type>)types, values, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        OrcPredicate orcPredicate = TestingOrcPredicate.createOrcPredicate((List<Type>)types, values, OrcTester.Format.DWRF, false);
        Map includedColumns = (Map)IntStream.range(0, types.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), ((List)types)::get));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestingHiveOrcAggregatedMemoryContext systemMemoryUsage = new TestingHiveOrcAggregatedMemoryContext();
        try (OrcSelectiveRecordReader recordReader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile.getFile(), OrcTester.Format.DWRF.getOrcEncoding(), orcPredicate, (List<Type>)types, 1024, (Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of(), OrcTester.OrcReaderSettings.builder().build().getFilterFunctions(), OrcTester.OrcReaderSettings.builder().build().getFilterFunctionInputMapping(), OrcTester.OrcReaderSettings.builder().build().getRequiredSubfields(), (Map<Integer, Object>)ImmutableMap.of(), (Map<Integer, Slice>)ImmutableMap.of(), includedColumns, outputColumns, false, systemMemoryUsage, false);){
            Page page;
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)0L);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)0L);
            int rowsProcessed = 0;
            while ((page = recordReader.getNextPage()) != null) {
                int positionCount = page.getPositionCount();
                if (positionCount == 0) continue;
                page.getLoadedPage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(systemMemoryUsage.getBytes()), (Comparable)Long.valueOf(lowerRetainedMemoryBound), (Comparable)Long.valueOf(upperRetainedMemoryBound));
                rowsProcessed += positionCount;
            }
            Assert.assertEquals((int)rowsProcessed, (int)31234);
        }
    }

    @Test
    public void testOutputNotRequired() throws Exception {
        ArrayList inputValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"A", (Object)"B", (Object)"C")), (int)31234));
        ImmutableMap filters = ImmutableMap.of((Object)new Subfield("c"), (Object)TestSelectiveOrcReader.stringIn(true, "A", "B", "C"));
        this.verifyOutputNotRequired(inputValues, (Map<Subfield, TupleDomainFilter>)filters, inputValues);
    }

    @Test
    public void testOutputNotRequiredNonNullFilterNulls() throws Exception {
        ArrayList inputValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("A", null)), (int)31234));
        ArrayList expectedValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("A")), (int)15617));
        ImmutableMap filters = ImmutableMap.of((Object)new Subfield("c"), (Object)TupleDomainFilter.IS_NOT_NULL);
        this.verifyOutputNotRequired(inputValues, (Map<Subfield, TupleDomainFilter>)filters, expectedValues);
    }

    @Test
    public void testOutputNotRequiredNonNullFilterNoNulls() throws Exception {
        ArrayList inputValues = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("A", "B", "C")), (int)31234));
        ImmutableMap filters = ImmutableMap.of((Object)new Subfield("c"), (Object)TupleDomainFilter.IS_NOT_NULL);
        this.verifyOutputNotRequired(inputValues, (Map<Subfield, TupleDomainFilter>)filters, inputValues);
    }

    private void verifyOutputNotRequired(List<String> inputValues, Map<Subfield, TupleDomainFilter> filters, List<String> expectedValues) throws Exception {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        TempFile tempFile = new TempFile();
        ImmutableList values = ImmutableList.of(inputValues, inputValues);
        OrcTester.writeOrcColumnsPresto(tempFile.getFile(), OrcTester.Format.DWRF, CompressionKind.NONE, Optional.empty(), (List<Type>)types, values, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        OrcPredicate orcPredicate = TestingOrcPredicate.createOrcPredicate((List<Type>)types, values, OrcTester.Format.DWRF, false);
        Map includedColumns = (Map)IntStream.range(0, types.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), ((List)types)::get));
        ImmutableList outputColumns = ImmutableList.of((Object)1);
        try (OrcSelectiveRecordReader recordReader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile.getFile(), OrcTester.Format.DWRF.getOrcEncoding(), orcPredicate, (List<Type>)types, 1024, (Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of((Object)0, filters), OrcTester.OrcReaderSettings.builder().build().getFilterFunctions(), OrcTester.OrcReaderSettings.builder().build().getFilterFunctionInputMapping(), OrcTester.OrcReaderSettings.builder().build().getRequiredSubfields(), (Map<Integer, Object>)ImmutableMap.of(), (Map<Integer, Slice>)ImmutableMap.of(), includedColumns, (List<Integer>)outputColumns, false, new TestingHiveOrcAggregatedMemoryContext(), false);){
            Page page;
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)0L);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)0L);
            int rowsProcessed = 0;
            while ((page = recordReader.getNextPage()) != null) {
                int positionCount = page.getPositionCount();
                if (positionCount == 0) continue;
                page.getLoadedPage();
                TestSelectiveOrcReader.assertBlockPositions(page.getBlock(0), expectedValues.subList(rowsProcessed, rowsProcessed + positionCount));
                rowsProcessed += positionCount;
            }
            Assert.assertEquals((int)rowsProcessed, (int)expectedValues.size());
        }
    }

    @Test
    public void testAdaptiveBatchSizes() throws Exception {
        VarcharType type = VarcharType.VARCHAR;
        ImmutableList types = ImmutableList.of((Object)type);
        TempFile tempFile = new TempFile();
        ArrayList<String> values = new ArrayList<String>();
        int rowCount = 10000;
        int longStringLength = 5000;
        Random random = new Random();
        for (int i = 0; i < rowCount; ++i) {
            if (i < 1024) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < longStringLength; ++j) {
                    builder.append(random.nextInt(10));
                }
                values.add(builder.toString());
                continue;
            }
            values.add("");
        }
        OrcTester.writeOrcColumnsPresto(tempFile.getFile(), OrcTester.Format.DWRF, CompressionKind.NONE, Optional.empty(), (List<Type>)types, ImmutableList.of(values), (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        try (OrcSelectiveRecordReader recordReader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, OrcEncoding.DWRF, OrcPredicate.TRUE, (Type)type, 1024, false, false);){
            Assert.assertEquals((long)recordReader.getFileRowCount(), (long)rowCount);
            Assert.assertEquals((long)recordReader.getReaderRowCount(), (long)rowCount);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)0L);
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)0L);
            Page page = recordReader.getNextPage();
            Assert.assertNotNull((Object)page);
            page = page.getLoadedPage();
            Assert.assertEquals((int)page.getPositionCount(), (int)1024);
            while (true) {
                page = recordReader.getNextPage();
                Assert.assertNotNull((Object)page);
                page = page.getLoadedPage();
                if (recordReader.getReadPositions() < (long)rowCount) {
                    Assert.assertEquals((long)page.getPositionCount(), (long)(OrcTester.MAX_BLOCK_SIZE.toBytes() / (long)(longStringLength + 4 + 1)));
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testHiddenConstantColumns() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        ImmutableList values = ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L));
        TempFile tempFile = new TempFile();
        OrcTester.writeOrcColumnsPresto(tempFile.getFile(), OrcTester.Format.DWRF, CompressionKind.ZSTD, Optional.empty(), (List<Type>)types, values, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        int hiddenColumnIndex = -13;
        ImmutableMap includedColumns = ImmutableMap.of((Object)hiddenColumnIndex, (Object)VarcharType.VARCHAR, (Object)0, (Object)BigintType.BIGINT);
        ImmutableList outputColumns = ImmutableList.of((Object)hiddenColumnIndex, (Object)0);
        Slice constantSlice = Slices.utf8Slice((String)"partition_value");
        ImmutableMap constantValues = ImmutableMap.of((Object)hiddenColumnIndex, (Object)constantSlice);
        TestingHiveOrcAggregatedMemoryContext systemMemoryUsage = new TestingHiveOrcAggregatedMemoryContext();
        TupleDomainFilter.BigintRange filter = TupleDomainFilter.BigintRange.of((long)1L, (long)1L, (boolean)false);
        Map<Subfield, TupleDomainFilter> subFieldFilter = TestSelectiveOrcReader.toSubfieldFilter((TupleDomainFilter)filter);
        OrcTester.OrcReaderSettings readerSettings = OrcTester.OrcReaderSettings.builder().setColumnFilters((Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of((Object)0, subFieldFilter)).build();
        try (OrcSelectiveRecordReader recordReader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile.getFile(), OrcTester.Format.DWRF.getOrcEncoding(), OrcPredicate.TRUE, (List<Type>)types, 1, readerSettings.getColumnFilters(), readerSettings.getFilterFunctions(), readerSettings.getFilterFunctionInputMapping(), readerSettings.getRequiredSubfields(), (Map<Integer, Object>)constantValues, (Map<Integer, Slice>)ImmutableMap.of(), (Map<Integer, Type>)includedColumns, (List<Integer>)outputColumns, false, systemMemoryUsage, false);){
            Page page = recordReader.getNextPage();
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Block partitionValueBlock = page.getBlock(0);
            int length = partitionValueBlock.getSliceLength(0);
            Slice varcharSlice = partitionValueBlock.getSlice(0, 0, length);
            Assert.assertEquals((Object)varcharSlice, (Object)constantSlice);
            Block bigintBlock = page.getBlock(1);
            Assert.assertEquals((long)bigintBlock.getLong(0), (long)1L);
            Assert.assertNull((Object)recordReader.getNextPage());
        }
    }

    private void testRoundTripNumeric(Iterable<? extends Number> values, TupleDomainFilter filter) throws Exception {
        List longValues = ImmutableList.copyOf(values).stream().map(Number::longValue).collect(Collectors.toList());
        List intValues = longValues.stream().map(Long::intValue).collect(Collectors.toList());
        List shortValues = longValues.stream().map(Long::shortValue).collect(Collectors.toList());
        List dateValues = longValues.stream().map(Long::intValue).map(SqlDate::new).collect(Collectors.toList());
        List timestamps = longValues.stream().map(timestamp -> DateTimeTestingUtils.sqlTimestampOf((long)(timestamp & Integer.MAX_VALUE), (ConnectorSession)TestingConnectorSession.SESSION)).collect(Collectors.toList());
        this.tester.testRoundTrip((Type)BigintType.BIGINT, longValues, TestSelectiveOrcReader.toSubfieldFilters(filter));
        this.tester.testRoundTrip((Type)IntegerType.INTEGER, intValues, TestSelectiveOrcReader.toSubfieldFilters(filter));
        this.tester.testRoundTrip((Type)SmallintType.SMALLINT, shortValues, TestSelectiveOrcReader.toSubfieldFilters(filter));
        this.tester.testRoundTrip((Type)DateType.DATE, dateValues, TestSelectiveOrcReader.toSubfieldFilters(filter));
        this.tester.testRoundTrip((Type)TimestampType.TIMESTAMP, timestamps, TestSelectiveOrcReader.toSubfieldFilters(filter));
        ArrayList reversedIntValues = new ArrayList(intValues);
        Collections.reverse(reversedIntValues);
        ArrayList reversedDateValues = new ArrayList(dateValues);
        Collections.reverse(reversedDateValues);
        ArrayList reversedTimestampValues = new ArrayList(timestamps);
        Collections.reverse(reversedTimestampValues);
        this.tester.testRoundTripTypes((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)DateType.DATE, (Object)TimestampType.TIMESTAMP), (List<List<?>>)ImmutableList.of(longValues, reversedIntValues, shortValues, reversedDateValues, reversedTimestampValues), TestSelectiveOrcReader.toSubfieldFilters(new Map[]{ImmutableMap.of((Object)0, (Object)filter), ImmutableMap.of((Object)1, (Object)filter), ImmutableMap.of((Object)0, (Object)filter, (Object)1, (Object)filter), ImmutableMap.of((Object)0, (Object)filter, (Object)1, (Object)filter, (Object)2, (Object)filter)}));
    }

    private static TupleDomainFilter stringBetween(boolean nullAllowed, String upper, String lower) {
        return TupleDomainFilter.BytesRange.of((byte[])lower.getBytes(), (boolean)false, (byte[])upper.getBytes(), (boolean)false, (boolean)nullAllowed);
    }

    private static TupleDomainFilter stringLessThan(boolean nullAllowed, String upper) {
        return TupleDomainFilter.BytesRange.of(null, (boolean)true, (byte[])upper.getBytes(), (boolean)true, (boolean)nullAllowed);
    }

    private static TupleDomainFilter stringEquals(boolean nullAllowed, String value) {
        return TupleDomainFilter.BytesRange.of((byte[])value.getBytes(), (boolean)false, (byte[])value.getBytes(), (boolean)false, (boolean)nullAllowed);
    }

    private static TupleDomainFilter stringNotEquals(boolean nullAllowed, String value) {
        return TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.BytesRange.of(null, (boolean)false, (byte[])value.getBytes(), (boolean)true, (boolean)nullAllowed), (Object)TupleDomainFilter.BytesRange.of((byte[])value.getBytes(), (boolean)true, null, (boolean)false, (boolean)nullAllowed)), (boolean)nullAllowed, (boolean)false);
    }

    private static TupleDomainFilter stringIn(boolean nullAllowed, String ... values) {
        return TupleDomainFilter.BytesValues.of((byte[][])((byte[][])Arrays.stream(values).map(String::getBytes).toArray(x$0 -> new byte[x$0][])), (boolean)nullAllowed);
    }

    private static ContiguousSet<Integer> intsBetween(int lowerInclusive, int upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(lowerInclusive), (Comparable)Integer.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.integers());
    }

    private static TupleDomainFilter.BytesRange bytesBetween(boolean nullAllowed, byte[] lower, byte[] upper) {
        return TupleDomainFilter.BytesRange.of((byte[])lower, (boolean)false, (byte[])upper, (boolean)false, (boolean)nullAllowed);
    }

    private static <T> Iterable<T> skipEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                while (this.delegate.hasNext()) {
                    Object next = this.delegate.next();
                    ++this.position;
                    if (this.position <= n) {
                        return next;
                    }
                    this.position = 0;
                }
                return this.endOfData();
            }
        };
    }

    private static <T> Iterable<T> repeatEach(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            private Object value;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                if (this.position == 0) {
                    if (!this.delegate.hasNext()) {
                        return this.endOfData();
                    }
                    this.value = this.delegate.next();
                }
                ++this.position;
                if (this.position >= n) {
                    this.position = 0;
                }
                return this.value;
            }
        };
    }

    private static String toCharValue(Object value, int minLength) {
        return Strings.padEnd((String)value.toString(), (int)minLength, (char)' ');
    }

    private static List<Double> doubleSequence(double start, double step, int items) {
        return (List)IntStream.range(0, items).mapToDouble(i -> start + (double)i * step).boxed().collect(ImmutableList.toImmutableList());
    }

    private static Map<Subfield, TupleDomainFilter> toSubfieldFilter(String subfield, TupleDomainFilter filter) {
        return ImmutableMap.of((Object)new Subfield(subfield), (Object)filter);
    }

    private static Map<Subfield, TupleDomainFilter> toSubfieldFilter(TupleDomainFilter filter) {
        return ImmutableMap.of((Object)new Subfield("c"), (Object)filter);
    }

    private static List<Map<Subfield, TupleDomainFilter>> toSubfieldFilters(TupleDomainFilter ... filters) {
        return (List)Arrays.stream(filters).map(TestSelectiveOrcReader::toSubfieldFilter).collect(ImmutableList.toImmutableList());
    }

    private static List<Map<Integer, Map<Subfield, TupleDomainFilter>>> toSubfieldFilters(Map<Integer, TupleDomainFilter> ... filters) {
        return (List)Arrays.stream(filters).map(columnFilters -> Maps.transformValues((Map)columnFilters, TestSelectiveOrcReader::toSubfieldFilter)).collect(ImmutableList.toImmutableList());
    }

    private static List<Integer> randomIntegers(int size, Random random) {
        return TestSelectiveOrcReader.createList(size, i -> random.nextInt());
    }

    private static List<String> randomStrings(int size, Random random) {
        return TestSelectiveOrcReader.createList(size, i -> TestSelectiveOrcReader.generateRandomStringWithLength(random, 10));
    }

    private static List<String> randomStringsWithNulls(int size, Random random) {
        return TestSelectiveOrcReader.createList(size, i -> i % 2 == 0 ? null : TestSelectiveOrcReader.generateRandomStringWithLength(random, 10));
    }

    private static String generateRandomStringWithLength(Random random, int length) {
        byte[] array = new byte[length];
        random.nextBytes(array);
        return new String(array, StandardCharsets.UTF_8);
    }

    private static List<SqlDecimal> decimalSequence(String start, String step, int items, int precision, int scale) {
        BigInteger decimalStep = new BigInteger(step);
        ArrayList<SqlDecimal> values = new ArrayList<SqlDecimal>();
        BigInteger nextValue = new BigInteger(start);
        for (int i = 0; i < items; ++i) {
            values.add(new SqlDecimal(nextValue, precision, scale));
            nextValue = nextValue.add(decimalStep);
        }
        return values;
    }

    private static List<Long> varintScaleSequence(int rows) {
        ArrayList<Long> values = new ArrayList<Long>();
        long[] numbers = new long[]{1L, 256L, 8192L, 0x100000L, 0x8000000L, 0x400000000L, 0x10000000000L, 0x800000000000L, 0x20000000000000L, 0x1000000000000000L, Long.MIN_VALUE};
        for (int i = 0; i < rows; ++i) {
            values.add(numbers[i % numbers.length] + (long)i);
            values.add(-numbers[i % numbers.length] + (long)i);
        }
        return values;
    }

    private static List<Byte> toByteArray(List<Integer> integers) {
        return integers.stream().map(i -> i == null ? null : Byte.valueOf(i.byteValue())).collect(Collectors.toList());
    }

    private static <T> void assertBlockPositions(Block block, List<String> expectedValues) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.size());
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (expectedValues.get(position) == null) {
                Assert.assertTrue((boolean)block.isNull(position));
                continue;
            }
            Assert.assertEquals((Object)block.getSlice(position, 0, block.getSliceLength(position)), (Object)Slices.wrappedBuffer((byte[])expectedValues.get(position).getBytes()));
        }
    }
}

