/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingOrcDataSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.DwrfMetadataReader;
import com.facebook.presto.orc.metadata.DwrfStripeCacheData;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.AbstractMessageLite;
import com.facebook.presto.orc.protobuf.InvalidProtocolBufferException;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestStorageOrcFileTailSource {
    private static final DataSize DEFAULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final int FOOTER_READ_SIZE_IN_BYTES = (int)DEFAULT_SIZE.toBytes();
    private final OrcReaderOptions orcReaderOptions = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).build();
    private TempFile file;
    private MetadataReader metadataReader;

    @BeforeMethod
    public void setUp() throws Exception {
        this.file = new TempFile();
        this.metadataReader = new DwrfMetadataReader(new RuntimeStats(), this.orcReaderOptions);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.file.close();
    }

    @Test
    public void testReadExpectedFooterSize() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file.getFile());
        out.write(new byte[100000]);
        DwrfProto.PostScript.Builder postScript = DwrfProto.PostScript.newBuilder().setFooterLength(0L).setCompression(DwrfProto.CompressionKind.NONE);
        this.writeTail(postScript, out);
        out.close();
        int expectedFooterSizeInBytes = 567;
        StorageOrcFileTailSource src = new StorageOrcFileTailSource(expectedFooterSizeInBytes, false);
        TestingOrcDataSource orcDataSource = new TestingOrcDataSource(this.createFileOrcDataSource());
        src.getOrcFileTail((OrcDataSource)orcDataSource, this.metadataReader, Optional.empty(), false);
        Assert.assertEquals((int)orcDataSource.getReadCount(), (int)1);
        DiskRange lastReadRange = orcDataSource.getLastReadRanges().get(0);
        Assert.assertEquals((int)lastReadRange.getLength(), (int)expectedFooterSizeInBytes);
    }

    @Test
    public void testSkipDwrfStripeCacheIfDisabled() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file.getFile());
        out.write(new byte[100000]);
        DwrfProto.Footer.Builder footer = DwrfProto.Footer.newBuilder().addAllStripeCacheOffsets((Iterable)ImmutableList.of((Object)0, (Object)256, (Object)512));
        DwrfProto.PostScript.Builder postScript = DwrfProto.PostScript.newBuilder().setCompression(DwrfProto.CompressionKind.NONE).setCacheMode(DwrfProto.StripeCacheMode.BOTH).setCacheSize(512);
        this.writeTail(footer, postScript, out);
        out.close();
        int tailReadSizeInBytes = 256;
        StorageOrcFileTailSource src = new StorageOrcFileTailSource(tailReadSizeInBytes, false);
        TestingOrcDataSource orcDataSource = new TestingOrcDataSource(this.createFileOrcDataSource());
        OrcFileTail orcFileTail = src.getOrcFileTail((OrcDataSource)orcDataSource, this.metadataReader, Optional.empty(), false);
        Assert.assertEquals((int)orcFileTail.getMetadataSize(), (int)0);
        DwrfProto.Footer actualFooter = this.readFooter(orcFileTail);
        Assert.assertEquals((Object)actualFooter, (Object)footer.build());
        Assert.assertFalse((boolean)orcFileTail.getDwrfStripeCacheData().isPresent());
        Assert.assertEquals((int)orcDataSource.getReadCount(), (int)1);
        DiskRange lastReadRange = orcDataSource.getLastReadRanges().get(0);
        Assert.assertEquals((int)lastReadRange.getLength(), (int)tailReadSizeInBytes);
    }

    @Test
    public void testReadDwrfStripeCacheIfEnabled() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file.getFile());
        byte[] stripeCache = new byte[100];
        for (int i = 0; i < stripeCache.length; ++i) {
            stripeCache[i] = (byte)i;
        }
        out.write(stripeCache);
        DwrfProto.Footer.Builder footer = DwrfProto.Footer.newBuilder().addAllStripeCacheOffsets((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)3));
        DwrfProto.PostScript.Builder postScript = DwrfProto.PostScript.newBuilder().setCompression(DwrfProto.CompressionKind.NONE).setCacheMode(DwrfProto.StripeCacheMode.BOTH).setCacheSize(stripeCache.length);
        this.writeTail(footer, postScript, out);
        out.close();
        StorageOrcFileTailSource src = new StorageOrcFileTailSource(FOOTER_READ_SIZE_IN_BYTES, true);
        OrcDataSource orcDataSource = this.createFileOrcDataSource();
        OrcFileTail orcFileTail = src.getOrcFileTail(orcDataSource, this.metadataReader, Optional.empty(), false);
        Assert.assertEquals((int)orcFileTail.getMetadataSize(), (int)0);
        DwrfProto.Footer actualFooter = this.readFooter(orcFileTail);
        Assert.assertEquals((Object)actualFooter, (Object)footer.build());
        Assert.assertTrue((boolean)orcFileTail.getDwrfStripeCacheData().isPresent());
        DwrfStripeCacheData dwrfStripeCacheData = (DwrfStripeCacheData)orcFileTail.getDwrfStripeCacheData().get();
        Assert.assertEquals((Object)dwrfStripeCacheData.getDwrfStripeCacheMode(), (Object)DwrfStripeCacheMode.INDEX_AND_FOOTER);
        Assert.assertEquals((int)dwrfStripeCacheData.getDwrfStripeCacheSize(), (int)stripeCache.length);
        Assert.assertEquals((byte[])dwrfStripeCacheData.getDwrfStripeCacheSlice().getBytes(), (byte[])stripeCache);
    }

    @Test
    public void testReadDwrfStripeCacheIfEnabledButAbsent() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file.getFile());
        DwrfProto.Footer.Builder footer = DwrfProto.Footer.newBuilder();
        DwrfProto.PostScript.Builder postScript = DwrfProto.PostScript.newBuilder().setCompression(DwrfProto.CompressionKind.NONE);
        this.writeTail(footer, postScript, out);
        out.close();
        StorageOrcFileTailSource src = new StorageOrcFileTailSource(FOOTER_READ_SIZE_IN_BYTES, true);
        OrcDataSource orcDataSource = this.createFileOrcDataSource();
        OrcFileTail orcFileTail = src.getOrcFileTail(orcDataSource, this.metadataReader, Optional.empty(), false);
        Assert.assertEquals((int)orcFileTail.getMetadataSize(), (int)0);
        DwrfProto.Footer actualFooter = this.readFooter(orcFileTail);
        Assert.assertEquals((Object)actualFooter, (Object)footer.build());
        Assert.assertFalse((boolean)orcFileTail.getDwrfStripeCacheData().isPresent());
    }

    private OrcDataSource createFileOrcDataSource() throws FileNotFoundException {
        return new FileOrcDataSource(this.file.getFile(), DEFAULT_SIZE, DEFAULT_SIZE, DEFAULT_SIZE, false);
    }

    private int writeTail(DwrfProto.Footer.Builder footer, DwrfProto.PostScript.Builder postScript, OutputStream out) throws IOException {
        int footerSize = this.writeObject((AbstractMessageLite)footer.build(), out);
        postScript.setFooterLength((long)footerSize);
        int postScriptSize = this.writeTail(postScript, out);
        return footerSize + postScriptSize;
    }

    private int writeTail(DwrfProto.PostScript.Builder postScript, OutputStream out) throws IOException {
        int postScriptSize = this.writeObject((AbstractMessageLite)postScript.build(), out);
        out.write(postScriptSize & 0xFF);
        return postScriptSize + 1;
    }

    private int writeObject(AbstractMessageLite msg, OutputStream out) throws IOException {
        byte[] bytes = msg.toByteArray();
        out.write(bytes);
        return bytes.length;
    }

    private DwrfProto.Footer readFooter(OrcFileTail orcFileTail) throws InvalidProtocolBufferException {
        return DwrfProto.Footer.parseFrom((byte[])orcFileTail.getFooterSlice().getBytes(0, orcFileTail.getFooterSize()));
    }
}

