/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.NoopOrcDataSource;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StreamDescriptorFactory;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStreamDescriptorFactory {
    private static final OrcDataSource DUMMY_ORC_DATA_SOURCE = new NoopOrcDataSource();

    private static void verifyStreamDescriptor(StreamDescriptor streamDescriptor, int expectedStreamId, int expectedSequence, Map<Integer, StreamDescriptorFactory.StreamProperty> streamPropertyMap) {
        Assert.assertEquals((int)streamDescriptor.getStreamId(), (int)expectedStreamId, (String)"streamId");
        Assert.assertEquals((int)streamDescriptor.getSequence(), (int)expectedSequence, (String)"sequence");
        Assert.assertEquals((Object)streamDescriptor.getOrcDataSource(), (Object)DUMMY_ORC_DATA_SOURCE, (String)"sequence");
        StreamDescriptorFactory.StreamProperty streamProperty = streamPropertyMap.get(expectedStreamId);
        Assert.assertEquals((String)streamDescriptor.getStreamName(), (String)streamProperty.getStreamName(), (String)"stream name");
        Assert.assertEquals((String)streamDescriptor.getFieldName(), (String)streamProperty.getFieldName(), (String)"field name");
        Assert.assertEquals((Object)streamDescriptor.getOrcType(), (Object)streamProperty.getOrcType(), (String)"orc type");
        List nestedStreamDescriptors = streamDescriptor.getNestedStreams();
        Assert.assertEquals((int)nestedStreamDescriptors.size(), (int)streamProperty.getNestedStreamIds().size(), (String)("nested streams for stream Id " + expectedStreamId));
        for (int i = 0; i < nestedStreamDescriptors.size(); ++i) {
            TestStreamDescriptorFactory.verifyStreamDescriptor((StreamDescriptor)nestedStreamDescriptors.get(i), (Integer)streamProperty.getNestedStreamIds().get(i), expectedSequence, streamPropertyMap);
        }
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }

    private static List<OrcType> getOrcTypes() {
        RowType.Field inner1 = new RowType.Field(Optional.of("inner1"), (Type)RealType.REAL);
        RowType.Field inner2 = new RowType.Field(Optional.of("inner2"), (Type)VarcharType.VARCHAR);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)inner1, (Object)inner2));
        Type arrayType = OrcTester.arrayType((Type)rowType);
        Type mapType = OrcTester.mapType((Type)BigintType.BIGINT, arrayType);
        RowType.Field column1 = new RowType.Field(Optional.of("column1"), (Type)BigintType.BIGINT);
        RowType.Field column2 = new RowType.Field(Optional.of("column2"), mapType);
        RowType rootType = RowType.from((List)ImmutableList.of((Object)column1, (Object)column2));
        return OrcType.toOrcType((int)0, (Type)rootType);
    }

    @Test
    public void testBuilder() {
        List<OrcType> orcTypes = TestStreamDescriptorFactory.getOrcTypes();
        StreamDescriptor streamDescriptor = StreamDescriptorFactory.createStreamDescriptor(orcTypes, (OrcDataSource)DUMMY_ORC_DATA_SOURCE);
        StreamDescriptorFactory.StreamProperty rootProperty = new StreamDescriptorFactory.StreamProperty("", orcTypes.get(0), "", (List)ImmutableList.of((Object)1, (Object)2));
        StreamDescriptorFactory.StreamProperty column1Property = new StreamDescriptorFactory.StreamProperty(".column1", orcTypes.get(1), "column1", (List)ImmutableList.of());
        StreamDescriptorFactory.StreamProperty column2Property = new StreamDescriptorFactory.StreamProperty(".column2", orcTypes.get(2), "column2", (List)ImmutableList.of((Object)3, (Object)4));
        StreamDescriptorFactory.StreamProperty mapKeyProperty = new StreamDescriptorFactory.StreamProperty(".column2.key", orcTypes.get(3), "key", (List)ImmutableList.of());
        StreamDescriptorFactory.StreamProperty mapValueProperty = new StreamDescriptorFactory.StreamProperty(".column2.value", orcTypes.get(4), "value", (List)ImmutableList.of((Object)5));
        StreamDescriptorFactory.StreamProperty listElementProperty = new StreamDescriptorFactory.StreamProperty(".column2.value.item", orcTypes.get(5), "item", (List)ImmutableList.of((Object)6, (Object)7));
        StreamDescriptorFactory.StreamProperty inner1Property = new StreamDescriptorFactory.StreamProperty(".column2.value.item.inner1", orcTypes.get(6), "inner1", (List)ImmutableList.of());
        StreamDescriptorFactory.StreamProperty inner2Property = new StreamDescriptorFactory.StreamProperty(".column2.value.item.inner2", orcTypes.get(7), "inner2", (List)ImmutableList.of());
        ImmutableMap.Builder streamToPropertyMapBuilder = ImmutableMap.builder();
        streamToPropertyMapBuilder.put((Object)0, (Object)rootProperty);
        streamToPropertyMapBuilder.put((Object)1, (Object)column1Property);
        streamToPropertyMapBuilder.put((Object)2, (Object)column2Property);
        streamToPropertyMapBuilder.put((Object)3, (Object)mapKeyProperty);
        streamToPropertyMapBuilder.put((Object)4, (Object)mapValueProperty);
        streamToPropertyMapBuilder.put((Object)5, (Object)listElementProperty);
        streamToPropertyMapBuilder.put((Object)6, (Object)inner1Property);
        streamToPropertyMapBuilder.put((Object)7, (Object)inner2Property);
        ImmutableMap streamPropertyMap = streamToPropertyMapBuilder.build();
        TestStreamDescriptorFactory.verifyStreamDescriptor(streamDescriptor, 0, 0, (Map<Integer, StreamDescriptorFactory.StreamProperty>)streamPropertyMap);
        StreamDescriptor sequenceStreamDescriptor = streamDescriptor.duplicate(10);
        TestStreamDescriptorFactory.verifyStreamDescriptor(sequenceStreamDescriptor, 0, 10, (Map<Integer, StreamDescriptorFactory.StreamProperty>)streamPropertyMap);
    }

    @Test
    public void testAllStreamsNonExistent() {
        OrcType varcharType = (OrcType)OrcType.toOrcType((int)0, (Type)VarcharType.VARCHAR).get(0);
        StreamDescriptorFactory.StreamProperty streamProperty = new StreamDescriptorFactory.StreamProperty("", varcharType, "", (List)ImmutableList.of((Object)1, (Object)2));
        ImmutableMap streamIdToPropertyMap = ImmutableMap.of((Object)0, (Object)streamProperty);
        StreamDescriptorFactory.AllStreams allStreams = new StreamDescriptorFactory.AllStreams(DUMMY_ORC_DATA_SOURCE, (Map)streamIdToPropertyMap);
        StreamDescriptorFactory.StreamProperty retrieved = allStreams.getStreamProperty(0);
        Assert.assertEquals((Object)retrieved, (Object)streamProperty, (String)"streamProperty");
        Assert.expectThrows(IllegalStateException.class, () -> allStreams.getStreamProperty(1));
    }
}

