/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.CapturingOrcFileIntrospector;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.DwrfStreamOrderingConfig;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.StreamLayout;
import com.facebook.presto.orc.writer.StreamLayoutFactory;
import com.facebook.presto.orc.writer.StreamOrderingLayout;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestStreamLayout {
    private static StreamDataOutput createStream(int nodeId, int seqId, Stream.StreamKind streamKind, int length) {
        Stream stream = new Stream(nodeId, seqId, streamKind, length, true);
        return new StreamDataOutput(Slices.allocate((int)1024), stream);
    }

    private static StreamDataOutput createStream(int nodeId, Stream.StreamKind streamKind, int length) {
        Stream stream = new Stream(nodeId, 0, streamKind, length, true);
        return new StreamDataOutput(Slices.allocate((int)1024), stream);
    }

    private static void verifyStream(Stream stream, int nodeId, Stream.StreamKind streamKind, int length) {
        Assert.assertEquals((int)stream.getColumn(), (int)nodeId);
        Assert.assertEquals((int)stream.getLength(), (int)length);
        Assert.assertEquals((Object)stream.getStreamKind(), (Object)streamKind);
    }

    private static void verifyStream(Stream stream, int nodeId, int seqId, Stream.StreamKind streamKind, int length) {
        Assert.assertEquals((int)stream.getColumn(), (int)nodeId);
        Assert.assertEquals((int)stream.getSequence(), (int)seqId);
        Assert.assertEquals((int)stream.getLength(), (int)length);
        Assert.assertEquals((Object)stream.getStreamKind(), (Object)streamKind);
    }

    @Test
    public void testByStreamSize() {
        int i;
        ArrayList<StreamDataOutput> streams = new ArrayList<StreamDataOutput>();
        int length = 10000;
        for (int i2 = 0; i2 < 10; ++i2) {
            streams.add(TestStreamLayout.createStream(i2, Stream.StreamKind.PRESENT, length - i2));
            streams.add(TestStreamLayout.createStream(i2, Stream.StreamKind.DATA, length - 100 - i2));
        }
        Collections.shuffle(streams);
        new StreamLayout.ByStreamSize().reorder(streams);
        Assert.assertEquals((int)streams.size(), (int)20);
        Iterator iterator = streams.iterator();
        for (i = 9; i >= 0; --i) {
            TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), i, Stream.StreamKind.DATA, length - 100 - i);
        }
        for (i = 9; i >= 0; --i) {
            TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), i, Stream.StreamKind.PRESENT, length - i);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testByColumnSize() {
        ArrayList<StreamDataOutput> streams = new ArrayList<StreamDataOutput>();
        streams.add(TestStreamLayout.createStream(1, Stream.StreamKind.DATA, 1000));
        streams.add(TestStreamLayout.createStream(1, Stream.StreamKind.PRESENT, 10));
        streams.add(TestStreamLayout.createStream(2, Stream.StreamKind.DICTIONARY_DATA, 300));
        streams.add(TestStreamLayout.createStream(2, Stream.StreamKind.PRESENT, 10));
        streams.add(TestStreamLayout.createStream(2, Stream.StreamKind.DATA, 600));
        streams.add(TestStreamLayout.createStream(2, Stream.StreamKind.LENGTH, 100));
        streams.add(TestStreamLayout.createStream(3, Stream.StreamKind.DATA, Integer.MAX_VALUE));
        streams.add(TestStreamLayout.createStream(3, Stream.StreamKind.PRESENT, Integer.MAX_VALUE));
        Collections.shuffle(streams);
        new StreamLayout.ByColumnSize().reorder(streams);
        Iterator iterator = streams.iterator();
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 1, Stream.StreamKind.PRESENT, 10);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 1, Stream.StreamKind.DATA, 1000);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 2, Stream.StreamKind.PRESENT, 10);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 2, Stream.StreamKind.LENGTH, 100);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 2, Stream.StreamKind.DICTIONARY_DATA, 300);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 2, Stream.StreamKind.DATA, 600);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 3, Stream.StreamKind.PRESENT, Integer.MAX_VALUE);
        TestStreamLayout.verifyStream(((StreamDataOutput)iterator.next()).getStream(), 3, Stream.StreamKind.DATA, Integer.MAX_VALUE);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @DataProvider(name="testParams")
    public static Object[][] testParams() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="testParams")
    public void testByStreamSizeStreamOrdering(boolean isEmptyMap) {
        List<StreamDataOutput> streams = TestStreamLayout.createStreams(isEmptyMap);
        StreamLayout.ByStreamSize streamLayout = new StreamLayout.ByStreamSize();
        StreamOrderingLayout streamOrderingLayout = new StreamOrderingLayout(TestStreamLayout.createStreamReorderingInput(), (StreamLayout)streamLayout);
        streamOrderingLayout.reorder(streams, TestStreamLayout.createNodeIdToColumnId(), TestStreamLayout.createColumnEncodings(isEmptyMap));
        Iterator<StreamDataOutput> iterator = streams.iterator();
        if (!isEmptyMap) {
            TestStreamLayout.verifyFlatMapColumns(iterator);
        }
        TestStreamLayout.verifyStream(iterator.next().getStream(), 5, 0, Stream.StreamKind.DATA, 1);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 2, 0, Stream.StreamKind.LENGTH, 2);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 1, 0, Stream.StreamKind.DATA, 3);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 4, 0, Stream.StreamKind.LENGTH, 5);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 3, 0, Stream.StreamKind.DATA, 8);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 1, 0, Stream.StreamKind.PRESENT, 12);
        if (!isEmptyMap) {
            TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 5, Stream.StreamKind.IN_MAP, 13);
            TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 5, Stream.StreamKind.LENGTH, 14);
            TestStreamLayout.verifyStream(iterator.next().getStream(), 12, 5, Stream.StreamKind.DATA, 15);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test(dataProvider="testParams")
    public void testByColumnSizeStreamOrdering(boolean isEmptyMap) {
        List<StreamDataOutput> streams = TestStreamLayout.createStreams(isEmptyMap);
        StreamLayout.ByColumnSize streamLayout = new StreamLayout.ByColumnSize();
        StreamOrderingLayout streamOrderingLayout = new StreamOrderingLayout(TestStreamLayout.createStreamReorderingInput(), (StreamLayout)streamLayout);
        streamOrderingLayout.reorder(streams, TestStreamLayout.createNodeIdToColumnId(), TestStreamLayout.createColumnEncodings(isEmptyMap));
        Iterator<StreamDataOutput> iterator = streams.iterator();
        if (!isEmptyMap) {
            TestStreamLayout.verifyFlatMapColumns(iterator);
        }
        TestStreamLayout.verifyStream(iterator.next().getStream(), 5, 0, Stream.StreamKind.DATA, 1);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 2, 0, Stream.StreamKind.LENGTH, 2);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 4, 0, Stream.StreamKind.LENGTH, 5);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 3, 0, Stream.StreamKind.DATA, 8);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 1, 0, Stream.StreamKind.DATA, 3);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 1, 0, Stream.StreamKind.PRESENT, 12);
        if (!isEmptyMap) {
            TestStreamLayout.verifyStream(iterator.next().getStream(), 12, 5, Stream.StreamKind.DATA, 15);
            TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 5, Stream.StreamKind.IN_MAP, 13);
            TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 5, Stream.StreamKind.LENGTH, 14);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private static Map<Integer, ColumnEncoding> createColumnEncodings(boolean isEmptyMap) {
        ImmutableSortedMap seqIdToEncodings1 = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(100L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)), (Comparable)Integer.valueOf(2), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(200L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)), (Comparable)Integer.valueOf(3), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(300L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)));
        ImmutableSortedMap seqIdToEncodings2 = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(100L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)), (Comparable)Integer.valueOf(2), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(200L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)), (Comparable)Integer.valueOf(3), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(300L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)), (Comparable)Integer.valueOf(4), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(400L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)), (Comparable)Integer.valueOf(5), (Object)new DwrfSequenceEncoding(DwrfProto.KeyInfo.newBuilder().setIntKey(500L).build(), new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)));
        return ImmutableMap.builder().put((Object)1, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)).put((Object)2, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)).put((Object)3, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)).put((Object)4, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)).put((Object)5, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0)).put((Object)6, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT, 0)).put((Object)8, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, isEmptyMap ? Optional.empty() : Optional.of(seqIdToEncodings1))).put((Object)9, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT, 0)).put((Object)11, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, isEmptyMap ? Optional.empty() : Optional.of(seqIdToEncodings2))).put((Object)12, (Object)new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, isEmptyMap ? Optional.empty() : Optional.of(seqIdToEncodings2))).build();
    }

    private static Map<Integer, Integer> createNodeIdToColumnId() {
        return ImmutableMap.builder().put((Object)1, (Object)0).put((Object)2, (Object)1).put((Object)3, (Object)1).put((Object)4, (Object)1).put((Object)5, (Object)1).put((Object)6, (Object)2).put((Object)7, (Object)2).put((Object)8, (Object)2).put((Object)9, (Object)3).put((Object)10, (Object)3).put((Object)11, (Object)3).put((Object)12, (Object)3).build();
    }

    private static DwrfStreamOrderingConfig createStreamReorderingInput() {
        HashMap<Integer, ImmutableList> columnIdToFlatMapKeyIds = new HashMap<Integer, ImmutableList>();
        columnIdToFlatMapKeyIds.put(2, ImmutableList.of((Object)DwrfProto.KeyInfo.newBuilder().setIntKey(300L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(200L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(100L).build()));
        columnIdToFlatMapKeyIds.put(3, ImmutableList.of((Object)DwrfProto.KeyInfo.newBuilder().setIntKey(100L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(200L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(400L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(300L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(600L).build()));
        columnIdToFlatMapKeyIds.put(4, ImmutableList.of((Object)DwrfProto.KeyInfo.newBuilder().setIntKey(100L).build(), (Object)DwrfProto.KeyInfo.newBuilder().setIntKey(200L).build()));
        return new DwrfStreamOrderingConfig(columnIdToFlatMapKeyIds);
    }

    private static void verifyFlatMapColumns(Iterator<StreamDataOutput> iterator) {
        TestStreamLayout.verifyStream(iterator.next().getStream(), 8, 3, Stream.StreamKind.IN_MAP, 6);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 8, 3, Stream.StreamKind.DATA, 7);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 8, 2, Stream.StreamKind.IN_MAP, 4);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 8, 2, Stream.StreamKind.DATA, 5);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 8, 1, Stream.StreamKind.IN_MAP, 2);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 8, 1, Stream.StreamKind.DATA, 3);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 1, Stream.StreamKind.IN_MAP, 1);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 1, Stream.StreamKind.LENGTH, 2);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 12, 1, Stream.StreamKind.DATA, 3);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 2, Stream.StreamKind.IN_MAP, 4);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 2, Stream.StreamKind.LENGTH, 5);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 12, 2, Stream.StreamKind.DATA, 6);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 4, Stream.StreamKind.IN_MAP, 10);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 4, Stream.StreamKind.LENGTH, 11);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 12, 4, Stream.StreamKind.DATA, 12);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 3, Stream.StreamKind.IN_MAP, 7);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 11, 3, Stream.StreamKind.LENGTH, 8);
        TestStreamLayout.verifyStream(iterator.next().getStream(), 12, 3, Stream.StreamKind.DATA, 9);
    }

    private static List<StreamDataOutput> createStreams(boolean isEmptyMap) {
        ArrayList<StreamDataOutput> streams = new ArrayList<StreamDataOutput>();
        streams.add(TestStreamLayout.createStream(1, Stream.StreamKind.DATA, 3));
        streams.add(TestStreamLayout.createStream(1, Stream.StreamKind.PRESENT, 12));
        streams.add(TestStreamLayout.createStream(2, Stream.StreamKind.LENGTH, 2));
        streams.add(TestStreamLayout.createStream(3, Stream.StreamKind.DATA, 8));
        streams.add(TestStreamLayout.createStream(4, Stream.StreamKind.LENGTH, 5));
        streams.add(TestStreamLayout.createStream(5, Stream.StreamKind.DATA, 1));
        if (!isEmptyMap) {
            streams.add(TestStreamLayout.createStream(8, 1, Stream.StreamKind.IN_MAP, 2));
            streams.add(TestStreamLayout.createStream(8, 1, Stream.StreamKind.DATA, 3));
            streams.add(TestStreamLayout.createStream(8, 2, Stream.StreamKind.IN_MAP, 4));
            streams.add(TestStreamLayout.createStream(8, 2, Stream.StreamKind.DATA, 5));
            streams.add(TestStreamLayout.createStream(8, 3, Stream.StreamKind.IN_MAP, 6));
            streams.add(TestStreamLayout.createStream(8, 3, Stream.StreamKind.DATA, 7));
            streams.add(TestStreamLayout.createStream(11, 1, Stream.StreamKind.IN_MAP, 1));
            streams.add(TestStreamLayout.createStream(11, 1, Stream.StreamKind.LENGTH, 2));
            streams.add(TestStreamLayout.createStream(12, 1, Stream.StreamKind.DATA, 3));
            streams.add(TestStreamLayout.createStream(11, 2, Stream.StreamKind.IN_MAP, 4));
            streams.add(TestStreamLayout.createStream(11, 2, Stream.StreamKind.LENGTH, 5));
            streams.add(TestStreamLayout.createStream(12, 2, Stream.StreamKind.DATA, 6));
            streams.add(TestStreamLayout.createStream(11, 3, Stream.StreamKind.IN_MAP, 7));
            streams.add(TestStreamLayout.createStream(11, 3, Stream.StreamKind.LENGTH, 8));
            streams.add(TestStreamLayout.createStream(12, 3, Stream.StreamKind.DATA, 9));
            streams.add(TestStreamLayout.createStream(11, 4, Stream.StreamKind.IN_MAP, 10));
            streams.add(TestStreamLayout.createStream(11, 4, Stream.StreamKind.LENGTH, 11));
            streams.add(TestStreamLayout.createStream(12, 4, Stream.StreamKind.DATA, 12));
            streams.add(TestStreamLayout.createStream(11, 5, Stream.StreamKind.IN_MAP, 13));
            streams.add(TestStreamLayout.createStream(11, 5, Stream.StreamKind.LENGTH, 14));
            streams.add(TestStreamLayout.createStream(12, 5, Stream.StreamKind.DATA, 15));
        }
        return streams;
    }

    @DataProvider
    public static Object[][] streamOrderingLayoutProvider() {
        return new Object[][]{{2L, 0L, 1L}, {new Long[0]}, {0L}, {10L, 20L}, {2L, 10L}};
    }

    @Test(dataProvider="streamOrderingLayoutProvider")
    public void testStreamOrderingLayoutEndToEndPrimitive(Object[] orderedKeys) throws Exception {
        MapType mapType = (MapType)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER);
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 10);
        BlockBuilder mapKeyBuilder = mapBlockBuilder.getKeyBlockBuilder();
        BlockBuilder mapValueBuilder = mapBlockBuilder.getValueBlockBuilder();
        mapBlockBuilder.beginDirectEntry();
        for (int k = 0; k < 3; ++k) {
            IntegerType.INTEGER.writeLong(mapKeyBuilder, (long)k);
            IntegerType.INTEGER.writeLong(mapValueBuilder, (long)k);
        }
        mapBlockBuilder.closeEntry();
        Page page = new Page(new Block[]{mapBlockBuilder.build()});
        StreamLayoutFactory streamLayoutFactory = TestStreamLayout.createLongKeysStreamLayoutFactory(0, orderedKeys);
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlattenedColumns((Set)ImmutableSet.of((Object)0)).withStreamLayoutFactory(streamLayoutFactory).build();
        try (TempFile tempFile = new TempFile();){
            try (OrcWriter orcWriter = OrcTester.createOrcWriter(tempFile.getFile(), OrcEncoding.DWRF, CompressionKind.ZLIB, Optional.empty(), (List<Type>)ImmutableList.of((Object)mapType), writerOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);){
                orcWriter.write(page);
            }
            TestStreamLayout.assertFileStreamsOrder(orderedKeys, mapType, tempFile);
        }
    }

    @Test(dataProvider="streamOrderingLayoutProvider")
    public void testStreamOrderingLayoutEndToEndComplexEmpty(Object[] orderedKeys) throws Exception {
        MapType mapType = (MapType)OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.arrayType((Type)IntegerType.INTEGER));
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 10);
        mapBlockBuilder.beginDirectEntry();
        mapBlockBuilder.closeEntry();
        Page page = new Page(new Block[]{mapBlockBuilder.build()});
        StreamLayoutFactory streamLayoutFactory = TestStreamLayout.createLongKeysStreamLayoutFactory(0, orderedKeys);
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlattenedColumns((Set)ImmutableSet.of((Object)0)).withStreamLayoutFactory(streamLayoutFactory).build();
        try (TempFile tempFile = new TempFile();
             OrcWriter orcWriter = OrcTester.createOrcWriter(tempFile.getFile(), OrcEncoding.DWRF, CompressionKind.ZLIB, Optional.empty(), (List<Type>)ImmutableList.of((Object)mapType), writerOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);){
            orcWriter.write(page);
        }
    }

    private static void assertFileStreamsOrder(Object[] orderedKeys, MapType mapType, TempFile tempFile) throws IOException {
        CapturingOrcFileIntrospector introspector = new CapturingOrcFileIntrospector();
        TestStreamLayout.readFileWithIntrospector((Type)mapType, introspector, tempFile);
        Assert.assertEquals((int)introspector.getStripeFooterByStripeOffset().size(), (int)1);
        StripeFooter stripeFooter = introspector.getStripeFooterByStripeOffset().values().iterator().next();
        List dataStreams = (List)stripeFooter.getStreams().stream().filter(s -> s.getStreamKind() != Stream.StreamKind.ROW_INDEX).collect(ImmutableList.toImmutableList());
        int node = 3;
        ColumnEncoding columnEncoding = (ColumnEncoding)stripeFooter.getColumnEncodings().get(node);
        SortedMap nodeSequences = (SortedMap)columnEncoding.getAdditionalSequenceEncodings().get();
        ImmutableMap.Builder keyToSequenceBuilder = ImmutableMap.builder();
        for (Map.Entry entry : nodeSequences.entrySet()) {
            long key = ((DwrfSequenceEncoding)entry.getValue()).getKey().getIntKey();
            int sequence = (Integer)entry.getKey();
            keyToSequenceBuilder.put((Object)key, (Object)sequence);
        }
        ImmutableMap keyToSequence = keyToSequenceBuilder.build();
        List filteredKeys = (List)Arrays.stream(orderedKeys).map(k -> (Long)k).filter(k -> k >= 0L && k < 3L).collect(ImmutableList.toImmutableList());
        Iterator dataStreamsIterator = dataStreams.iterator();
        for (Long key : filteredKeys) {
            int sequence = (Integer)keyToSequence.get(key);
            Assert.assertEquals((int)((Stream)dataStreamsIterator.next()).getSequence(), (int)sequence);
            Assert.assertEquals((int)((Stream)dataStreamsIterator.next()).getSequence(), (int)sequence);
        }
    }

    private static void readFileWithIntrospector(Type type, CapturingOrcFileIntrospector introspector, TempFile tempFile) throws IOException {
        FileOrcDataSource dataSource = new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReaderOptions readerOptions = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).build();
        OrcReader reader = new OrcReader((OrcDataSource)dataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), Optional.empty(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, readerOptions, false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats(), Optional.of(introspector));
        OrcSelectiveRecordReader recordReader = reader.createSelectiveRecordReader((Map)ImmutableMap.of((Object)0, (Object)type), (List)ImmutableList.of((Object)0), Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), OrcPredicate.TRUE, 0L, dataSource.getSize(), DateTimeZone.UTC, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, Optional.empty(), 1000);
        while (recordReader.getNextPage() != null) {
        }
        recordReader.close();
    }

    private static StreamLayoutFactory createLongKeysStreamLayoutFactory(int column, Object[] orderedKeys) {
        List keyInfos = (List)Arrays.stream(orderedKeys).map(key -> DwrfProto.KeyInfo.newBuilder().setIntKey(((Long)key).longValue()).build()).collect(ImmutableList.toImmutableList());
        ImmutableMap columnToKeys = ImmutableMap.of((Object)column, (Object)keyInfos);
        DwrfStreamOrderingConfig streamOrderingConfig = new DwrfStreamOrderingConfig((Map)columnToKeys);
        StreamLayoutFactory.ColumnSizeLayoutFactory baseStreamLayoutFactory = new StreamLayoutFactory.ColumnSizeLayoutFactory();
        return () -> TestStreamLayout.lambda$createLongKeysStreamLayoutFactory$4(streamOrderingConfig, (StreamLayoutFactory)baseStreamLayoutFactory);
    }

    private static /* synthetic */ StreamLayout lambda$createLongKeysStreamLayoutFactory$4(DwrfStreamOrderingConfig streamOrderingConfig, StreamLayoutFactory baseStreamLayoutFactory) {
        return new StreamOrderingLayout(streamOrderingConfig, baseStreamLayoutFactory.create());
    }
}

