/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStripeReader {
    private static final long MILLION = 1000000L;
    private static final long BILLION = 1000000000L;
    private static final long TEN_BILLION = 10000000000L;

    @Test
    public void testCreateRowGroup() {
        long numRowsInStripe = 10001000000L;
        long rowsInRowGroup = 1000000000L;
        for (int groupId = 0; groupId < 11; ++groupId) {
            RowGroup rowGroup = StripeReader.createRowGroup((int)groupId, (long)numRowsInStripe, (long)rowsInRowGroup, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
            Assert.assertEquals((int)rowGroup.getGroupId(), (int)groupId);
            Assert.assertEquals((long)rowGroup.getRowOffset(), (long)((long)groupId * rowsInRowGroup));
            long expectedRows = groupId < 10 ? 1000000000L : 1000000L;
            Assert.assertEquals((long)rowGroup.getRowCount(), (long)expectedRows);
        }
    }

    @Test(expectedExceptions={ArithmeticException.class})
    public void testRowGroupOverflow() {
        StripeReader.createRowGroup((int)Integer.MAX_VALUE, (long)Long.MAX_VALUE, (long)Long.MAX_VALUE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
    }

    @Test
    public void testRowSize() {
        int numberOfEntries = 10000;
        long numRowsInGroup = 1000000L;
        IntegerStatistics integerStatistics = new IntegerStatistics(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L));
        IntegerColumnStatistics intColumnStatistics = new IntegerColumnStatistics(Long.valueOf(numRowsInGroup), null, integerStatistics);
        ColumnStatistics mapColumnStatistics = new ColumnStatistics(Long.valueOf(numRowsInGroup), null);
        IntegerColumnStatistics mapKeyColumnStatistics = new IntegerColumnStatistics(Long.valueOf(numRowsInGroup * (long)numberOfEntries), null, integerStatistics);
        IntegerColumnStatistics mapValueColumnStatistics = new IntegerColumnStatistics(Long.valueOf(numRowsInGroup * (long)numberOfEntries), null, integerStatistics);
        StreamId intStreamId = new StreamId(1, 0, Stream.StreamKind.ROW_INDEX);
        StreamId mapStreamId = new StreamId(2, 0, Stream.StreamKind.ROW_INDEX);
        StreamId mapKeyStreamId = new StreamId(3, 0, Stream.StreamKind.ROW_INDEX);
        StreamId mapValueStreamId = new StreamId(4, 0, Stream.StreamKind.ROW_INDEX);
        ImmutableMap columnIndexes = ImmutableMap.of((Object)intStreamId, TestStripeReader.createRowGroupIndex((ColumnStatistics)intColumnStatistics), (Object)mapStreamId, TestStripeReader.createRowGroupIndex(mapColumnStatistics), (Object)mapKeyStreamId, TestStripeReader.createRowGroupIndex((ColumnStatistics)mapKeyColumnStatistics), (Object)mapValueStreamId, TestStripeReader.createRowGroupIndex((ColumnStatistics)mapValueColumnStatistics));
        long expectedRowSize = 9L + (long)(2 * numberOfEntries) * 9L;
        RowGroup rowGroup = StripeReader.createRowGroup((int)0, (long)Long.MAX_VALUE, (long)numRowsInGroup, (Map)columnIndexes, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        Assert.assertEquals((long)expectedRowSize, (long)rowGroup.getMinAverageRowBytes());
    }

    private static List<RowGroupIndex> createRowGroupIndex(ColumnStatistics columnStatistics) {
        return ImmutableList.of((Object)new RowGroupIndex(new int[]{0, 0, 0, 0}, columnStatistics));
    }
}

