/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestStructBatchStreamReader {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final Type TEST_DATA_TYPE = VarcharType.VARCHAR;
    private static final String STRUCT_COL_NAME = "struct_col";
    public static final ConnectorSession SESSION = new TestingConnectorSession((List)ImmutableList.of());
    private TempFile tempFile;

    @BeforeMethod
    public void setUp() {
        this.tempFile = new TempFile();
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.tempFile.close();
    }

    @Test
    public void testValuesAreReadInCorrectly() throws IOException {
        ArrayList<String> readerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerData = new ArrayList<String>(Arrays.asList("field_a_value", "field_b_value", "field_c_value"));
        Type readerType = this.getType(readerFields);
        Type writerType = this.getType(writerFields);
        this.write(this.tempFile, writerType, writerData);
        RowBlock readBlock = this.read(this.tempFile, readerType);
        List actual = (List)readerType.getObjectValue(SESSION.getSqlFunctionProperties(), (Block)readBlock, 0);
        Assert.assertEquals((int)actual.size(), (int)readerFields.size());
        Assert.assertEquals(actual.get(0), (Object)"field_a_value");
        Assert.assertEquals(actual.get(1), (Object)"field_b_value");
        Assert.assertEquals(actual.get(2), (Object)"field_c_value");
    }

    @Test
    public void testReaderLowerCasesFieldNamesFromStream() throws IOException {
        ArrayList<String> readerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerFields = new ArrayList<String>(Arrays.asList("field_A", "field_B", "field_C"));
        ArrayList<String> writerData = new ArrayList<String>(Arrays.asList("fieldAValue", "fieldBValue", "fieldCValue"));
        Type readerType = this.getType(readerFields);
        Type writerType = this.getType(writerFields);
        this.write(this.tempFile, writerType, writerData);
        RowBlock readBlock = this.read(this.tempFile, readerType);
        List actual = (List)readerType.getObjectValue(SESSION.getSqlFunctionProperties(), (Block)readBlock, 0);
        Assert.assertEquals((int)actual.size(), (int)readerFields.size());
        Assert.assertEquals(actual.get(0), (Object)"fieldAValue");
        Assert.assertEquals(actual.get(1), (Object)"fieldBValue");
        Assert.assertEquals(actual.get(2), (Object)"fieldCValue");
    }

    @Test
    public void testReaderLowerCasesFieldNamesFromType() throws IOException {
        ArrayList<String> readerFields = new ArrayList<String>(Arrays.asList("field_A", "field_B", "field_C"));
        ArrayList<String> writerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerData = new ArrayList<String>(Arrays.asList("fieldAValue", "fieldBValue", "fieldCValue"));
        Type readerType = this.getType(readerFields);
        Type writerType = this.getType(writerFields);
        this.write(this.tempFile, writerType, writerData);
        RowBlock readBlock = this.read(this.tempFile, readerType);
        List actual = (List)readerType.getObjectValue(SESSION.getSqlFunctionProperties(), (Block)readBlock, 0);
        Assert.assertEquals((int)actual.size(), (int)readerFields.size());
        Assert.assertEquals(actual.get(0), (Object)"fieldAValue");
        Assert.assertEquals(actual.get(1), (Object)"fieldBValue");
        Assert.assertEquals(actual.get(2), (Object)"fieldCValue");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ROW type does not have field names declared: row\\(varchar,varchar,varchar\\)")
    public void testThrowsExceptionWhenFieldNameMissing() throws IOException {
        ArrayList<String> readerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerData = new ArrayList<String>(Arrays.asList("field_a_value", "field_b_value", "field_c_value"));
        Type readerType = this.getTypeNullName(readerFields.size());
        Type writerType = this.getType(writerFields);
        this.write(this.tempFile, writerType, writerData);
        this.read(this.tempFile, readerType);
    }

    @Test
    public void testExtraFieldsInReader() throws IOException {
        ArrayList<String> readerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerFields = new ArrayList<String>(Arrays.asList("field_a", "field_c"));
        ArrayList<String> writerData = new ArrayList<String>(Arrays.asList("field_a_value", "field_c_value"));
        Type readerType = this.getType(readerFields);
        Type writerType = this.getType(writerFields);
        this.write(this.tempFile, writerType, writerData);
        RowBlock readBlock = this.read(this.tempFile, readerType);
        List actual = (List)readerType.getObjectValue(SESSION.getSqlFunctionProperties(), (Block)readBlock, 0);
        Assert.assertEquals((int)actual.size(), (int)readerFields.size());
        Assert.assertEquals(actual.get(0), (Object)"field_a_value");
        Assert.assertNull(actual.get(1));
        Assert.assertEquals(actual.get(2), (Object)"field_c_value");
    }

    @Test
    public void testExtraFieldsInWriter() throws IOException {
        ArrayList<String> readerFields = new ArrayList<String>(Arrays.asList("field_a", "field_c"));
        ArrayList<String> writerFields = new ArrayList<String>(Arrays.asList("field_a", "field_b", "field_c"));
        ArrayList<String> writerData = new ArrayList<String>(Arrays.asList("field_a_value", "field_b_value", "field_c_value"));
        Type readerType = this.getType(readerFields);
        Type writerType = this.getType(writerFields);
        this.write(this.tempFile, writerType, writerData);
        RowBlock readBlock = this.read(this.tempFile, readerType);
        List actual = (List)readerType.getObjectValue(SESSION.getSqlFunctionProperties(), (Block)readBlock, 0);
        Assert.assertEquals((int)actual.size(), (int)readerFields.size());
        Assert.assertEquals(actual.get(0), (Object)"field_a_value");
        Assert.assertEquals(actual.get(1), (Object)"field_c_value");
    }

    private void write(TempFile tempFile, Type writerType, List<String> data) throws IOException {
        OrcWriter writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(tempFile.getFile())), (List)ImmutableList.of((Object)STRUCT_COL_NAME), (List)ImmutableList.of((Object)writerType), OrcEncoding.ORC, CompressionKind.NONE, Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(new DataSize(0.0, DataSize.Unit.MEGABYTE)).withStripeMaxSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).withStripeMaxRowCount(30000).build()).withRowGroupMaxRowCount(10000).withDictionaryMaxMemory(new DataSize(32.0, DataSize.Unit.MEGABYTE)).build(), (Map)ImmutableMap.of(), OrcTester.HIVE_STORAGE_TIME_ZONE, true, OrcWriteValidation.OrcWriteValidationMode.BOTH, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        Block[] fieldBlocks = new Block[data.size()];
        int entries = 10;
        boolean[] rowIsNull = new boolean[entries];
        Arrays.fill(rowIsNull, false);
        BlockBuilder blockBuilder = TEST_DATA_TYPE.createBlockBuilder(null, entries);
        for (int i = 0; i < data.size(); ++i) {
            byte[] bytes = data.get(i).getBytes();
            for (int j = 0; j < entries; ++j) {
                blockBuilder.writeBytes(Slices.wrappedBuffer((byte[])bytes), 0, bytes.length);
                blockBuilder.closeEntry();
            }
            fieldBlocks[i] = blockBuilder.build();
            blockBuilder = blockBuilder.newBlockBuilderLike(null);
        }
        Block rowBlock = RowBlock.fromFieldBlocks((int)rowIsNull.length, Optional.of(rowIsNull), (Block[])fieldBlocks);
        writer.write(new Page(new Block[]{rowBlock}));
        writer.close();
    }

    private RowBlock read(TempFile tempFile, Type readerType) throws IOException {
        DataSize dataSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        FileOrcDataSource orcDataSource = new FileOrcDataSource(tempFile.getFile(), dataSize, dataSize, dataSize, true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(dataSize).withTinyStripeThreshold(dataSize).withMaxBlockSize(dataSize).build(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
        HashMap<Integer, Type> includedColumns = new HashMap<Integer, Type>();
        includedColumns.put(0, readerType);
        OrcBatchRecordReader recordReader = orcReader.createBatchRecordReader(includedColumns, OrcPredicate.TRUE, DateTimeZone.UTC, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), 1);
        recordReader.nextBatch();
        RowBlock block = (RowBlock)recordReader.readBlock(0);
        recordReader.close();
        return block;
    }

    private Type getType(List<String> fieldNames) {
        ImmutableList.Builder typeSignatureParameters = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            typeSignatureParameters.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(fieldName, false)), TEST_DATA_TYPE.getTypeSignature())));
        }
        return FUNCTION_AND_TYPE_MANAGER.getParameterizedType("row", (List)typeSignatureParameters.build());
    }

    private Type getTypeNullName(int numFields) {
        ImmutableList.Builder typeSignatureParameters = ImmutableList.builder();
        for (int i = 0; i < numFields; ++i) {
            typeSignatureParameters.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TEST_DATA_TYPE.getTypeSignature())));
        }
        return FUNCTION_AND_TYPE_MANAGER.getParameterizedType("row", (List)typeSignatureParameters.build());
    }
}

