/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.reader.TimestampOutOfBoundsException;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTimestampWriteAndRead {
    private static final Set<OrcTester.Format> FORMATS = ImmutableSet.of((Object)((Object)OrcTester.Format.DWRF), (Object)((Object)OrcTester.Format.ORC_12), (Object)((Object)OrcTester.Format.ORC_11));
    private static final List<SqlTimestamp> MICROSECOND_VALUES = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)0L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)999999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1000000L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-60000000000000789L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-230000000000999999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1650483250000507L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)60000000000123789L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)230000000000999999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS));
    private static final List<SqlTimestamp> MILLISECOND_VALUES = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)0L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1000L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-60000000000789L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-230000000999999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1650483250507L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)60000000000789L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)230000000000999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS));

    @Test
    public void testMicroWriteAndRead() throws Exception {
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP_MICROSECONDS, MICROSECOND_VALUES, (Type)TimestampType.TIMESTAMP_MICROSECONDS, MICROSECOND_VALUES);
    }

    @Test
    public void testMilliWriteAndRead() throws Exception {
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP, MILLISECOND_VALUES, (Type)TimestampType.TIMESTAMP, MILLISECOND_VALUES);
    }

    @Test
    public void testMicroWriteAndMilliRead() throws Exception {
        List<SqlTimestamp> microSecondValuesInMilli = MICROSECOND_VALUES.stream().map(microTimestamp -> new SqlTimestamp(Math.floorDiv(microTimestamp.getMicrosUtc(), 1000L), (TimeZoneKey)microTimestamp.getSessionTimeZoneKey().get(), TimeUnit.MILLISECONDS)).collect(Collectors.toList());
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP_MICROSECONDS, MICROSECOND_VALUES, (Type)TimestampType.TIMESTAMP, microSecondValuesInMilli);
    }

    @Test
    public void testMilliWriteAndMicroRead() throws Exception {
        List<SqlTimestamp> milliSecondValuesInMicro = this.getMilliTimestampsInMicros(MILLISECOND_VALUES);
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP, MILLISECOND_VALUES, (Type)TimestampType.TIMESTAMP_MICROSECONDS, milliSecondValuesInMicro);
    }

    @Test
    public void testOverflowReadingMicros() throws Exception {
        ImmutableList milliSecondValuesNoOverflow = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)9223372036854000L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-9223372036854000L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS));
        List<SqlTimestamp> valuesInMicroNoOverflow = this.getMilliTimestampsInMicros((List<SqlTimestamp>)milliSecondValuesNoOverflow);
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP, (List<SqlTimestamp>)milliSecondValuesNoOverflow, (Type)TimestampType.TIMESTAMP_MICROSECONDS, valuesInMicroNoOverflow);
        ImmutableList millisecondValuesOverflow = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)9223372036855000L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-9223372036855000L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS));
        List<SqlTimestamp> valuesInMicroOverflow = this.getMilliTimestampsInMicros((List<SqlTimestamp>)millisecondValuesOverflow);
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP, (List<SqlTimestamp>)millisecondValuesOverflow, (Type)TimestampType.TIMESTAMP, (List<SqlTimestamp>)millisecondValuesOverflow);
        Assert.assertThrows(TimestampOutOfBoundsException.class, () -> this.lambda$testOverflowReadingMicros$1((List)millisecondValuesOverflow, valuesInMicroOverflow));
    }

    @Test
    public void testOrcEncodingTimestampFlawMicros() throws Exception {
        ImmutableList timestampsWithFlaw = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)-1L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-999999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS));
        ImmutableList expectedTimestamps = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)999999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MICROSECONDS));
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP_MICROSECONDS, (List<SqlTimestamp>)timestampsWithFlaw, (Type)TimestampType.TIMESTAMP_MICROSECONDS, (List<SqlTimestamp>)expectedTimestamps);
    }

    @Test
    public void testOrcEncodingTimestampFlawMillis() throws Exception {
        ImmutableList timestampsWithFlaw = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)-1L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)-999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS));
        ImmutableList expectedTimestamps = ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((long)999L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS), (Object)DateTimeTestingUtils.sqlTimestampOf((long)1L, (ConnectorSession)TestingConnectorSession.SESSION, (TimeUnit)TimeUnit.MILLISECONDS));
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP, (List<SqlTimestamp>)timestampsWithFlaw, (Type)TimestampType.TIMESTAMP, (List<SqlTimestamp>)expectedTimestamps);
    }

    private void testPrestoRoundTrip(Type writeType, List<SqlTimestamp> writeValues, Type readType, List<SqlTimestamp> expectedValues) throws Exception {
        for (OrcTester.Format format : FORMATS) {
            TempFile tempFile = new TempFile();
            Throwable throwable = null;
            try {
                OrcTester.writeOrcColumnsPresto(tempFile.getFile(), format, CompressionKind.ZLIB, Optional.empty(), (List<Type>)ImmutableList.of((Object)writeType), ImmutableList.of(writeValues), (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
                OrcTester.assertFileContentsPresto((List<Type>)ImmutableList.of((Object)readType), tempFile, ImmutableList.of(expectedValues), false, false, format.getOrcEncoding(), format, false, true, (List<OrcTester.OrcReaderSettings>)ImmutableList.of(), (Map<Integer, Slice>)ImmutableMap.of());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tempFile == null) continue;
                if (throwable != null) {
                    try {
                        tempFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tempFile.close();
            }
        }
    }

    private List<SqlTimestamp> getMilliTimestampsInMicros(List<SqlTimestamp> millisecondValues) {
        return millisecondValues.stream().map(milliTimestamp -> new SqlTimestamp(milliTimestamp.getMillisUtc() * 1000L, (TimeZoneKey)milliTimestamp.getSessionTimeZoneKey().get(), TimeUnit.MICROSECONDS)).collect(Collectors.toList());
    }

    private /* synthetic */ void lambda$testOverflowReadingMicros$1(List millisecondValuesOverflow, List valuesInMicroOverflow) throws Throwable {
        this.testPrestoRoundTrip((Type)TimestampType.TIMESTAMP, millisecondValuesOverflow, (Type)TimestampType.TIMESTAMP_MICROSECONDS, valuesInMicroOverflow);
    }
}

