/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.metadata.statistics.BinaryColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.StringColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTupleDomainOrcPredicate {
    private static final Type SHORT_DECIMAL = DecimalType.createDecimalType((int)5, (int)2);
    private static final Type LONG_DECIMAL = DecimalType.createDecimalType((int)20, (int)10);
    private static final Type CHAR = CharType.createCharType((long)10L);

    @Test
    public void testBoolean() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)0L, null), (Object)Domain.none((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, null), (Object)Domain.all((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(null, null)), (Object)Domain.none((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(0L, null)), (Object)Domain.none((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(0L, 0L)), (Object)Domain.none((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(0L, 0L)), (Object)Domain.onlyNull((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(10L, null)), (Object)Domain.notNull((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(10L, 10L)), (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(10L, 0L)), (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)20L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(10L, 5L)), (Object)Domain.all((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)20L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(10L, 10L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)20L, (ColumnStatistics)TestTupleDomainOrcPredicate.booleanColumnStats(10L, 0L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)false), (Range[])new Range[0]), (boolean)true));
    }

    private static ColumnStatistics booleanColumnStats(Long numberOfValues, Long trueValueCount) {
        BooleanStatistics booleanStatistics = null;
        if (trueValueCount != null) {
            booleanStatistics = new BooleanStatistics(trueValueCount.longValue());
            return new BooleanColumnStatistics(numberOfValues, null, booleanStatistics);
        }
        return new ColumnStatistics(numberOfValues, null);
    }

    @Test
    public void testBigint() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)0L, null), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, null), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(null, null, null)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(0L, null, null)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(0L, 100L, 100L)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(10L, null, null)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(10L, 100L, 100L)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(10L, 0L, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(10L, null, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)100L), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(10L, 0L, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(5L, 0L, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(5L, null, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)100L), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.integerColumnStats(5L, 0L, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)true));
    }

    private static IntegerColumnStatistics integerColumnStats(Long numberOfValues, Long minimum, Long maximum) {
        return new IntegerColumnStatistics(numberOfValues, null, new IntegerStatistics(minimum, maximum, null));
    }

    @Test
    public void testDouble() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)0L, null), (Object)Domain.none((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, null), (Object)Domain.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(null, null, null)), (Object)Domain.none((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(0L, null, null)), (Object)Domain.none((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(0L, 42.24, 42.24)), (Object)Domain.none((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, null, null)), (Object)Domain.notNull((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, 42.24, 42.24)), (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)42.24));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, 3.3, 42.24)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)3.3, (boolean)true, (Object)42.24, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, null, 42.24)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)42.24), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, 3.3, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)3.3), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(5L, 3.3, 42.24)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)3.3, (boolean)true, (Object)42.24, (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(5L, null, 42.24)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)42.24), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(5L, 3.3, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)3.3), (Range[])new Range[0]), (boolean)true));
    }

    private static DoubleColumnStatistics doubleColumnStats(Long numberOfValues, Double minimum, Double maximum) {
        return new DoubleColumnStatistics(numberOfValues, null, new DoubleStatistics(minimum, maximum));
    }

    @Test
    public void testFloat() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)0L, null), (Object)Domain.none((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, null), (Object)Domain.all((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(null, null, null)), (Object)Domain.none((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(0L, null, null)), (Object)Domain.none((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(0L, (double)42.24f, (double)42.24f)), (Object)Domain.none((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, null, null)), (Object)Domain.notNull((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, (double)42.24f, (double)42.24f)), (Object)Domain.singleValue((Type)RealType.REAL, (Object)Float.floatToRawIntBits(42.24f)));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, 3.3, (double)42.24f)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(3.3f), (boolean)true, (Object)Float.floatToRawIntBits(42.24f), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, null, (double)42.24f)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)RealType.REAL, (Object)Float.floatToRawIntBits(42.24f)), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(10L, 3.3, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)RealType.REAL, (Object)Float.floatToRawIntBits(3.3f)), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(5L, 3.3, (double)42.24f)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(3.3f), (boolean)true, (Object)Float.floatToRawIntBits(42.24f), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(5L, null, (double)42.24f)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)RealType.REAL, (Object)Float.floatToRawIntBits(42.24f)), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)RealType.REAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.doubleColumnStats(5L, 3.3, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)RealType.REAL, (Object)Float.floatToRawIntBits(3.3f)), (Range[])new Range[0]), (boolean)true));
    }

    @Test
    public void testString() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)0L, null), (Object)Domain.none((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, null), (Object)Domain.all((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(null, null, null)), (Object)Domain.none((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, null, null)), (Object)Domain.none((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, "taco", "taco")), (Object)Domain.none((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, null, null)), (Object)Domain.notNull((Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "taco", "taco")), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"taco")));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "apple", "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, null, "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"taco")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "apple", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"apple")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, "apple", "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, null, "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"taco")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarcharType.VARCHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, "apple", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"apple")), (Range[])new Range[0]), (boolean)true));
    }

    @Test
    public void testChar() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)0L, null), (Object)Domain.none((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, null), (Object)Domain.all((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(null, null, null)), (Object)Domain.none((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, null, null)), (Object)Domain.none((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, "taco      ", "taco      ")), (Object)Domain.none((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, "taco", "taco      ")), (Object)Domain.none((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, null, null)), (Object)Domain.notNull((Type)CHAR));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "taco      ", "taco      ")), (Object)Domain.singleValue((Type)CHAR, (Object)Slices.utf8Slice((String)"taco")));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "taco", "taco      ")), (Object)Domain.singleValue((Type)CHAR, (Object)Slices.utf8Slice((String)"taco")));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "apple     ", "taco      ")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)CHAR, (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "apple     ", "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)CHAR, (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, null, "taco      ")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"taco")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, null, "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"taco")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "apple     ", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"apple")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "apple", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"apple")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, "apple     ", "taco      ")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)CHAR, (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, "apple     ", "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)CHAR, (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, null, "taco      ")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"taco")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, null, "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"taco")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, "apple     ", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"apple")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(5L, "apple", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)CHAR, (Object)Slices.utf8Slice((String)"apple")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)CHAR, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.stringColumnStats(10L, "\u0000 ", " ")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)CHAR, (Object)Slices.utf8Slice((String)"\u0000"), (boolean)true, (Object)Slices.utf8Slice((String)""), (boolean)true), (Range[])new Range[0]), (boolean)false));
    }

    private static ColumnStatistics stringColumnStats(Long numberOfValues, String minimum, String maximum) {
        Slice minimumSlice = minimum == null ? null : Slices.utf8Slice((String)minimum);
        Slice maximumSlice = maximum == null ? null : Slices.utf8Slice((String)maximum);
        return new StringColumnStatistics(numberOfValues, null, new StringStatistics(minimumSlice, maximumSlice, 100L));
    }

    @Test
    public void testDate() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)0L, null), (Object)Domain.none((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, null), (Object)Domain.all((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(null, null, null)), (Object)Domain.none((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(0L, null, null)), (Object)Domain.none((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(0L, 100, 100)), (Object)Domain.none((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(10L, null, null)), (Object)Domain.notNull((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(10L, 100, 100)), (Object)Domain.singleValue((Type)DateType.DATE, (Object)100L));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(10L, 0, 100)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DateType.DATE, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(10L, null, 100)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DateType.DATE, (Object)100L), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(10L, 0, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DateType.DATE, (Object)0L), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(5L, 0, 100)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DateType.DATE, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(5L, null, 100)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DateType.DATE, (Object)100L), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)DateType.DATE, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.dateColumnStats(5L, 0, null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DateType.DATE, (Object)0L), (Range[])new Range[0]), (boolean)true));
    }

    private static ColumnStatistics dateColumnStats(Long numberOfValues, Integer minimum, Integer maximum) {
        return new DateColumnStatistics(numberOfValues, null, new DateStatistics(minimum, maximum));
    }

    @Test
    public void testDecimal() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)0L, null), (Object)Domain.none((Type)SHORT_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, null), (Object)Domain.all((Type)LONG_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(null, null, null)), (Object)Domain.none((Type)SHORT_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(0L, null, null)), (Object)Domain.none((Type)LONG_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(0L, "-999.99", "999.99")), (Object)Domain.none((Type)SHORT_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(0L, null, null)), (Object)Domain.onlyNull((Type)LONG_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, null, null)), (Object)Domain.notNull((Type)SHORT_DECIMAL));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "999.99", "999.99")), (Object)Domain.singleValue((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("999.99")));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "999.9", "999.9")), (Object)Domain.singleValue((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("999.90")));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "1234567890.0987654321", "1234567890.0987654321")), (Object)Domain.singleValue((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("1234567890.0987654321")));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "-999.99", "999.99")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("-999.99"), (boolean)true, (Object)TestTupleDomainOrcPredicate.shortDecimal("999.99"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "10.5", "20")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("10.50"), (boolean)true, (Object)TestTupleDomainOrcPredicate.shortDecimal("20.00"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, null, "999.99")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("999.99")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "-999.99", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("-999.99")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "-1234567890.0987654321", "1234567890.0987654321")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("-1234567890.0987654321"), (boolean)true, (Object)TestTupleDomainOrcPredicate.longDecimal("1234567890.0987654321"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, null, "1234567890.0987654321")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("1234567890.0987654321")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(10L, "-1234567890.0987654321", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("-1234567890.0987654321")), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(5L, "-999.99", "999.99")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("-999.99"), (boolean)true, (Object)TestTupleDomainOrcPredicate.shortDecimal("999.99"), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(5L, null, "999.99")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("999.99")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)SHORT_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(5L, "-999.99", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)SHORT_DECIMAL, (Object)TestTupleDomainOrcPredicate.shortDecimal("-999.99")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(5L, "-1234567890.0987654321", "1234567890.0987654321")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("-1234567890.0987654321"), (boolean)true, (Object)TestTupleDomainOrcPredicate.longDecimal("1234567890.0987654321"), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(5L, null, "1234567890.0987654321")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("1234567890.0987654321")), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)LONG_DECIMAL, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.decimalColumnStats(5L, "-1234567890.0987654321", null)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)LONG_DECIMAL, (Object)TestTupleDomainOrcPredicate.longDecimal("-1234567890.0987654321")), (Range[])new Range[0]), (boolean)true));
    }

    private static ColumnStatistics decimalColumnStats(Long numberOfValues, String minimum, String maximum) {
        BigDecimal minimumDecimal = minimum == null ? null : new BigDecimal(minimum);
        BigDecimal maximumDecimal = maximum == null ? null : new BigDecimal(maximum);
        return new DecimalColumnStatistics(numberOfValues, null, new DecimalStatistics(minimumDecimal, maximumDecimal, 8L));
    }

    @Test
    public void testBinary() {
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)0L, null), (Object)Domain.none((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)10L, null), (Object)Domain.all((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.binaryColumnStats(null)), (Object)Domain.none((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.binaryColumnStats(0L)), (Object)Domain.none((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)0L, (ColumnStatistics)TestTupleDomainOrcPredicate.binaryColumnStats(0L)), (Object)Domain.none((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.binaryColumnStats(0L)), (Object)Domain.onlyNull((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)10L, (ColumnStatistics)TestTupleDomainOrcPredicate.binaryColumnStats(10L)), (Object)Domain.notNull((Type)VarbinaryType.VARBINARY));
        Assert.assertEquals((Object)TupleDomainOrcPredicate.getDomain((Type)VarbinaryType.VARBINARY, (long)20L, (ColumnStatistics)TestTupleDomainOrcPredicate.binaryColumnStats(10L)), (Object)Domain.all((Type)VarbinaryType.VARBINARY));
    }

    private static ColumnStatistics binaryColumnStats(Long numberOfValues) {
        return new BinaryColumnStatistics(numberOfValues, null, new BinaryStatistics(100L));
    }

    private static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValue();
    }

    private static Slice longDecimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }
}

