/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcZstdDecompressor;
import com.facebook.presto.orc.zstd.ZstdJniCompressor;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.OptionalInt;
import java.util.Random;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestZstdJniDecompression {
    private static final DataSize MAX_BUFFER_SIZE = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private static final int MIN_ZSTD_LEVEL = -5;
    private static final int MAX_ZSTD_LEVEL = 10;
    private final OrcZstdDecompressor decompressor = new OrcZstdDecompressor(new OrcDataSourceId("test"), (int)MAX_BUFFER_SIZE.toBytes(), true);

    @DataProvider(name="zstdCompressionLevels")
    public static Object[][] zstdCompressionLevels() {
        ImmutableList.Builder levels = new ImmutableList.Builder();
        levels.add((Object)new Object[]{OptionalInt.empty()});
        for (int level = -5; level <= 10; ++level) {
            levels.add((Object)new Object[]{OptionalInt.of(level)});
        }
        return (Object[][])levels.build().toArray((Object[])new Object[0][]);
    }

    @Test(dataProvider="zstdCompressionLevels")
    public void testDecompression(OptionalInt level) throws OrcCorruptionException {
        byte[] sourceBytes = this.generateRandomBytes();
        byte[] compressedBytes = new byte[0x100000];
        ZstdJniCompressor compressor = new ZstdJniCompressor(level);
        int size = compressor.compress(sourceBytes, 0, sourceBytes.length, compressedBytes, 0, compressedBytes.length);
        final byte[] output = new byte[sourceBytes.length];
        int outputSize = this.decompressor.decompress(compressedBytes, 0, size, new OrcDecompressor.OutputBuffer(){

            public byte[] initialize(int size) {
                return output;
            }

            public byte[] grow(int size) {
                throw new RuntimeException();
            }
        });
        Assert.assertEquals((int)outputSize, (int)sourceBytes.length);
        Assert.assertEquals((byte[])output, (byte[])sourceBytes);
    }

    private byte[] generateRandomBytes() {
        Random random = new Random();
        byte[] array = new byte[1024];
        random.nextBytes(array);
        return array;
    }
}

