/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class TestingOrcDataSource
implements OrcDataSource {
    private final OrcDataSource delegate;
    private final List<DiskRange> readRanges = new ArrayList<DiskRange>();
    private int readCount;
    private List<DiskRange> lastReadRanges;

    public TestingOrcDataSource(OrcDataSource delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public OrcDataSourceId getId() {
        return this.delegate.getId();
    }

    public int getReadCount() {
        return this.readCount;
    }

    public List<DiskRange> getLastReadRanges() {
        return this.lastReadRanges;
    }

    public List<DiskRange> getReadRanges() {
        return ImmutableList.copyOf(this.readRanges);
    }

    public long getReadBytes() {
        return this.delegate.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public long getSize() {
        return this.delegate.getSize();
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        ++this.readCount;
        this.lastReadRanges = ImmutableList.of((Object)new DiskRange(position, buffer.length));
        this.readRanges.addAll(this.lastReadRanges);
        this.delegate.readFully(position, buffer);
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        ++this.readCount;
        this.lastReadRanges = ImmutableList.of((Object)new DiskRange(position, bufferLength));
        this.readRanges.addAll(this.lastReadRanges);
        this.delegate.readFully(position, buffer, bufferOffset, bufferLength);
    }

    public <K> Map<K, OrcDataSourceInput> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        this.readCount += diskRanges.size();
        this.lastReadRanges = ImmutableList.copyOf(diskRanges.values());
        this.readRanges.addAll(this.lastReadRanges);
        return this.delegate.readFully(diskRanges);
    }
}

