/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;

public final class TestingOrcPredicate {
    public static final int ORC_STRIPE_SIZE = 30000;
    public static final int ORC_ROW_GROUP_SIZE = 10000;

    private TestingOrcPredicate() {
    }

    public static OrcPredicate createOrcPredicate(List<Type> types, List<List<?>> values, OrcTester.Format format, boolean isHiveWriter) {
        List orcPredicates = (List)IntStream.range(0, types.size()).mapToObj(i -> TestingOrcPredicate.createOrcPredicate(i, (Type)types.get(i), (Iterable)values.get(i), format, isHiveWriter)).collect(ImmutableList.toImmutableList());
        return new MultiOrcPredicate(orcPredicates);
    }

    public static OrcPredicate createOrcPredicate(int columnIndex, Type type, Iterable<?> values, OrcTester.Format format, boolean isHiveWriter) {
        ArrayList expectedValues = Lists.newArrayList(values);
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanOrcPredicate(columnIndex, expectedValues, false);
        }
        if (TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            return new LongOrcPredicate(true, columnIndex, expectedValues.stream().map(value -> value == null ? null : Long.valueOf(((Number)value).longValue())).collect(Collectors.toList()), false);
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return new LongOrcPredicate(false, columnIndex, expectedValues.stream().map(value -> value == null ? null : Long.valueOf(((SqlTimestamp)value).getMillisUtc())).collect(Collectors.toList()), false);
        }
        if (TimestampType.TIMESTAMP_MICROSECONDS.equals((Object)type)) {
            return new LongOrcPredicate(false, columnIndex, expectedValues.stream().map(value -> value == null ? null : Long.valueOf(((SqlTimestamp)value).getMicrosUtc())).collect(Collectors.toList()), false);
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateOrcPredicate(columnIndex, expectedValues.stream().map(value -> value == null ? null : Long.valueOf(((SqlDate)value).getDays())).collect(Collectors.toList()), false);
        }
        if (RealType.REAL.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleOrcPredicate(columnIndex, expectedValues.stream().map(value -> value == null ? null : Double.valueOf(((Number)value).doubleValue())).collect(Collectors.toList()), false);
        }
        if (type instanceof VarbinaryType) {
            return new BasicOrcPredicate<Object>(columnIndex, expectedValues, Object.class, false);
        }
        if (type instanceof VarcharType) {
            return new StringOrcPredicate(columnIndex, expectedValues, format, isHiveWriter);
        }
        if (type instanceof CharType) {
            return new CharOrcPredicate(columnIndex, expectedValues, false);
        }
        if (type instanceof DecimalType) {
            return new DecimalOrcPredicate(columnIndex, expectedValues, false);
        }
        String baseType = type.getTypeSignature().getBase();
        if ("array".equals(baseType) || "map".equals(baseType) || "row".equals(baseType)) {
            return new BasicOrcPredicate<Object>(columnIndex, expectedValues, Object.class, false);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public static class DateOrcPredicate
    extends BasicOrcPredicate<Long> {
        public DateOrcPredicate(int columnIndex, Iterable<?> expectedValues, boolean noFileStats) {
            super(columnIndex, expectedValues, Long.class, noFileStats);
        }

        @Override
        protected boolean chunkMatchesStats(List<Long> chunk, ColumnStatistics columnStatistics) {
            Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
            Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
            Assert.assertNull((Object)columnStatistics.getStringStatistics());
            if (!super.chunkMatchesStats(chunk, columnStatistics)) {
                return false;
            }
            if (columnStatistics.getDateStatistics() != null) {
                if (chunk.stream().allMatch(Objects::isNull)) {
                    if (columnStatistics.getDateStatistics().getMin() != null || columnStatistics.getDateStatistics().getMax() != null) {
                        return false;
                    }
                } else {
                    Long chunkMax;
                    Long min = columnStatistics.getDateStatistics().getMin().longValue();
                    if (!min.equals(Ordering.natural().nullsLast().min(chunk))) {
                        return false;
                    }
                    Long statMax = columnStatistics.getDateStatistics().getMax().longValue();
                    if (!statMax.equals(chunkMax = (Long)Ordering.natural().nullsFirst().max(chunk))) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static class CharOrcPredicate
    extends BasicOrcPredicate<String> {
        public CharOrcPredicate(int columnIndex, Iterable<?> expectedValues, boolean noFileStats) {
            super(columnIndex, expectedValues, String.class, noFileStats);
        }

        @Override
        protected boolean chunkMatchesStats(List<String> chunk, ColumnStatistics columnStatistics) {
            Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
            Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
            Assert.assertNull((Object)columnStatistics.getDateStatistics());
            if (!super.chunkMatchesStats(chunk, columnStatistics)) {
                return false;
            }
            List strings = chunk.stream().filter(Objects::nonNull).map(String::trim).collect(Collectors.toList());
            if (columnStatistics.getStringStatistics() != null) {
                if (strings.isEmpty()) {
                    if (columnStatistics.getStringStatistics().getMin() != null || columnStatistics.getStringStatistics().getMax() != null) {
                        return false;
                    }
                } else {
                    String chunkMin = (String)Ordering.natural().nullsLast().min(strings);
                    if (columnStatistics.getStringStatistics().getMin().toStringUtf8().trim().compareTo(chunkMin) > 0) {
                        return false;
                    }
                    String chunkMax = (String)Ordering.natural().nullsFirst().max(strings);
                    if (columnStatistics.getStringStatistics().getMax().toStringUtf8().trim().compareTo(chunkMax) < 0) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static class StringOrcPredicate
    extends BasicOrcPredicate<String> {
        private final OrcTester.Format format;
        private final boolean isHiveWriter;

        public StringOrcPredicate(int columnIndex, Iterable<?> expectedValues, OrcTester.Format format, boolean isHiveWriter) {
            super(columnIndex, expectedValues, String.class, false);
            this.format = format;
            this.isHiveWriter = isHiveWriter;
        }

        @Override
        protected boolean chunkMatchesStats(List<String> chunk, ColumnStatistics columnStatistics) {
            Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
            Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
            Assert.assertNull((Object)columnStatistics.getDateStatistics());
            if (!super.chunkMatchesStats(chunk, columnStatistics)) {
                return false;
            }
            List slices = chunk.stream().filter(Objects::nonNull).map(Slices::utf8Slice).collect(Collectors.toList());
            HiveBloomFilter bloomFilter = columnStatistics.getBloomFilter();
            if (bloomFilter != null) {
                for (Slice slice : slices) {
                    if (bloomFilter.test(slice.getBytes())) continue;
                    return false;
                }
                int falsePositive = 0;
                byte[] testBuffer = new byte[32];
                for (int i = 0; i < 100000; ++i) {
                    ThreadLocalRandom.current().nextBytes(testBuffer);
                    if (!bloomFilter.test(testBuffer)) continue;
                    ++falsePositive;
                }
                if (falsePositive != 0 && 1.0 * (double)falsePositive / 100000.0 > 0.55) {
                    return false;
                }
            }
            if (columnStatistics.getStringStatistics() != null) {
                if (slices.isEmpty()) {
                    if (columnStatistics.getStringStatistics().getMin() != null || columnStatistics.getStringStatistics().getMax() != null) {
                        return false;
                    }
                } else {
                    Slice chunkMin = (Slice)Ordering.natural().nullsLast().min(slices);
                    Slice chunkMax = (Slice)Ordering.natural().nullsFirst().max(slices);
                    if (this.format == OrcTester.Format.DWRF && this.isHiveWriter) {
                        if (columnStatistics.getStringStatistics().getMin().compareTo(chunkMin) > 0) {
                            return false;
                        }
                        if (columnStatistics.getStringStatistics().getMax().compareTo(chunkMax) < 0) {
                            return false;
                        }
                    } else {
                        if (!columnStatistics.getStringStatistics().getMin().equals((Object)chunkMin)) {
                            return false;
                        }
                        if (!columnStatistics.getStringStatistics().getMax().equals((Object)chunkMax)) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
    }

    public static class LongOrcPredicate
    extends BasicOrcPredicate<Long> {
        private final boolean testBloomFilter;

        public LongOrcPredicate(boolean testBloomFilter, int columnIndex, Iterable<?> expectedValues, boolean noFileStats) {
            super(columnIndex, expectedValues, Long.class, noFileStats);
            this.testBloomFilter = testBloomFilter;
        }

        @Override
        protected boolean chunkMatchesStats(List<Long> chunk, ColumnStatistics columnStatistics) {
            Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
            Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
            Assert.assertNull((Object)columnStatistics.getStringStatistics());
            Assert.assertNull((Object)columnStatistics.getDateStatistics());
            if (!super.chunkMatchesStats(chunk, columnStatistics)) {
                return false;
            }
            if (columnStatistics.getIntegerStatistics() != null) {
                if (chunk.stream().allMatch(Objects::isNull)) {
                    if (columnStatistics.getIntegerStatistics().getMin() != null || columnStatistics.getIntegerStatistics().getMax() != null) {
                        return false;
                    }
                } else {
                    if (!columnStatistics.getIntegerStatistics().getMin().equals(Ordering.natural().nullsLast().min(chunk))) {
                        return false;
                    }
                    if (!columnStatistics.getIntegerStatistics().getMax().equals(Ordering.natural().nullsFirst().max(chunk))) {
                        return false;
                    }
                }
                long sum = chunk.stream().filter(Objects::nonNull).mapToLong(Long::longValue).sum();
                if (columnStatistics.getIntegerStatistics().getSum() != null && columnStatistics.getIntegerStatistics().getSum() != sum) {
                    return false;
                }
                HiveBloomFilter bloomFilter = columnStatistics.getBloomFilter();
                if (this.testBloomFilter && bloomFilter != null) {
                    for (Long value : chunk) {
                        if (value == null || bloomFilter.testLong(value.longValue())) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static class DecimalOrcPredicate
    extends BasicOrcPredicate<SqlDecimal> {
        public DecimalOrcPredicate(int columnIndex, Iterable<?> expectedValues, boolean noFileStats) {
            super(columnIndex, expectedValues, SqlDecimal.class, noFileStats);
        }
    }

    public static class DoubleOrcPredicate
    extends BasicOrcPredicate<Double> {
        public DoubleOrcPredicate(int columnIndex, Iterable<?> expectedValues, boolean noFileStats) {
            super(columnIndex, expectedValues, Double.class, noFileStats);
        }

        @Override
        protected boolean chunkMatchesStats(List<Double> chunk, ColumnStatistics columnStatistics) {
            Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
            Assert.assertNull((Object)columnStatistics.getStringStatistics());
            Assert.assertNull((Object)columnStatistics.getDateStatistics());
            if (!super.chunkMatchesStats(chunk, columnStatistics)) {
                return false;
            }
            HiveBloomFilter bloomFilter = columnStatistics.getBloomFilter();
            if (bloomFilter != null) {
                for (Double value : chunk) {
                    if (value == null || bloomFilter.testDouble(value.doubleValue())) continue;
                    return false;
                }
            }
            if (columnStatistics.getDoubleStatistics() != null) {
                if (chunk.stream().allMatch(Objects::isNull)) {
                    if (columnStatistics.getDoubleStatistics().getMin() != null || columnStatistics.getDoubleStatistics().getMax() != null) {
                        return false;
                    }
                } else {
                    if (Math.abs(columnStatistics.getDoubleStatistics().getMin() - (Double)Ordering.natural().nullsLast().min(chunk)) > 0.001) {
                        return false;
                    }
                    if (Math.abs(columnStatistics.getDoubleStatistics().getMax() - (Double)Ordering.natural().nullsFirst().max(chunk)) > 0.001) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static class BooleanOrcPredicate
    extends BasicOrcPredicate<Boolean> {
        public BooleanOrcPredicate(int columnIndex, Iterable<?> expectedValues, boolean noFileStats) {
            super(columnIndex, expectedValues, Boolean.class, noFileStats);
        }

        @Override
        protected boolean chunkMatchesStats(List<Boolean> chunk, ColumnStatistics columnStatistics) {
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
            Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
            Assert.assertNull((Object)columnStatistics.getStringStatistics());
            Assert.assertNull((Object)columnStatistics.getDateStatistics());
            if (!super.chunkMatchesStats(chunk, columnStatistics)) {
                return false;
            }
            return columnStatistics.getBooleanStatistics() == null || columnStatistics.getBooleanStatistics().getTrueValueCount() == (long)Iterables.size((Iterable)Iterables.filter(chunk, (Predicate)Predicates.equalTo((Object)Boolean.TRUE)));
        }
    }

    public static class BasicOrcPredicate<T>
    implements OrcPredicate {
        private final int columnIndex;
        private final List<T> expectedValues;
        private final boolean noFileStats;

        public BasicOrcPredicate(int columnIndex, Iterable<?> expectedValues, Class<T> type, boolean noFileStats) {
            ArrayList<T> values = new ArrayList<T>();
            for (Object expectedValue : expectedValues) {
                values.add(type.cast(expectedValue));
            }
            this.columnIndex = columnIndex;
            this.expectedValues = Collections.unmodifiableList(values);
            this.noFileStats = noFileStats;
        }

        public boolean matches(long numberOfRows, Map<Integer, ColumnStatistics> statisticsByColumnIndex) {
            ColumnStatistics columnStatistics = statisticsByColumnIndex.get(this.columnIndex);
            Assert.assertTrue((boolean)columnStatistics.hasNumberOfValues());
            if (this.noFileStats && numberOfRows == (long)this.expectedValues.size()) {
                Assert.assertNull((Object)columnStatistics);
                return true;
            }
            if (numberOfRows == (long)this.expectedValues.size()) {
                this.assertChunkStats(this.expectedValues, columnStatistics);
            } else if (numberOfRows == 10000L) {
                this.matchMiddleSection(columnStatistics, 10000);
            } else if (numberOfRows == 30000L) {
                this.matchMiddleSection(columnStatistics, 30000);
            } else if (numberOfRows == (long)(this.expectedValues.size() % 10000) || numberOfRows == (long)(this.expectedValues.size() % 30000)) {
                List<T> chunk = this.expectedValues.subList((int)((long)this.expectedValues.size() - numberOfRows), this.expectedValues.size());
                this.assertChunkStats(chunk, columnStatistics);
            } else if (numberOfRows == (long)(this.expectedValues.size() % 30000)) {
                List<T> chunk = this.expectedValues.subList((int)((long)this.expectedValues.size() - numberOfRows), this.expectedValues.size());
                this.assertChunkStats(chunk, columnStatistics);
            } else {
                Assert.fail((String)("Unexpected number of rows: " + numberOfRows));
            }
            return true;
        }

        private void matchMiddleSection(ColumnStatistics columnStatistics, int size) {
            int length;
            for (int offset = 0; offset < this.expectedValues.size(); offset += length) {
                length = Math.min(size, this.expectedValues.size() - offset);
                if (!this.chunkMatchesStats(this.expectedValues.subList(offset, offset + length), columnStatistics)) continue;
                return;
            }
            Assert.fail((String)"match not found for middle section");
        }

        private void assertChunkStats(List<T> chunk, ColumnStatistics columnStatistics) {
            Assert.assertTrue((boolean)this.chunkMatchesStats(chunk, columnStatistics));
        }

        protected boolean chunkMatchesStats(List<T> chunk, ColumnStatistics columnStatistics) {
            return columnStatistics.getNumberOfValues() == (long)Iterables.size((Iterable)Iterables.filter(chunk, (Predicate)Predicates.notNull()));
        }
    }

    private static class MultiOrcPredicate
    implements OrcPredicate {
        private final List<OrcPredicate> orcPredicates;

        public MultiOrcPredicate(List<OrcPredicate> orcPredicates) {
            this.orcPredicates = Objects.requireNonNull(orcPredicates, "orcPredicates is null");
        }

        public boolean matches(long numberOfRows, Map<Integer, ColumnStatistics> statisticsByColumnIndex) {
            return this.orcPredicates.stream().allMatch(predicate -> predicate.matches(numberOfRows, statisticsByColumnIndex));
        }
    }
}

