/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.predicate.TupleDomainFilter;
import java.util.Objects;
import java.util.function.Consumer;

public interface TrackingTupleDomainFilter
extends TupleDomainFilter {

    public static class TestDoubleRange
    extends TupleDomainFilter.DoubleRange
    implements TrackingTupleDomainFilter {
        private final Consumer<TupleDomainFilter> onTestCallback;

        public static TestDoubleRange of(TupleDomainFilter.DoubleRange range, Consumer<TupleDomainFilter> onTestCallback) {
            return new TestDoubleRange(range.getLower(), range.getLowerUnbounded(), range.getLowerExclusive(), range.getUpper(), range.getUpperUnbounded(), range.getUpperExclusive(), range.testNull(), onTestCallback);
        }

        private TestDoubleRange(double lower, boolean lowerUnbounded, boolean lowerExclusive, double upper, boolean upperUnbounded, boolean upperExclusive, boolean nullAllowed, Consumer<TupleDomainFilter> onTestCallback) {
            super(lower, lowerUnbounded, lowerExclusive, upper, upperUnbounded, upperExclusive, nullAllowed);
            this.onTestCallback = Objects.requireNonNull(onTestCallback, "onTestCallback is null");
        }

        public boolean testDouble(double value) {
            this.onTestCallback.accept(this);
            return super.testDouble(value);
        }
    }

    public static class TestBigintRange
    extends TupleDomainFilter.BigintRange
    implements TrackingTupleDomainFilter {
        private final Consumer<TupleDomainFilter> onTestCallback;

        public static TestBigintRange of(TupleDomainFilter.BigintRange range, Consumer<TupleDomainFilter> onTestCallback) {
            return new TestBigintRange(range.getLower(), range.getUpper(), range.testNull(), onTestCallback);
        }

        private TestBigintRange(long lower, long upper, boolean nullAllowed, Consumer<TupleDomainFilter> onTestCallback) {
            super(lower, upper, nullAllowed);
            this.onTestCallback = Objects.requireNonNull(onTestCallback, "onTestCallback is null");
        }

        public boolean testLong(long value) {
            this.onTestCallback.accept(this);
            return super.testLong(value);
        }
    }
}

