/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.testng.Assert;

public class TupleDomainFilterOrderChecker {
    private final List<Integer> expectedOrder;
    private final List<Integer> actualOrder = new ArrayList<Integer>();

    public TupleDomainFilterOrderChecker(List<Integer> expectedOrder) {
        this.expectedOrder = Objects.requireNonNull(expectedOrder, "expectedOrder is null");
    }

    public void call(int column) {
        if (!this.actualOrder.contains(column)) {
            this.actualOrder.add(column);
        }
    }

    public void assertOrder() {
        Assert.assertEquals(this.actualOrder, this.expectedOrder, (String)("Actual order " + this.actualOrder + " doesn't match desired order " + this.expectedOrder));
    }
}

