/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfMetadataReader;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.TestOrcMetadataReader;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDwrfMetadataReader {
    private final long footerLength = 10L;
    private final long compressionBlockSize = 8192L;
    private final OrcReaderOptions orcReaderOptions = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withReadMapStatistics(true).build();
    private final DwrfMetadataReader dwrfMetadataReader = new DwrfMetadataReader(new RuntimeStats(), this.orcReaderOptions);
    private final DwrfProto.PostScript baseProtoPostScript = DwrfProto.PostScript.newBuilder().setWriterVersion(PostScript.HiveWriterVersion.ORC_HIVE_8732.getOrcWriterVersion()).setFooterLength(10L).setCompression(DwrfProto.CompressionKind.ZSTD).setCompressionBlockSize(8192L).setCacheSize(12).setCacheMode(DwrfProto.StripeCacheMode.BOTH).build();

    @Test
    public void testReadPostScript() throws IOException {
        byte[] data = this.baseProtoPostScript.toByteArray();
        PostScript postScript = this.dwrfMetadataReader.readPostScript(data, 0, data.length);
        Assert.assertEquals((Object)postScript.getHiveWriterVersion(), (Object)PostScript.HiveWriterVersion.ORC_HIVE_8732);
        Assert.assertEquals((long)postScript.getFooterLength(), (long)10L);
        Assert.assertEquals((Object)postScript.getCompression(), (Object)CompressionKind.ZSTD);
        Assert.assertEquals((long)postScript.getCompressionBlockSize(), (long)8192L);
        Assert.assertEquals((int)postScript.getDwrfStripeCacheLength().getAsInt(), (int)12);
        Assert.assertEquals(postScript.getDwrfStripeCacheMode().get(), (Object)DwrfStripeCacheMode.INDEX_AND_FOOTER);
    }

    @Test
    public void testReadPostScriptNoDwrfStripeCache() throws IOException {
        DwrfProto.PostScript protoPostScript = this.baseProtoPostScript.toBuilder().clearCacheSize().clearCacheMode().build();
        byte[] data = protoPostScript.toByteArray();
        PostScript postScript = this.dwrfMetadataReader.readPostScript(data, 0, data.length);
        Assert.assertFalse((boolean)postScript.getDwrfStripeCacheLength().isPresent());
        Assert.assertFalse((boolean)postScript.getDwrfStripeCacheMode().isPresent());
    }

    @Test
    public void testReadPostScriptMissingDwrfStripeCacheLength() throws IOException {
        DwrfProto.PostScript protoPostScript = this.baseProtoPostScript.toBuilder().clearCacheSize().build();
        byte[] data = protoPostScript.toByteArray();
        PostScript postScript = this.dwrfMetadataReader.readPostScript(data, 0, data.length);
        Assert.assertFalse((boolean)postScript.getDwrfStripeCacheLength().isPresent());
        Assert.assertFalse((boolean)postScript.getDwrfStripeCacheMode().isPresent());
    }

    @Test
    public void testReadPostScriptMissingDwrfStripeCacheMode() throws IOException {
        DwrfProto.PostScript protoPostScript = this.baseProtoPostScript.toBuilder().clearCacheMode().build();
        byte[] data = protoPostScript.toByteArray();
        PostScript postScript = this.dwrfMetadataReader.readPostScript(data, 0, data.length);
        Assert.assertFalse((boolean)postScript.getDwrfStripeCacheLength().isPresent());
        Assert.assertFalse((boolean)postScript.getDwrfStripeCacheMode().isPresent());
    }

    @Test
    public void testToStripeCacheMode() {
        Assert.assertEquals((Object)DwrfMetadataReader.toStripeCacheMode((DwrfProto.StripeCacheMode)DwrfProto.StripeCacheMode.INDEX), (Object)DwrfStripeCacheMode.INDEX);
        Assert.assertEquals((Object)DwrfMetadataReader.toStripeCacheMode((DwrfProto.StripeCacheMode)DwrfProto.StripeCacheMode.FOOTER), (Object)DwrfStripeCacheMode.FOOTER);
        Assert.assertEquals((Object)DwrfMetadataReader.toStripeCacheMode((DwrfProto.StripeCacheMode)DwrfProto.StripeCacheMode.BOTH), (Object)DwrfStripeCacheMode.INDEX_AND_FOOTER);
        Assert.assertEquals((Object)DwrfMetadataReader.toStripeCacheMode((DwrfProto.StripeCacheMode)DwrfProto.StripeCacheMode.NA), (Object)DwrfStripeCacheMode.NONE);
    }

    @Test
    public void testStripeInformationRows() throws IOException {
        long aLongNumber = 2147484647L;
        for (OptionalLong stripeRawDataSize : ImmutableList.of((Object)OptionalLong.empty(), (Object)OptionalLong.of(1000123L))) {
            StripeInformation expectedStripeInformation = new StripeInformation(aLongNumber, aLongNumber, aLongNumber, aLongNumber, aLongNumber, stripeRawDataSize, (List)ImmutableList.of());
            DwrfProto.StripeInformation dwrfStripeInformation = DwrfMetadataWriter.toStripeInformation((StripeInformation)expectedStripeInformation);
            DwrfProto.Footer protoFooter = DwrfProto.Footer.newBuilder().setNumberOfRows(aLongNumber).setRowIndexStride(10000).addStripes(dwrfStripeInformation).build();
            Footer footer = this.convertToFooter(protoFooter);
            Assert.assertEquals((long)footer.getNumberOfRows(), (long)aLongNumber);
            Assert.assertEquals((int)footer.getStripes().size(), (int)1);
            StripeInformation actualStripeInformation = (StripeInformation)footer.getStripes().get(0);
            Assert.assertEquals((long)actualStripeInformation.getOffset(), (long)expectedStripeInformation.getOffset());
            Assert.assertEquals((long)actualStripeInformation.getNumberOfRows(), (long)expectedStripeInformation.getNumberOfRows());
            Assert.assertEquals((long)actualStripeInformation.getIndexLength(), (long)expectedStripeInformation.getIndexLength());
            Assert.assertEquals((long)actualStripeInformation.getDataLength(), (long)expectedStripeInformation.getDataLength());
            Assert.assertEquals((long)actualStripeInformation.getFooterLength(), (long)expectedStripeInformation.getFooterLength());
            Assert.assertEquals((long)actualStripeInformation.getTotalLength(), (long)expectedStripeInformation.getTotalLength());
            Assert.assertEquals((Object)actualStripeInformation.getRawDataSize(), (Object)expectedStripeInformation.getRawDataSize());
        }
    }

    @Test
    public void testReadFooter() throws IOException {
        long numberOfRows = 10L;
        int rowIndexStride = 11;
        ImmutableList stripeCacheOffsets = ImmutableList.of((Object)1, (Object)2, (Object)3);
        for (OptionalLong rawDataSize : ImmutableList.of((Object)OptionalLong.empty(), (Object)OptionalLong.of(1000123L))) {
            DwrfProto.Footer.Builder protoFooterBuilder = DwrfProto.Footer.newBuilder().setNumberOfRows(numberOfRows).setRowIndexStride(rowIndexStride).addAllStripeCacheOffsets((Iterable)stripeCacheOffsets);
            if (rawDataSize.isPresent()) {
                protoFooterBuilder.setRawDataSize(rawDataSize.getAsLong());
            }
            DwrfProto.Footer protoFooter = protoFooterBuilder.build();
            Footer footer = this.convertToFooter(protoFooter);
            Assert.assertEquals((long)footer.getNumberOfRows(), (long)numberOfRows);
            Assert.assertEquals((int)footer.getRowsInRowGroup(), (int)rowIndexStride);
            Assert.assertEquals((Collection)((Collection)footer.getDwrfStripeCacheOffsets().get()), (Collection)stripeCacheOffsets);
            Assert.assertEquals((Object)footer.getRawSize(), (Object)rawDataSize);
            Assert.assertEquals((Collection)footer.getStripes(), Collections.emptyList());
        }
    }

    private Footer convertToFooter(DwrfProto.Footer protoFooter) throws IOException {
        byte[] data = protoFooter.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        return this.dwrfMetadataReader.readFooter(PostScript.HiveWriterVersion.ORC_HIVE_8732, (InputStream)inputStream, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, null, Optional.empty());
    }

    @Test
    public void testReadStripeFooterThrowsForLargeStreams() {
        DwrfProto.Stream stream = DwrfProto.Stream.newBuilder().setKind(DwrfProto.Stream.Kind.DATA).setLength(Long.MAX_VALUE).build();
        DwrfProto.StripeFooter protoStripeFooter = DwrfProto.StripeFooter.newBuilder().addStreams(stream).build();
        byte[] data = protoStripeFooter.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        OrcDataSourceId orcDataSourceId = new OrcDataSourceId("test");
        OrcCorruptionException ex = (OrcCorruptionException)Assert.expectThrows(OrcCorruptionException.class, () -> this.dwrfMetadataReader.readStripeFooter(orcDataSourceId, (List)ImmutableList.of(), inputStream));
        Assert.assertEquals((String)ex.getMessage(), (String)"java.io.IOException: Malformed ORC file. Stream size 9223372036854775807 of one of the streams for column 0 is larger than supported size 2147483647 [test]");
    }

    @Test
    public void testToStringStatistics() {
        Assert.assertNull((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMinimum("ant").setMaximum("cat").setSum(44L).build(), (boolean)false));
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)true, (Object)false).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean isRowGroup = (Boolean)unmodifiableIterator.next();
            Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setSum(45L).build(), (boolean)isRowGroup), (Object)new StringStatistics(null, null, 45L));
        }
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setSum(45L).build(), (boolean)true), (Object)new StringStatistics(null, null, 45L));
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMinimum("ant").build(), (boolean)true), (Object)new StringStatistics(Slices.utf8Slice((String)"ant"), null, 0L));
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMaximum("cat").build(), (boolean)true), (Object)new StringStatistics(null, Slices.utf8Slice((String)"cat"), 0L));
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMinimum("ant").setMaximum("cat").setSum(79L).build(), (boolean)true), (Object)new StringStatistics(Slices.utf8Slice((String)"ant"), Slices.utf8Slice((String)"cat"), 79L));
        for (Slice prefix : TestOrcMetadataReader.ALL_UTF8_SEQUENCES) {
            for (int testCodePoint : TestOrcMetadataReader.TEST_CODE_POINTS) {
                Slice codePoint = SliceUtf8.codePointToUtf8((int)testCodePoint);
                for (Slice suffix : TestOrcMetadataReader.ALL_UTF8_SEQUENCES) {
                    Slice testValue = TestOrcMetadataReader.concatSlice(prefix, codePoint, suffix);
                    TestDwrfMetadataReader.testStringStatisticsTruncation(testValue, PostScript.HiveWriterVersion.ORIGINAL);
                    TestDwrfMetadataReader.testStringStatisticsTruncation(testValue, PostScript.HiveWriterVersion.ORC_HIVE_8732);
                }
            }
        }
    }

    private static void testStringStatisticsTruncation(Slice testValue, PostScript.HiveWriterVersion version) {
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)version, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMinimumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setMaximumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setSum(79L).build(), (boolean)true), (Object)TestDwrfMetadataReader.createExpectedStringStatistics(version, testValue, testValue, 79));
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)version, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMinimumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setSum(79L).build(), (boolean)true), (Object)TestDwrfMetadataReader.createExpectedStringStatistics(version, testValue, null, 79));
        Assert.assertEquals((Object)DwrfMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)version, (DwrfProto.StringStatistics)DwrfProto.StringStatistics.newBuilder().setMaximumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setSum(79L).build(), (boolean)true), (Object)TestDwrfMetadataReader.createExpectedStringStatistics(version, null, testValue, 79));
    }

    private static StringStatistics createExpectedStringStatistics(PostScript.HiveWriterVersion version, Slice min, Slice max, int sum) {
        return new StringStatistics(OrcMetadataReader.minStringTruncateToValidRange((Slice)min, (PostScript.HiveWriterVersion)version), OrcMetadataReader.maxStringTruncateToValidRange((Slice)max, (PostScript.HiveWriterVersion)version), (long)sum);
    }

    @DataProvider
    public Object[][] columnStatisticsSupplier() {
        IntegerColumnStatistics integerColumnStatistics1 = new IntegerColumnStatistics(Long.valueOf(7L), null, new IntegerStatistics(Long.valueOf(25L), Long.valueOf(95L), Long.valueOf(100L)));
        IntegerColumnStatistics integerColumnStatistics2 = new IntegerColumnStatistics(Long.valueOf(9L), null, new IntegerStatistics(Long.valueOf(12L), Long.valueOf(22L), Long.valueOf(32L)));
        MapColumnStatisticsBuilder mapStatsIntKeyBuilder = new MapColumnStatisticsBuilder(true);
        mapStatsIntKeyBuilder.addMapStatistics(DwrfProto.KeyInfo.newBuilder().setIntKey(2L).build(), (ColumnStatistics)integerColumnStatistics1);
        mapStatsIntKeyBuilder.addMapStatistics(DwrfProto.KeyInfo.newBuilder().setIntKey(3L).build(), (ColumnStatistics)integerColumnStatistics2);
        mapStatsIntKeyBuilder.increaseValueCount(23L);
        ColumnStatistics mapColumnStatisticsIntKey = mapStatsIntKeyBuilder.buildColumnStatistics();
        MapColumnStatisticsBuilder mapStatsStringKeyBuilder = new MapColumnStatisticsBuilder(true);
        mapStatsStringKeyBuilder.addMapStatistics(DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"k1")).build(), (ColumnStatistics)integerColumnStatistics1);
        mapStatsStringKeyBuilder.addMapStatistics(DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"k2")).build(), (ColumnStatistics)integerColumnStatistics2);
        mapStatsStringKeyBuilder.increaseValueCount(23L);
        ColumnStatistics mapColumnStatisticsStringKey = mapStatsStringKeyBuilder.buildColumnStatistics();
        ColumnStatistics expectedDisabledMapStats = new ColumnStatistics(Long.valueOf(23L), null);
        OrcReaderOptions orcReaderOptionsDisabledMapStats = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withReadMapStatistics(false).build();
        DwrfMetadataReader dwrfMetadataReaderDisabledMapStats = new DwrfMetadataReader(new RuntimeStats(), orcReaderOptionsDisabledMapStats);
        return new Object[][]{{integerColumnStatistics1, integerColumnStatistics1, this.dwrfMetadataReader}, {integerColumnStatistics1, integerColumnStatistics1, dwrfMetadataReaderDisabledMapStats}, {mapColumnStatisticsIntKey, mapColumnStatisticsIntKey, this.dwrfMetadataReader}, {mapColumnStatisticsIntKey, expectedDisabledMapStats, dwrfMetadataReaderDisabledMapStats}, {mapColumnStatisticsStringKey, mapColumnStatisticsStringKey, this.dwrfMetadataReader}, {mapColumnStatisticsStringKey, expectedDisabledMapStats, dwrfMetadataReaderDisabledMapStats}};
    }

    @Test(dataProvider="columnStatisticsSupplier")
    public void testToColumnStatisticsRoundtrip(ColumnStatistics input, ColumnStatistics output, DwrfMetadataReader dwrfMetadataReader) {
        DwrfProto.ColumnStatistics dwrfColumnStatistics = DwrfMetadataWriter.toColumnStatistics((ColumnStatistics)input);
        ColumnStatistics actual = dwrfMetadataReader.toColumnStatistics(PostScript.HiveWriterVersion.ORC_HIVE_8732, dwrfColumnStatistics, false, null);
        Assert.assertEquals((Object)actual, (Object)output);
    }
}

