/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDwrfMetadataWriter {
    private static final int COLUMN_ID = 3;

    @Test
    public void testToColumnEncodingDirect() {
        int expectedDictionarySize = 0;
        ColumnEncoding columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, expectedDictionarySize);
        DwrfProto.ColumnEncoding actual = DwrfMetadataWriter.toColumnEncoding((int)3, (ColumnEncoding)columnEncoding);
        Assert.assertEquals((int)actual.getColumn(), (int)3);
        Assert.assertEquals((Object)actual.getKind(), (Object)DwrfProto.ColumnEncoding.Kind.DIRECT);
        Assert.assertEquals((int)actual.getDictionarySize(), (int)expectedDictionarySize);
        Assert.assertEquals((int)actual.getSequence(), (int)0);
    }

    @Test
    public void testToColumnEncodingDictionary() {
        int expectedDictionarySize = 5;
        ColumnEncoding columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DICTIONARY, expectedDictionarySize);
        DwrfProto.ColumnEncoding actual = DwrfMetadataWriter.toColumnEncoding((int)3, (ColumnEncoding)columnEncoding);
        Assert.assertEquals((int)actual.getColumn(), (int)3);
        Assert.assertEquals((Object)actual.getKind(), (Object)DwrfProto.ColumnEncoding.Kind.DICTIONARY);
        Assert.assertEquals((int)actual.getDictionarySize(), (int)expectedDictionarySize);
        Assert.assertEquals((int)actual.getSequence(), (int)0);
    }

    @Test
    public void testToColumnEncodingFlatMap() {
        int expectedDictionarySize = 0;
        ColumnEncoding columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT, expectedDictionarySize);
        DwrfProto.ColumnEncoding actual = DwrfMetadataWriter.toColumnEncoding((int)3, (ColumnEncoding)columnEncoding);
        Assert.assertEquals((int)actual.getColumn(), (int)3);
        Assert.assertEquals((Object)actual.getKind(), (Object)DwrfProto.ColumnEncoding.Kind.MAP_FLAT);
        Assert.assertEquals((int)actual.getDictionarySize(), (int)expectedDictionarySize);
        Assert.assertEquals((int)actual.getSequence(), (int)0);
    }

    @DataProvider
    public static Object[][] sequenceKeyProvider() {
        return new Object[][]{{DwrfProto.KeyInfo.newBuilder().setIntKey(1L).build(), DwrfProto.KeyInfo.newBuilder().setIntKey(5L).build()}, {DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"key1")).build(), DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"key2")).build()}};
    }

    @Test(dataProvider="sequenceKeyProvider")
    public void testToColumnEncodingsWithSequence(DwrfProto.KeyInfo key1, DwrfProto.KeyInfo key2) {
        int expectedDictionarySize1 = 5;
        int expectedSequenceId1 = 0;
        ColumnEncoding valueEncoding1 = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, expectedDictionarySize1);
        DwrfSequenceEncoding sequenceEncoding1 = new DwrfSequenceEncoding(key1, valueEncoding1);
        int expectedDictionarySize2 = 10;
        int expectedSequenceId2 = 5;
        ColumnEncoding valueEncoding2 = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DICTIONARY, expectedDictionarySize2);
        DwrfSequenceEncoding sequenceEncoding2 = new DwrfSequenceEncoding(key2, valueEncoding2);
        ImmutableSortedMap additionalSequenceEncodings = ImmutableSortedMap.of((Comparable)Integer.valueOf(expectedSequenceId1), (Object)sequenceEncoding1, (Comparable)Integer.valueOf(expectedSequenceId2), (Object)sequenceEncoding2);
        ColumnEncoding columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, Optional.of(additionalSequenceEncodings));
        List actual = DwrfMetadataWriter.toColumnEncodings((Map)ImmutableMap.of((Object)3, (Object)columnEncoding));
        Assert.assertEquals((int)actual.size(), (int)2);
        DwrfProto.ColumnEncoding actualValueEncoding1 = (DwrfProto.ColumnEncoding)actual.get(0);
        Assert.assertEquals((int)actualValueEncoding1.getColumn(), (int)3);
        Assert.assertEquals((Object)actualValueEncoding1.getKind(), (Object)DwrfProto.ColumnEncoding.Kind.DIRECT);
        Assert.assertEquals((int)actualValueEncoding1.getDictionarySize(), (int)expectedDictionarySize1);
        Assert.assertEquals((int)actualValueEncoding1.getSequence(), (int)expectedSequenceId1);
        Assert.assertEquals((Object)actualValueEncoding1.getKey(), (Object)key1);
        DwrfProto.ColumnEncoding actualValueEncoding2 = (DwrfProto.ColumnEncoding)actual.get(1);
        Assert.assertEquals((int)actualValueEncoding2.getColumn(), (int)3);
        Assert.assertEquals((Object)actualValueEncoding2.getKind(), (Object)DwrfProto.ColumnEncoding.Kind.DICTIONARY);
        Assert.assertEquals((int)actualValueEncoding2.getDictionarySize(), (int)expectedDictionarySize2);
        Assert.assertEquals((int)actualValueEncoding2.getSequence(), (int)expectedSequenceId2);
        Assert.assertEquals((Object)actualValueEncoding2.getKey(), (Object)key2);
    }

    @Test
    public void testToColumnEncodingsWithInvalidDeeplyNestedAdditionalSequence() {
        DwrfProto.KeyInfo key1 = DwrfProto.KeyInfo.newBuilder().setIntKey(1L).build();
        DwrfProto.KeyInfo key2 = DwrfProto.KeyInfo.newBuilder().setIntKey(2L).build();
        ColumnEncoding deeplyNestedValueEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
        DwrfSequenceEncoding deeplyNestedSequenceEncoding = new DwrfSequenceEncoding(key1, deeplyNestedValueEncoding);
        ImmutableSortedMap deeplyNestedSequenceEncodings = ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)deeplyNestedSequenceEncoding);
        ColumnEncoding nestedColumnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, Optional.of(deeplyNestedSequenceEncodings));
        DwrfSequenceEncoding nestedSequenceEncoding = new DwrfSequenceEncoding(key2, nestedColumnEncoding);
        ImmutableSortedMap nestedSequenceEncodings = ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)nestedSequenceEncoding);
        ColumnEncoding columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0, Optional.of(nestedSequenceEncodings));
        Assert.expectThrows(IllegalArgumentException.class, () -> DwrfMetadataWriter.toColumnEncodings((Map)ImmutableMap.of((Object)3, (Object)columnEncoding)));
    }

    @Test
    public void testToStreamKind() {
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.PRESENT), (Object)DwrfProto.Stream.Kind.PRESENT);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.IN_MAP), (Object)DwrfProto.Stream.Kind.IN_MAP);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.DATA), (Object)DwrfProto.Stream.Kind.DATA);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.SECONDARY), (Object)DwrfProto.Stream.Kind.NANO_DATA);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.LENGTH), (Object)DwrfProto.Stream.Kind.LENGTH);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.DICTIONARY_DATA), (Object)DwrfProto.Stream.Kind.DICTIONARY_DATA);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.DICTIONARY_COUNT), (Object)DwrfProto.Stream.Kind.DICTIONARY_COUNT);
        Assert.assertEquals((Object)DwrfMetadataWriter.toStreamKind((Stream.StreamKind)Stream.StreamKind.ROW_INDEX), (Object)DwrfProto.Stream.Kind.ROW_INDEX);
    }

    @Test
    public void testToStream() {
        int expectedSequence = 10;
        int expectedLength = 15;
        long expectedOffset = 25L;
        boolean expectedUseVints = true;
        Stream stream = new Stream(3, expectedSequence, Stream.StreamKind.DATA, expectedLength, expectedUseVints);
        DwrfProto.Stream actual = DwrfMetadataWriter.toStream((Stream)stream);
        Assert.assertEquals((int)actual.getColumn(), (int)3);
        Assert.assertEquals((int)actual.getSequence(), (int)expectedSequence);
        Assert.assertEquals((Object)actual.getKind(), (Object)DwrfProto.Stream.Kind.DATA);
        Assert.assertEquals((long)actual.getLength(), (long)expectedLength);
        Assert.assertTrue((boolean)actual.getUseVInts());
        Assert.assertFalse((boolean)actual.hasOffset());
        stream = new Stream(3, Stream.StreamKind.DATA, expectedLength, expectedUseVints, expectedSequence, Optional.of(expectedOffset));
        actual = DwrfMetadataWriter.toStream((Stream)stream);
        Assert.assertEquals((int)actual.getColumn(), (int)3);
        Assert.assertEquals((int)actual.getSequence(), (int)expectedSequence);
        Assert.assertEquals((Object)actual.getKind(), (Object)DwrfProto.Stream.Kind.DATA);
        Assert.assertEquals((long)actual.getLength(), (long)expectedLength);
        Assert.assertTrue((boolean)actual.getUseVInts());
        Assert.assertEquals((long)actual.getOffset(), (long)expectedOffset);
    }
}

