/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.proto.OrcProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcMetadataReader {
    private static final Slice STRING_APPLE = Slices.utf8Slice((String)"apple");
    private static final Slice STRING_OESTERREICH = Slices.utf8Slice((String)"\u00d6sterreich");
    private static final Slice STRING_DULIOE_DULIOE = Slices.utf8Slice((String)"Duli\u00f6 duli\u00f6");
    private static final Slice STRING_FAITH_HOPE_LOVE = Slices.utf8Slice((String)"\u4fe1\u5ff5,\u7231,\u5e0c\u671b");
    private static final Slice STRING_NAIVE = Slices.utf8Slice((String)"na\u00efve");
    private static final Slice STRING_OO = Slices.utf8Slice((String)"\ud801\udc2dend");
    private static final Slice INVALID_SEQUENCE_TO_LOWER_EXPANDS = Slices.wrappedBuffer((byte[])new byte[]{-56, -70, -1});
    private static final Slice INVALID_UTF8_1 = Slices.wrappedBuffer((byte[])new byte[]{-127});
    private static final Slice INVALID_UTF8_2 = Slices.wrappedBuffer((byte[])new byte[]{50, -127, 52, 50});
    private static final byte CONTINUATION_BYTE = -65;
    private static final Slice EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE = Slices.wrappedBuffer((byte[])new byte[]{-65, -30, -128, -125, -65});
    private static final List<Slice> VALID_UTF8_SEQUENCES = ImmutableList.builder().add((Object)STRING_OO).add((Object)Slices.EMPTY_SLICE).add((Object)STRING_APPLE).add((Object)STRING_OESTERREICH).add((Object)STRING_DULIOE_DULIOE).add((Object)STRING_FAITH_HOPE_LOVE).add((Object)STRING_NAIVE).add((Object)STRING_OO).build();
    private static final List<Slice> INVALID_UTF8_SEQUENCES = ImmutableList.builder().add((Object)INVALID_SEQUENCE_TO_LOWER_EXPANDS).add((Object)INVALID_UTF8_1).add((Object)INVALID_UTF8_2).add((Object)EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE).build();
    static final List<Slice> ALL_UTF8_SEQUENCES = ImmutableList.builder().addAll(VALID_UTF8_SEQUENCES).addAll(INVALID_UTF8_SEQUENCES).build();
    private static final int REPLACEMENT_CHARACTER_CODE_POINT = 65533;
    static final List<Integer> TEST_CODE_POINTS = ImmutableList.builder().add((Object)0).add((Object)97).add((Object)192).add((Object)193).add((Object)239).add((Object)254).add((Object)255).add((Object)65532).add((Object)65533).add((Object)65534).add((Object)65535).add((Object)66565).build();

    @Test
    public void testGetMinSlice() {
        int startCodePoint = 0;
        int endCodePoint = 0x10FFFF;
        Slice minSlice = Slices.utf8Slice((String)"");
        for (int codePoint = startCodePoint; codePoint < endCodePoint; ++codePoint) {
            if (55296 <= codePoint && codePoint <= 57343) continue;
            Slice value = SliceUtf8.codePointToUtf8((int)codePoint);
            if (OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter((Slice)value) == value.length()) {
                Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)value);
                continue;
            }
            Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)minSlice);
        }
        Slice prefix = Slices.utf8Slice((String)"apple");
        for (int codePoint = startCodePoint; codePoint < endCodePoint; ++codePoint) {
            if (55296 <= codePoint && codePoint <= 57343) continue;
            Slice value = TestOrcMetadataReader.concatSlice(prefix, SliceUtf8.codePointToUtf8((int)codePoint));
            if (OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter((Slice)value) == value.length()) {
                Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)value);
                continue;
            }
            Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)prefix);
        }
    }

    @Test
    public void testGetMaxSlice() {
        int startCodePoint = 0;
        int endCodePoint = 0x10FFFF;
        Slice maxByte = Slices.wrappedBuffer((byte[])new byte[]{-1});
        for (int codePoint = startCodePoint; codePoint < endCodePoint; ++codePoint) {
            if (55296 <= codePoint && codePoint <= 57343) continue;
            Slice value = SliceUtf8.codePointToUtf8((int)codePoint);
            if (OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter((Slice)value) == value.length()) {
                Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)value);
                continue;
            }
            Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)maxByte);
        }
        Slice prefix = Slices.utf8Slice((String)"apple");
        Slice maxSlice = TestOrcMetadataReader.concatSlice(prefix, maxByte);
        for (int codePoint = startCodePoint; codePoint < endCodePoint; ++codePoint) {
            if (55296 <= codePoint && codePoint <= 57343) continue;
            Slice value = TestOrcMetadataReader.concatSlice(prefix, SliceUtf8.codePointToUtf8((int)codePoint));
            if (OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter((Slice)value) == value.length()) {
                Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)value);
                continue;
            }
            Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)maxSlice);
        }
    }

    @Test
    public void testToStringStatistics() {
        Assert.assertNull((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMinimum("ant").setMaximum("cat").setSum(44L).build(), (boolean)false));
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)true, (Object)false).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean isRowGroup = (Boolean)unmodifiableIterator.next();
            Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setSum(45L).build(), (boolean)isRowGroup), (Object)new StringStatistics(null, null, 45L));
        }
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setSum(45L).build(), (boolean)true), (Object)new StringStatistics(null, null, 45L));
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMinimum("ant").build(), (boolean)true), (Object)new StringStatistics(Slices.utf8Slice((String)"ant"), null, 0L));
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMaximum("cat").build(), (boolean)true), (Object)new StringStatistics(null, Slices.utf8Slice((String)"cat"), 0L));
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMinimum("ant").setMaximum("cat").setSum(79L).build(), (boolean)true), (Object)new StringStatistics(Slices.utf8Slice((String)"ant"), Slices.utf8Slice((String)"cat"), 79L));
        for (Slice prefix : ALL_UTF8_SEQUENCES) {
            for (int testCodePoint : TEST_CODE_POINTS) {
                Slice codePoint = SliceUtf8.codePointToUtf8((int)testCodePoint);
                for (Slice suffix : ALL_UTF8_SEQUENCES) {
                    Slice testValue = TestOrcMetadataReader.concatSlice(prefix, codePoint, suffix);
                    TestOrcMetadataReader.testStringStatisticsTruncation(testValue, PostScript.HiveWriterVersion.ORIGINAL);
                    TestOrcMetadataReader.testStringStatisticsTruncation(testValue, PostScript.HiveWriterVersion.ORC_HIVE_8732);
                }
            }
        }
    }

    private static void testStringStatisticsTruncation(Slice testValue, PostScript.HiveWriterVersion version) {
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)version, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMinimumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setMaximumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setSum(79L).build(), (boolean)true), (Object)TestOrcMetadataReader.createExpectedStringStatistics(version, testValue, testValue, 79));
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)version, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMinimumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setSum(79L).build(), (boolean)true), (Object)TestOrcMetadataReader.createExpectedStringStatistics(version, testValue, null, 79));
        Assert.assertEquals((Object)OrcMetadataReader.toStringStatistics((PostScript.HiveWriterVersion)version, (OrcProto.StringStatistics)OrcProto.StringStatistics.newBuilder().setMaximumBytes(ByteString.copyFrom((byte[])testValue.getBytes())).setSum(79L).build(), (boolean)true), (Object)TestOrcMetadataReader.createExpectedStringStatistics(version, null, testValue, 79));
    }

    private static StringStatistics createExpectedStringStatistics(PostScript.HiveWriterVersion version, Slice min, Slice max, int sum) {
        return new StringStatistics(OrcMetadataReader.minStringTruncateToValidRange((Slice)min, (PostScript.HiveWriterVersion)version), OrcMetadataReader.maxStringTruncateToValidRange((Slice)max, (PostScript.HiveWriterVersion)version), (long)sum);
    }

    @Test
    public void testMinStringTruncateAtFirstReplacementCharacter() {
        for (Slice prefix : VALID_UTF8_SEQUENCES) {
            for (Slice suffix : VALID_UTF8_SEQUENCES) {
                TestOrcMetadataReader.testMinStringTruncateAtFirstReplacementCharacter(prefix, suffix);
            }
        }
    }

    private static void testMinStringTruncateAtFirstReplacementCharacter(Slice prefix, Slice suffix) {
        for (int testCodePoint : TEST_CODE_POINTS) {
            Slice codePoint = SliceUtf8.codePointToUtf8((int)testCodePoint);
            Slice value = TestOrcMetadataReader.concatSlice(prefix, codePoint, suffix);
            Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732), (Object)value);
            if (!prefix.equals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)prefix, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL))) continue;
            if (testCodePoint == 65533 || testCodePoint >= 65536) {
                Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)prefix);
                continue;
            }
            Assert.assertEquals((Object)OrcMetadataReader.minStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)TestOrcMetadataReader.concatSlice(prefix, codePoint, OrcMetadataReader.minStringTruncateToValidRange((Slice)suffix, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL)));
        }
    }

    @Test
    public void testMaxStringTruncateAtFirstReplacementCharacter() {
        for (Slice prefix : VALID_UTF8_SEQUENCES) {
            for (Slice suffix : VALID_UTF8_SEQUENCES) {
                TestOrcMetadataReader.testMaxStringTruncateAtFirstReplacementCharacter(prefix, suffix);
            }
        }
    }

    private static void testMaxStringTruncateAtFirstReplacementCharacter(Slice prefix, Slice suffix) {
        for (int testCodePoint : TEST_CODE_POINTS) {
            Slice codePoint = SliceUtf8.codePointToUtf8((int)testCodePoint);
            Slice value = TestOrcMetadataReader.concatSlice(prefix, codePoint, suffix);
            Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORC_HIVE_8732), (Object)value);
            if (!prefix.equals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)prefix, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL))) continue;
            if (testCodePoint == 65533 || testCodePoint >= 65536) {
                Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)TestOrcMetadataReader.concatSlice(prefix, Slices.wrappedBuffer((byte[])new byte[]{-1})));
                continue;
            }
            Assert.assertEquals((Object)OrcMetadataReader.maxStringTruncateToValidRange((Slice)value, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL), (Object)TestOrcMetadataReader.concatSlice(prefix, codePoint, OrcMetadataReader.maxStringTruncateToValidRange((Slice)suffix, (PostScript.HiveWriterVersion)PostScript.HiveWriterVersion.ORIGINAL)));
        }
    }

    static Slice concatSlice(Slice ... slices) {
        int totalLength = Arrays.stream(slices).mapToInt(Slice::length).sum();
        Slice value = Slices.allocate((int)totalLength);
        SliceOutput output = value.getOutput();
        for (Slice slice : slices) {
            output.writeBytes(slice);
        }
        return value;
    }
}

