/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcType {
    @Test
    public void testMapColumnToNodeSimpleTypes() {
        ImmutableList columnNames = ImmutableList.of((Object)"f1", (Object)"f2", (Object)"f3");
        ImmutableList columnTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        List orcTypes = OrcType.createOrcRowType((int)0, (List)columnNames, (List)columnTypes);
        Set actual = OrcType.mapColumnToNode((Set)ImmutableSet.of((Object)0, (Object)2), (List)orcTypes);
        ImmutableSet expected = ImmutableSet.of((Object)1, (Object)3);
        Assert.assertEquals((Set)actual, (Set)expected);
    }

    @Test
    public void testMapColumnToNodeNestedTypes() {
        ImmutableList columnNames = ImmutableList.of((Object)"f1", (Object)"f2", (Object)"f3");
        ImmutableList columnTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), (Object)VarcharType.VARCHAR);
        List orcTypes = OrcType.createOrcRowType((int)0, (List)columnNames, (List)columnTypes);
        Set actual = OrcType.mapColumnToNode((Set)ImmutableSet.of((Object)0, (Object)2), (List)orcTypes);
        ImmutableSet expected = ImmutableSet.of((Object)1, (Object)5);
        Assert.assertEquals((Set)actual, (Set)expected);
        actual = OrcType.mapColumnToNode((Set)ImmutableSet.of((Object)1), (List)orcTypes);
        expected = ImmutableSet.of((Object)2);
        Assert.assertEquals((Set)actual, (Set)expected);
    }

    @Test
    public void testMapColumnToNodeEmpty() {
        Set actual = OrcType.mapColumnToNode((Set)ImmutableSet.of(), (List)ImmutableList.of());
        Assert.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void testMapColumnToNodeIgnoreMissingColumns() {
        ImmutableList columnNames = ImmutableList.of((Object)"f1");
        ImmutableList columnTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        List orcTypes = OrcType.createOrcRowType((int)0, (List)columnNames, (List)columnTypes);
        Set actual = OrcType.mapColumnToNode((Set)ImmutableSet.of((Object)0, (Object)100, (Object)200), (List)orcTypes);
        ImmutableSet expected = ImmutableSet.of((Object)1);
        Assert.assertEquals((Set)actual, (Set)expected);
    }

    @Test
    public void testCreateNodeIdToColumnIdMapWithMultipleColumns() {
        ImmutableList columnNames = ImmutableList.of((Object)"f1", (Object)"f2", (Object)"f3", (Object)"f4");
        ImmutableList columnTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), (Object)VarcharType.VARCHAR, (Object)OrcTester.mapType((Type)VarcharType.VARCHAR, OrcTester.arrayType((Type)VarcharType.VARCHAR)));
        List orcTypes = OrcType.createOrcRowType((int)0, (List)columnNames, (List)columnTypes);
        Map actual = OrcType.createNodeIdToColumnMap((List)orcTypes);
        ImmutableMap expected = ImmutableMap.builder().put((Object)1, (Object)0).put((Object)2, (Object)1).put((Object)3, (Object)1).put((Object)4, (Object)1).put((Object)5, (Object)2).put((Object)6, (Object)3).put((Object)7, (Object)3).put((Object)8, (Object)3).put((Object)9, (Object)3).build();
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testCreateNodeIdToColumnIdMapWithSingleColumn() {
        ImmutableList columnNames = ImmutableList.of((Object)"f1");
        ImmutableList columnTypes = ImmutableList.of((Object)OrcTester.mapType((Type)VarcharType.VARCHAR, OrcTester.arrayType((Type)VarcharType.VARCHAR)));
        List orcTypes = OrcType.createOrcRowType((int)0, (List)columnNames, (List)columnTypes);
        Map actual = OrcType.createNodeIdToColumnMap((List)orcTypes);
        ImmutableMap expected = ImmutableMap.builder().put((Object)1, (Object)0).put((Object)2, (Object)0).put((Object)3, (Object)0).put((Object)4, (Object)0).build();
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testCreateNodeIdToColumnIdMapWithNoColumn() {
        List orcTypes = OrcType.createOrcRowType((int)0, (List)ImmutableList.of(), (List)ImmutableList.of());
        Map actual = OrcType.createNodeIdToColumnMap((List)orcTypes);
        ImmutableMap expected = ImmutableMap.of();
        Assert.assertEquals((Map)actual, (Map)expected);
    }
}

