/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import org.testng.Assert;

public abstract class AbstractRangeStatisticsTest<R extends RangeStatistics<T>, T> {
    protected abstract R getCreateStatistics(T var1, T var2);

    protected void assertMinMax(T min, T max) {
        this.assertMinMaxStatistics(min, min);
        this.assertMinMaxStatistics(max, max);
        this.assertMinMaxStatistics(min, max);
        this.assertMinMaxStatistics(min, null);
        this.assertMinMaxStatistics(null, max);
        if (!min.equals(max)) {
            Assert.assertThrows(() -> this.getCreateStatistics(max, min));
        }
    }

    void assertRetainedSize(T min, T max, long expectedSizeInBytes) {
        Assert.assertEquals((long)this.getCreateStatistics(min, max).getRetainedSizeInBytes(), (long)expectedSizeInBytes);
    }

    private void assertMinMaxStatistics(T min, T max) {
        R statistics = this.getCreateStatistics(min, max);
        Assert.assertEquals((Object)statistics.getMin(), min);
        Assert.assertEquals((Object)statistics.getMax(), max);
        Assert.assertEquals(statistics, statistics);
        Assert.assertEquals((int)statistics.hashCode(), (int)statistics.hashCode());
    }
}

