/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractStatisticsBuilderTest<B extends StatisticsBuilder, T> {
    private final StatisticsType statisticsType;
    private final Supplier<B> statisticsBuilderSupplier;
    private final BiConsumer<B, T> adder;

    public AbstractStatisticsBuilderTest(StatisticsType statisticsType, Supplier<B> statisticsBuilderSupplier, BiConsumer<B, T> adder) {
        this.statisticsType = statisticsType;
        this.statisticsBuilderSupplier = statisticsBuilderSupplier;
        this.adder = adder;
    }

    @Test
    public void testNoValue() {
        StatisticsBuilder statisticsBuilder = (StatisticsBuilder)this.statisticsBuilderSupplier.get();
        AggregateColumnStatistics aggregateColumnStatistics = new AggregateColumnStatistics();
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 0);
        aggregateColumnStatistics.add(statisticsBuilder.buildColumnStatistics());
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(aggregateColumnStatistics.getMergedColumnStatistics(Optional.empty()), 0);
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 0);
        aggregateColumnStatistics.add(statisticsBuilder.buildColumnStatistics());
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(aggregateColumnStatistics.getMergedColumnStatistics(Optional.empty()), 0);
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 0);
        aggregateColumnStatistics.add(statisticsBuilder.buildColumnStatistics());
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(aggregateColumnStatistics.getMergedColumnStatistics(Optional.empty()), 0);
    }

    public void assertTotalValueBytes(long expectedTotalValueBytes, List<T> values) {
        StatisticsBuilder statisticsBuilder = (StatisticsBuilder)this.statisticsBuilderSupplier.get();
        for (T value : values) {
            this.adder.accept((B)statisticsBuilder, (StatisticsBuilder)value);
        }
        Assert.assertEquals((long)statisticsBuilder.buildColumnStatistics().getTotalValueSizeInBytes(), (long)expectedTotalValueBytes);
        statisticsBuilder = (StatisticsBuilder)this.statisticsBuilderSupplier.get();
        for (int i = 0; i < values.size() / 2; ++i) {
            this.adder.accept((B)statisticsBuilder, (StatisticsBuilder)values.get(i));
        }
        ColumnStatistics firstStats = statisticsBuilder.buildColumnStatistics();
        statisticsBuilder = (StatisticsBuilder)this.statisticsBuilderSupplier.get();
        for (int i = values.size() / 2; i < values.size(); ++i) {
            this.adder.accept((B)statisticsBuilder, (StatisticsBuilder)values.get(i));
        }
        ColumnStatistics secondStats = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)ColumnStatistics.mergeColumnStatistics((List)ImmutableList.of((Object)firstStats, (Object)secondStats)).getTotalValueSizeInBytes(), (long)expectedTotalValueBytes);
    }

    public void assertMinMaxValues(T expectedMin, T expectedMax) {
        this.assertValues(expectedMin, expectedMin, (List<T>)ImmutableList.of(expectedMin));
        this.assertValues(expectedMax, expectedMax, (List<T>)ImmutableList.of(expectedMax));
        this.assertValues(expectedMin, expectedMax, (List<T>)ImmutableList.of(expectedMin, expectedMax));
    }

    public void assertValues(T expectedMin, T expectedMax, List<T> values) {
        this.assertValuesInternal(expectedMin, expectedMax, values);
        this.assertValuesInternal(expectedMin, expectedMax, (List<T>)ImmutableList.copyOf(values).reverse());
        ArrayList<T> randomOrder = new ArrayList<T>(values);
        Collections.shuffle(randomOrder, new Random(42L));
        this.assertValuesInternal(expectedMin, expectedMax, randomOrder);
    }

    private void assertValuesInternal(T expectedMin, T expectedMax, List<T> values) {
        StatisticsBuilder statisticsBuilder = (StatisticsBuilder)this.statisticsBuilderSupplier.get();
        AggregateColumnStatistics aggregateColumnStatistics = new AggregateColumnStatistics();
        aggregateColumnStatistics.add(statisticsBuilder.buildColumnStatistics());
        this.assertColumnStatistics(statisticsBuilder.buildColumnStatistics(), 0, null, null, aggregateColumnStatistics);
        for (int loop = 0; loop < 4; ++loop) {
            for (T value : values) {
                this.adder.accept((B)statisticsBuilder, (StatisticsBuilder)value);
                aggregateColumnStatistics.add(statisticsBuilder.buildColumnStatistics());
            }
            this.assertColumnStatistics(statisticsBuilder.buildColumnStatistics(), values.size() * (loop + 1), expectedMin, expectedMax, aggregateColumnStatistics);
        }
    }

    public static void assertNoColumnStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues) {
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)expectedNumberOfValues);
        Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
        Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
        Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
        Assert.assertNull((Object)columnStatistics.getStringStatistics());
        Assert.assertNull((Object)columnStatistics.getDateStatistics());
        Assert.assertNull((Object)columnStatistics.getDecimalStatistics());
        Assert.assertNull((Object)columnStatistics.getBloomFilter());
    }

    private void assertColumnStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues, T expectedMin, T expectedMax, AggregateColumnStatistics aggregateColumnStatistics) {
        this.assertColumnStatistics(columnStatistics, expectedNumberOfValues, expectedMin, expectedMax);
        int totalCount = aggregateColumnStatistics.getTotalCount();
        this.assertColumnStatistics(aggregateColumnStatistics.getMergedColumnStatistics(Optional.empty()), totalCount, expectedMin, expectedMax);
        this.assertColumnStatistics(aggregateColumnStatistics.getMergedColumnStatisticsPairwise(Optional.empty()), totalCount, expectedMin, expectedMax);
        for (int i = 0; i < 10; ++i) {
            this.assertColumnStatistics(aggregateColumnStatistics.getMergedColumnStatistics(Optional.of(ThreadLocalRandom.current())), totalCount, expectedMin, expectedMax);
            this.assertColumnStatistics(aggregateColumnStatistics.getMergedColumnStatisticsPairwise(Optional.of(ThreadLocalRandom.current())), totalCount, expectedMin, expectedMax);
        }
        List<ColumnStatistics> statisticsList = aggregateColumnStatistics.getStatisticsList();
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(AbstractStatisticsBuilderTest.insertEmptyColumnStatisticsAt(statisticsList, 0, 10L)), totalCount + 10);
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(AbstractStatisticsBuilderTest.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size(), 10L)), totalCount + 10);
        AbstractStatisticsBuilderTest.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(AbstractStatisticsBuilderTest.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size() / 2, 10L)), totalCount + 10);
    }

    static List<ColumnStatistics> insertEmptyColumnStatisticsAt(List<ColumnStatistics> statisticsList, int index, long numberOfValues) {
        ArrayList<ColumnStatistics> newStatisticsList = new ArrayList<ColumnStatistics>(statisticsList);
        newStatisticsList.add(index, new ColumnStatistics(Long.valueOf(numberOfValues), null));
        return newStatisticsList;
    }

    public void assertColumnStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues, T expectedMin, T expectedMax) {
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)expectedNumberOfValues);
        if (this.statisticsType == StatisticsType.BOOLEAN && expectedNumberOfValues > 0) {
            Assert.assertNotNull((Object)columnStatistics.getBooleanStatistics());
        } else {
            Assert.assertNull((Object)columnStatistics.getBooleanStatistics());
        }
        if (this.statisticsType == StatisticsType.INTEGER && expectedNumberOfValues > 0) {
            this.assertRangeStatistics((RangeStatistics<?>)columnStatistics.getIntegerStatistics(), expectedMin, expectedMax);
        } else {
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
        }
        if (this.statisticsType == StatisticsType.DOUBLE && expectedNumberOfValues > 0) {
            this.assertRangeStatistics((RangeStatistics<?>)columnStatistics.getDoubleStatistics(), expectedMin, expectedMax);
        } else {
            Assert.assertNull((Object)columnStatistics.getDoubleStatistics());
        }
        if (this.statisticsType == StatisticsType.STRING && expectedNumberOfValues > 0) {
            this.assertRangeStatistics((RangeStatistics<?>)columnStatistics.getStringStatistics(), expectedMin, expectedMax);
        } else {
            Assert.assertNull((Object)columnStatistics.getStringStatistics());
        }
        if (this.statisticsType == StatisticsType.DATE && expectedNumberOfValues > 0) {
            this.assertRangeStatistics((RangeStatistics<?>)columnStatistics.getDateStatistics(), expectedMin, expectedMax);
        } else {
            Assert.assertNull((Object)columnStatistics.getDateStatistics());
        }
        if (this.statisticsType == StatisticsType.DECIMAL && expectedNumberOfValues > 0) {
            this.assertRangeStatistics((RangeStatistics<?>)columnStatistics.getDecimalStatistics(), expectedMin, expectedMax);
        } else {
            Assert.assertNull((Object)columnStatistics.getDecimalStatistics());
        }
        Assert.assertNull((Object)columnStatistics.getBloomFilter());
    }

    void assertRangeStatistics(RangeStatistics<?> rangeStatistics, T expectedMin, T expectedMax) {
        Assert.assertNotNull(rangeStatistics);
        Assert.assertEquals((Object)rangeStatistics.getMin(), expectedMin);
        Assert.assertEquals((Object)rangeStatistics.getMax(), expectedMax);
    }

    public static class AggregateColumnStatistics {
        private int totalCount;
        private final ImmutableList.Builder<ColumnStatistics> statisticsList = ImmutableList.builder();

        public void add(ColumnStatistics columnStatistics) {
            this.totalCount = (int)((long)this.totalCount + columnStatistics.getNumberOfValues());
            this.statisticsList.add((Object)columnStatistics);
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public List<ColumnStatistics> getStatisticsList() {
            return this.statisticsList.build();
        }

        public ColumnStatistics getMergedColumnStatistics(Optional<Random> random) {
            ArrayList statistics = new ArrayList(this.statisticsList.build());
            random.ifPresent(rand -> Collections.shuffle(statistics, rand));
            return ColumnStatistics.mergeColumnStatistics((List)ImmutableList.copyOf(statistics));
        }

        public ColumnStatistics getMergedColumnStatisticsPairwise(Optional<Random> random) {
            ArrayList statistics = new ArrayList(this.statisticsList.build());
            random.ifPresent(rand -> Collections.shuffle(statistics, rand));
            return AggregateColumnStatistics.getMergedColumnStatisticsPairwise((List<ColumnStatistics>)ImmutableList.copyOf(statistics));
        }

        private static ColumnStatistics getMergedColumnStatisticsPairwise(List<ColumnStatistics> statistics) {
            while (statistics.size() > 1) {
                ImmutableList.Builder mergedStatistics = ImmutableList.builder();
                for (int i = 0; i < statistics.size(); i += 2) {
                    mergedStatistics.add((Object)ColumnStatistics.mergeColumnStatistics(statistics.subList(i, Math.min(i + 2, statistics.size()))));
                }
                statistics = mergedStatistics.build();
            }
            return statistics.get(0);
        }
    }

    public static enum StatisticsType {
        NONE,
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING,
        DATE,
        DECIMAL;

    }
}

