/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBinaryStatisticsBuilder
extends AbstractStatisticsBuilderTest<BinaryStatisticsBuilder, Slice> {
    private static final Slice FIRST_VALUE = Slices.utf8Slice((String)"apple");
    private static final Slice SECOND_VALUE = Slices.utf8Slice((String)"banana");

    public TestBinaryStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.NONE, BinaryStatisticsBuilder::new, TestBinaryStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(Slices.EMPTY_SLICE, Slices.EMPTY_SLICE);
        this.assertMinMaxValues(FIRST_VALUE, SECOND_VALUE);
        this.assertMinMaxValues(SECOND_VALUE, FIRST_VALUE);
    }

    @Test
    public void testSum() {
        BinaryStatisticsBuilder binaryStatisticsBuilder = new BinaryStatisticsBuilder();
        for (Slice value : ImmutableList.of((Object)Slices.EMPTY_SLICE, (Object)FIRST_VALUE, (Object)SECOND_VALUE)) {
            TestBinaryStatisticsBuilder.addValue(binaryStatisticsBuilder, value);
        }
        this.assertBinaryStatistics(binaryStatisticsBuilder.buildColumnStatistics(), 3, Slices.EMPTY_SLICE.length() + FIRST_VALUE.length() + SECOND_VALUE.length());
    }

    @Test
    public void testBlockBinaryStatistics() {
        String alphabets = "abcdefghijklmnopqrstuvwxyz";
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, alphabets.length(), alphabets.length());
        Slice slice = Slices.utf8Slice((String)alphabets);
        for (int i = 0; i < slice.length(); ++i) {
            VarbinaryType.VARBINARY.writeSlice((BlockBuilder)blockBuilder, slice, i, 1);
        }
        blockBuilder.appendNull();
        BinaryStatisticsBuilder binaryStatisticsBuilder = new BinaryStatisticsBuilder();
        binaryStatisticsBuilder.addBlock((Type)VarbinaryType.VARBINARY, (Block)blockBuilder);
        BinaryStatistics binaryStatistics = binaryStatisticsBuilder.buildColumnStatistics().getBinaryStatistics();
        Assert.assertEquals((long)binaryStatistics.getSum(), (long)slice.length());
    }

    @Test
    public void testAddValueByPosition() {
        String alphabet = "abcdefghijklmnopqrstuvwxyz";
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, alphabet.length(), alphabet.length());
        Slice slice = Slices.utf8Slice((String)alphabet);
        for (int i = 0; i < slice.length(); ++i) {
            VarbinaryType.VARBINARY.writeSlice((BlockBuilder)blockBuilder, slice, i, 1);
        }
        blockBuilder.appendNull();
        BinaryStatisticsBuilder statisticsBuilder = new BinaryStatisticsBuilder();
        int positionCount = blockBuilder.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            statisticsBuilder.addValue((Type)VarbinaryType.VARBINARY, (Block)blockBuilder, position);
        }
        ColumnStatistics columnStatistics = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)(positionCount - 1));
        BinaryStatistics binaryStatistics = columnStatistics.getBinaryStatistics();
        Assert.assertEquals((long)binaryStatistics.getSum(), (long)slice.length());
    }

    @Test
    public void testMerge() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        BinaryStatisticsBuilder statisticsBuilder = new BinaryStatisticsBuilder();
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBinaryStatistics(statisticsList, 0, 0L);
        TestBinaryStatisticsBuilder.addValue(statisticsBuilder, Slices.EMPTY_SLICE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBinaryStatistics(statisticsList, 1, 0L);
        TestBinaryStatisticsBuilder.addValue(statisticsBuilder, FIRST_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBinaryStatistics(statisticsList, 3, FIRST_VALUE.length());
        TestBinaryStatisticsBuilder.addValue(statisticsBuilder, SECOND_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBinaryStatistics(statisticsList, 6, FIRST_VALUE.length() * 2 + SECOND_VALUE.length());
    }

    @Test
    public void testTotalValueBytes() {
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(5L, ImmutableList.of((Object)Slices.EMPTY_SLICE));
        this.assertTotalValueBytes((long)FIRST_VALUE.length() + 5L, ImmutableList.of((Object)FIRST_VALUE));
        this.assertTotalValueBytes((long)(FIRST_VALUE.length() + SECOND_VALUE.length()) + 10L, ImmutableList.of((Object)FIRST_VALUE, (Object)SECOND_VALUE));
    }

    private void assertMergedBinaryStatistics(List<ColumnStatistics> statisticsList, int expectedNumberOfValues, long expectedSum) {
        this.assertBinaryStatistics(ColumnStatistics.mergeColumnStatistics(statisticsList), expectedNumberOfValues, expectedSum);
        TestBinaryStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestBinaryStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, 0, 10L)), expectedNumberOfValues + 10);
        TestBinaryStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestBinaryStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size(), 10L)), expectedNumberOfValues + 10);
        TestBinaryStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestBinaryStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size() / 2, 10L)), expectedNumberOfValues + 10);
    }

    private void assertBinaryStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues, long expectedSum) {
        if (expectedNumberOfValues > 0) {
            Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)expectedNumberOfValues);
            Assert.assertEquals((long)columnStatistics.getBinaryStatistics().getSum(), (long)expectedSum);
        } else {
            Assert.assertNull((Object)columnStatistics.getBinaryStatistics());
            Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)0L);
        }
    }

    public static void addValue(BinaryStatisticsBuilder binaryStatisticsBuilder, Slice slice) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, slice.length());
        blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
        binaryStatisticsBuilder.addBlock((Type)VarbinaryType.VARBINARY, (Block)blockBuilder);
    }
}

