/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBooleanStatisticsBuilder
extends AbstractStatisticsBuilderTest<BooleanStatisticsBuilder, Boolean> {
    public TestBooleanStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.BOOLEAN, BooleanStatisticsBuilder::new, BooleanStatisticsBuilder::addValue);
    }

    @Test
    public void testAddValueValues() {
        BooleanStatisticsBuilder statisticsBuilder = new BooleanStatisticsBuilder();
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 0, 0);
        statisticsBuilder.addValue(false);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 1, 0);
        statisticsBuilder.addValue(false);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 2, 0);
        statisticsBuilder.addValue(true);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 3, 1);
        statisticsBuilder.addValue(true);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 4, 2);
        statisticsBuilder = new BooleanStatisticsBuilder();
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 0, 0);
        statisticsBuilder.addValue(true);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 1, 1);
        statisticsBuilder.addValue(true);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 2, 2);
        statisticsBuilder.addValue(false);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 3, 2);
        statisticsBuilder.addValue(false);
        this.assertBooleanStatistics(statisticsBuilder.buildColumnStatistics(), 4, 2);
    }

    @Test
    public void testMerge() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        BooleanStatisticsBuilder statisticsBuilder = new BooleanStatisticsBuilder();
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBooleanStatistics(statisticsList, 0, 0);
        statisticsBuilder.addValue(false);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBooleanStatistics(statisticsList, 1, 0);
        statisticsBuilder.addValue(false);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBooleanStatistics(statisticsList, 3, 0);
        statisticsBuilder.addValue(true);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBooleanStatistics(statisticsList, 6, 1);
        statisticsBuilder.addValue(true);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        this.assertMergedBooleanStatistics(statisticsList, 10, 3);
    }

    @Test
    public void testTotalValueBytes() {
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(2L, ImmutableList.of((Object)true));
        this.assertTotalValueBytes(2L, ImmutableList.of((Object)false));
        this.assertTotalValueBytes(8L, ImmutableList.of((Object)true, (Object)true, (Object)false, (Object)true));
    }

    private void assertMergedBooleanStatistics(List<ColumnStatistics> statisticsList, int expectedNumberOfValues, int trueValueCount) {
        this.assertBooleanStatistics(ColumnStatistics.mergeColumnStatistics(statisticsList), expectedNumberOfValues, trueValueCount);
        TestBooleanStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestBooleanStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, 0, 10L)), expectedNumberOfValues + 10);
        TestBooleanStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestBooleanStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size(), 10L)), expectedNumberOfValues + 10);
        TestBooleanStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestBooleanStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size() / 2, 10L)), expectedNumberOfValues + 10);
    }

    private void assertBooleanStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues, int trueValueCount) {
        if (expectedNumberOfValues > 0) {
            this.assertColumnStatistics(columnStatistics, expectedNumberOfValues, null, null);
            Assert.assertEquals((long)columnStatistics.getBooleanStatistics().getTrueValueCount(), (long)trueValueCount);
        }
    }
}

