/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.CountStatisticsBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCountStatisticsBuilder {
    @Test
    public void testNoValues() {
        CountStatisticsBuilder statisticsBuilder = new CountStatisticsBuilder();
        ColumnStatistics columnStatistics = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)0L);
    }

    @Test
    public void testAddValue() {
        CountStatisticsBuilder statisticsBuilder = new CountStatisticsBuilder();
        statisticsBuilder.addValue();
        statisticsBuilder.addValue();
        ColumnStatistics columnStatistics = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)2L);
    }

    @Test
    public void testAddBlockValues() {
        BlockBuilder block = BigintType.BIGINT.createBlockBuilder(null, 3).writeLong(3L).appendNull().writeLong(10L);
        CountStatisticsBuilder statisticsBuilder = new CountStatisticsBuilder();
        statisticsBuilder.addBlock((Type)BigintType.BIGINT, (Block)block);
        ColumnStatistics columnStatistics = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)2L);
    }

    @Test
    public void testAddValueByPosition() {
        BlockBuilder block = BigintType.BIGINT.createBlockBuilder(null, 3).writeLong(3L).appendNull().writeLong(10L);
        CountStatisticsBuilder statisticsBuilder = new CountStatisticsBuilder();
        statisticsBuilder.addValue((Type)BigintType.BIGINT, (Block)block, 0);
        statisticsBuilder.addValue((Type)BigintType.BIGINT, (Block)block, 1);
        ColumnStatistics columnStatistics = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)1L);
    }
}

