/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractRangeStatisticsTest;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import org.openjdk.jol.info.ClassLayout;
import org.testng.annotations.Test;

public class TestDateStatistics
extends AbstractRangeStatisticsTest<DateStatistics, Integer> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DateStatistics.class).instanceSize();

    @Override
    protected DateStatistics getCreateStatistics(Integer min, Integer max) {
        return new DateStatistics(min, max);
    }

    @Test
    public void test() {
        this.assertMinMax(0, 42);
        this.assertMinMax(42, 42);
        this.assertMinMax(Integer.MIN_VALUE, 42);
        this.assertMinMax(42, Integer.MAX_VALUE);
        this.assertMinMax(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Test
    public void testRetainedSize() {
        this.assertRetainedSize(0, 42, INSTANCE_SIZE);
        this.assertRetainedSize(42, 42, INSTANCE_SIZE);
        this.assertRetainedSize(Integer.MIN_VALUE, 42, INSTANCE_SIZE);
        this.assertRetainedSize(42, Integer.MAX_VALUE, INSTANCE_SIZE);
        this.assertRetainedSize(Integer.MIN_VALUE, Integer.MAX_VALUE, INSTANCE_SIZE);
    }
}

