/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDateStatisticsBuilder
extends AbstractStatisticsBuilderTest<DateStatisticsBuilder, Integer> {
    public TestDateStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.DATE, DateStatisticsBuilder::new, DateStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(0, 0);
        this.assertMinMaxValues(42, 42);
        this.assertMinMaxValues(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.assertMinMaxValues(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.assertMinMaxValues(0, 42);
        this.assertMinMaxValues(42, 42);
        this.assertMinMaxValues(Integer.MIN_VALUE, 42);
        this.assertMinMaxValues(42, Integer.MAX_VALUE);
        this.assertMinMaxValues(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.assertValues(-42, 0, ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(-42), (Comparable)Integer.valueOf(0)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        this.assertValues(-42, 42, ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(-42), (Comparable)Integer.valueOf(42)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        this.assertValues(0, 42, ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(42)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        this.assertValues(Integer.MIN_VALUE, -2147483606, ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(-2147483606)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        this.assertValues(2147483605, Integer.MAX_VALUE, ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(2147483605), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.integers()).asList());
    }

    @Test
    public void testValueOutOfRange() {
        try {
            new DateStatisticsBuilder().addValue(0x80000000L);
            Assert.fail((String)"Expected ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            new DateStatisticsBuilder().addValue(-2147483649L);
            Assert.fail((String)"Expected ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testTotalValueBytes() {
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(5L, ImmutableList.of((Object)42));
        this.assertTotalValueBytes(5L, ImmutableList.of((Object)0));
        this.assertTotalValueBytes(20L, ImmutableList.of((Object)0, (Object)42, (Object)42, (Object)43));
    }
}

