/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractRangeStatisticsTest;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import io.airlift.slice.SizeOf;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.openjdk.jol.info.ClassLayout;
import org.testng.annotations.Test;

public class TestDecimalStatistics
extends AbstractRangeStatisticsTest<DecimalStatistics, BigDecimal> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalStatistics.class).instanceSize();
    private static final long BIG_DECIMAL_INSTANCE_SIZE = (long)(ClassLayout.parseClass(BigDecimal.class).instanceSize() + ClassLayout.parseClass(BigInteger.class).instanceSize()) + SizeOf.sizeOf((int[])new int[0]);
    private static final BigDecimal MEDIUM_VALUE = new BigDecimal("890.37492");
    private static final BigDecimal LARGE_POSITIVE_VALUE = new BigDecimal("123456789012345678901234567890.12345");
    private static final BigDecimal LARGE_NEGATIVE_VALUE = LARGE_POSITIVE_VALUE.negate();

    @Override
    protected DecimalStatistics getCreateStatistics(BigDecimal min, BigDecimal max) {
        return new DecimalStatistics(min, max, 16L);
    }

    @Test
    public void test() {
        this.assertMinMax(BigDecimal.ZERO, MEDIUM_VALUE);
        this.assertMinMax(MEDIUM_VALUE, MEDIUM_VALUE);
        this.assertMinMax(LARGE_NEGATIVE_VALUE, MEDIUM_VALUE);
        this.assertMinMax(MEDIUM_VALUE, LARGE_POSITIVE_VALUE);
        this.assertMinMax(LARGE_NEGATIVE_VALUE, LARGE_POSITIVE_VALUE);
    }

    @Test
    public void testRetainedSize() {
        this.assertRetainedSize(LARGE_NEGATIVE_VALUE, LARGE_NEGATIVE_VALUE, (long)INSTANCE_SIZE + BIG_DECIMAL_INSTANCE_SIZE + 16L);
        this.assertRetainedSize(LARGE_NEGATIVE_VALUE, LARGE_POSITIVE_VALUE, (long)INSTANCE_SIZE + (BIG_DECIMAL_INSTANCE_SIZE + 16L) * 2L);
        this.assertRetainedSize(null, LARGE_POSITIVE_VALUE, (long)INSTANCE_SIZE + BIG_DECIMAL_INSTANCE_SIZE + 16L);
        this.assertRetainedSize(LARGE_NEGATIVE_VALUE, null, (long)INSTANCE_SIZE + BIG_DECIMAL_INSTANCE_SIZE + 16L);
        this.assertRetainedSize(null, null, INSTANCE_SIZE);
    }
}

