/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractRangeStatisticsTest;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleStatistics
extends AbstractRangeStatisticsTest<DoubleStatistics, Double> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleStatistics.class).instanceSize();

    @Override
    protected DoubleStatistics getCreateStatistics(Double min, Double max) {
        return new DoubleStatistics(min, max);
    }

    @Test
    public void test() {
        this.assertMinMax(0.0, 42.42);
        this.assertMinMax(-42.42, 0.0);
        this.assertMinMax(-42.42, 42.42);
        this.assertMinMax(0.0, Double.POSITIVE_INFINITY);
        this.assertMinMax(Double.NEGATIVE_INFINITY, 0.0);
        this.assertMinMax(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testNaN() {
        Assert.assertThrows(() -> new DoubleStatistics(Double.valueOf(0.0), Double.valueOf(Double.NaN)));
        Assert.assertThrows(() -> new DoubleStatistics(Double.valueOf(Double.NaN), Double.valueOf(0.0)));
        Assert.assertThrows(() -> new DoubleStatistics(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
    }

    @Test
    public void testRetainedSize() {
        this.assertRetainedSize(0.0, 42.0, INSTANCE_SIZE);
        this.assertRetainedSize(42.0, 42.0, INSTANCE_SIZE);
        this.assertRetainedSize(Double.NEGATIVE_INFINITY, 42.0, INSTANCE_SIZE);
        this.assertRetainedSize(42.0, Double.POSITIVE_INFINITY, INSTANCE_SIZE);
        this.assertRetainedSize(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, INSTANCE_SIZE);
    }
}

