/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestDoubleStatisticsBuilder
extends AbstractStatisticsBuilderTest<DoubleStatisticsBuilder, Double> {
    private static final List<Long> ZERO_TO_42 = (List)LongStream.rangeClosed(0L, 42L).boxed().collect(ImmutableList.toImmutableList());

    public TestDoubleStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.DOUBLE, DoubleStatisticsBuilder::new, DoubleStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(0.0, 0.0);
        this.assertMinMaxValues(42.42, 42.42);
        this.assertMinMaxValues(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.assertMinMaxValues(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertMinMaxValues(0.0, 42.42);
        this.assertMinMaxValues(42.42, 42.42);
        this.assertMinMaxValues(Double.NEGATIVE_INFINITY, 42.42);
        this.assertMinMaxValues(42.42, Double.POSITIVE_INFINITY);
        this.assertMinMaxValues(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertValues(0.0, 88.88, TestDoubleStatisticsBuilder.toDoubleList(0.0, 88.88, ZERO_TO_42));
        this.assertValues(-88.88, 0.0, TestDoubleStatisticsBuilder.toDoubleList(-88.88, 0.0, ZERO_TO_42));
        this.assertValues(-44.44, 44.44, TestDoubleStatisticsBuilder.toDoubleList(-44.44, 44.44, ZERO_TO_42));
    }

    private static List<Double> toDoubleList(Double minValue, Double maxValue, List<Long> values) {
        return (List)values.stream().flatMap(value -> Stream.of(maxValue - (double)value.longValue(), minValue + (double)value.longValue())).collect(ImmutableList.toImmutableList());
    }

    @Test
    public void testNanValue() {
        DoubleStatisticsBuilder statisticsBuilder = new DoubleStatisticsBuilder();
        statisticsBuilder.addValue(Double.NaN);
        TestDoubleStatisticsBuilder.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 1);
        statisticsBuilder.addValue(Double.NaN);
        TestDoubleStatisticsBuilder.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 2);
        statisticsBuilder.addValue(42.42);
        TestDoubleStatisticsBuilder.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 3);
        statisticsBuilder = new DoubleStatisticsBuilder();
        statisticsBuilder.addValue(42.42);
        this.assertColumnStatistics(statisticsBuilder.buildColumnStatistics(), 1, 42.42, 42.42);
        statisticsBuilder.addValue(Double.NaN);
        TestDoubleStatisticsBuilder.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 2);
        statisticsBuilder.addValue(42.42);
        TestDoubleStatisticsBuilder.assertNoColumnStatistics(statisticsBuilder.buildColumnStatistics(), 3);
    }

    @Test
    public void testTotalValueBytes() {
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(9L, ImmutableList.of((Object)42.0));
        this.assertTotalValueBytes(9L, ImmutableList.of((Object)0.0));
        this.assertTotalValueBytes(36L, ImmutableList.of((Object)0.0, (Object)42.0, (Object)42.0, (Object)43.0));
    }
}

