/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractRangeStatisticsTest;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import org.openjdk.jol.info.ClassLayout;
import org.testng.annotations.Test;

public class TestIntegerStatistics
extends AbstractRangeStatisticsTest<IntegerStatistics, Long> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntegerStatistics.class).instanceSize();

    @Override
    protected IntegerStatistics getCreateStatistics(Long min, Long max) {
        return new IntegerStatistics(min, max, Long.valueOf(1000L));
    }

    @Test
    public void test() {
        this.assertMinMax(0L, 42L);
        this.assertMinMax(42L, 42L);
        this.assertMinMax(Long.MIN_VALUE, 42L);
        this.assertMinMax(42L, Long.MAX_VALUE);
        this.assertMinMax(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Test
    public void testRetainedSize() {
        this.assertRetainedSize(0L, 42L, INSTANCE_SIZE);
        this.assertRetainedSize(42L, 42L, INSTANCE_SIZE);
        this.assertRetainedSize(Long.MIN_VALUE, 42L, INSTANCE_SIZE);
        this.assertRetainedSize(42L, Long.MAX_VALUE, INSTANCE_SIZE);
        this.assertRetainedSize(Long.MIN_VALUE, Long.MAX_VALUE, INSTANCE_SIZE);
    }
}

