/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestIntegerStatisticsBuilder
extends AbstractStatisticsBuilderTest<IntegerStatisticsBuilder, Long> {
    public TestIntegerStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.INTEGER, IntegerStatisticsBuilder::new, IntegerStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(0L, 0L);
        this.assertMinMaxValues(42L, 42L);
        this.assertMinMaxValues(Long.MIN_VALUE, Long.MIN_VALUE);
        this.assertMinMaxValues(Long.MAX_VALUE, Long.MAX_VALUE);
        this.assertMinMaxValues(0L, 42L);
        this.assertMinMaxValues(42L, 42L);
        this.assertMinMaxValues(Long.MIN_VALUE, 42L);
        this.assertMinMaxValues(42L, Long.MAX_VALUE);
        this.assertMinMaxValues(Long.MIN_VALUE, Long.MAX_VALUE);
        this.assertValues(-42L, 0L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(-42L), (Comparable)Long.valueOf(0L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(-42L, 42L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(-42L), (Comparable)Long.valueOf(42L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(0L, 42L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(42L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(Long.MIN_VALUE, -9223372036854775766L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(Long.MIN_VALUE), (Comparable)Long.valueOf(-9223372036854775766L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(9223372036854775765L, Long.MAX_VALUE, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(9223372036854775765L), (Comparable)Long.valueOf(Long.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.longs()).asList());
    }

    @Test
    public void testTotalValueBytes() {
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(9L, ImmutableList.of((Object)42L));
        this.assertTotalValueBytes(9L, ImmutableList.of((Object)0L));
        this.assertTotalValueBytes(36L, ImmutableList.of((Object)0L, (Object)42L, (Object)42L, (Object)43L));
    }

    @Test
    public void testSum() {
        int values = 0;
        long expectedSum = 0L;
        IntegerStatisticsBuilder integerStatisticsBuilder = new IntegerStatisticsBuilder();
        for (int value = -100000; value < 500000; ++value) {
            ++values;
            expectedSum += (long)value;
            integerStatisticsBuilder.addValue((long)value);
        }
        TestIntegerStatisticsBuilder.assertIntegerStatistics(integerStatisticsBuilder.buildColumnStatistics(), values, expectedSum);
    }

    @Test
    public void testSumOverflow() {
        IntegerStatisticsBuilder integerStatisticsBuilder = new IntegerStatisticsBuilder();
        integerStatisticsBuilder.addValue(Long.MAX_VALUE);
        TestIntegerStatisticsBuilder.assertIntegerStatistics(integerStatisticsBuilder.buildColumnStatistics(), 1, Long.MAX_VALUE);
        integerStatisticsBuilder.addValue(10L);
        TestIntegerStatisticsBuilder.assertIntegerStatistics(integerStatisticsBuilder.buildColumnStatistics(), 2, null);
    }

    @Test
    public void testSumUnderflow() {
        IntegerStatisticsBuilder integerStatisticsBuilder = new IntegerStatisticsBuilder();
        integerStatisticsBuilder.addValue(Long.MIN_VALUE);
        TestIntegerStatisticsBuilder.assertIntegerStatistics(integerStatisticsBuilder.buildColumnStatistics(), 1, Long.MIN_VALUE);
        integerStatisticsBuilder.addValue(-10L);
        TestIntegerStatisticsBuilder.assertIntegerStatistics(integerStatisticsBuilder.buildColumnStatistics(), 2, null);
    }

    @Test
    public void testMerge() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        IntegerStatisticsBuilder statisticsBuilder = new IntegerStatisticsBuilder();
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 0, 0L);
        statisticsBuilder.addValue(0L);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 1, 0L);
        statisticsBuilder.addValue(-44L);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 3, -44L);
        statisticsBuilder.addValue(100L);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 6, 12L);
        statisticsBuilder.addValue(Long.MAX_VALUE);
        statisticsList.add(statisticsBuilder.buildColumnStatistics());
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 10, null);
    }

    @Test
    public void testMergeOverflow() {
        ArrayList<ColumnStatistics> statisticsList = new ArrayList<ColumnStatistics>();
        statisticsList.add(new IntegerStatisticsBuilder().buildColumnStatistics());
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 0, 0L);
        statisticsList.add(TestIntegerStatisticsBuilder.singleValueIntegerStatistics(Long.MAX_VALUE));
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 1, Long.MAX_VALUE);
        statisticsList.add(TestIntegerStatisticsBuilder.singleValueIntegerStatistics(1L));
        TestIntegerStatisticsBuilder.assertMergedIntegerStatistics(statisticsList, 2, null);
    }

    @DataProvider
    public static Object[][] addValueByPositionDataProvider() {
        return new Object[][]{{SmallintType.SMALLINT, SmallintType.SMALLINT.createBlockBuilder(null, 3).writeShort(3).appendNull().writeShort(10).build()}, {IntegerType.INTEGER, IntegerType.INTEGER.createBlockBuilder(null, 3).writeInt(3).appendNull().writeInt(10).build()}, {BigintType.BIGINT, BigintType.BIGINT.createBlockBuilder(null, 3).writeLong(3L).appendNull().writeLong(10L).build()}};
    }

    @Test(dataProvider="addValueByPositionDataProvider")
    public void testAddValueByPosition(Type type, Block block) {
        IntegerStatisticsBuilder statisticsBuilder = new IntegerStatisticsBuilder();
        statisticsBuilder.addValue(type, block, 0);
        statisticsBuilder.addValue(type, block, 1);
        statisticsBuilder.addValue(type, block, 2);
        ColumnStatistics columnStatistics = statisticsBuilder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)2L);
        IntegerStatistics integerStatistics = columnStatistics.getIntegerStatistics();
        Assert.assertEquals((long)integerStatistics.getMin(), (long)3L);
        Assert.assertEquals((long)integerStatistics.getMax(), (long)10L);
        Assert.assertEquals((long)integerStatistics.getSum(), (long)13L);
    }

    private static ColumnStatistics singleValueIntegerStatistics(long value) {
        IntegerStatisticsBuilder statisticsBuilder = new IntegerStatisticsBuilder();
        statisticsBuilder.addValue(value);
        return statisticsBuilder.buildColumnStatistics();
    }

    private static void assertMergedIntegerStatistics(List<ColumnStatistics> statisticsList, int expectedNumberOfValues, Long expectedSum) {
        TestIntegerStatisticsBuilder.assertIntegerStatistics(ColumnStatistics.mergeColumnStatistics(statisticsList), expectedNumberOfValues, expectedSum);
        TestIntegerStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestIntegerStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, 0, 10L)), expectedNumberOfValues + 10);
        TestIntegerStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestIntegerStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size(), 10L)), expectedNumberOfValues + 10);
        TestIntegerStatisticsBuilder.assertNoColumnStatistics(ColumnStatistics.mergeColumnStatistics(TestIntegerStatisticsBuilder.insertEmptyColumnStatisticsAt(statisticsList, statisticsList.size() / 2, 10L)), expectedNumberOfValues + 10);
    }

    private static void assertIntegerStatistics(ColumnStatistics columnStatistics, int expectedNumberOfValues, Long expectedSum) {
        if (expectedNumberOfValues > 0) {
            Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)expectedNumberOfValues);
            Assert.assertEquals((Object)columnStatistics.getIntegerStatistics().getSum(), (Object)expectedSum);
        } else {
            Assert.assertNull((Object)columnStatistics.getIntegerStatistics());
            Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)0L);
        }
    }
}

