/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestLongDecimalStatisticsBuilder
extends AbstractStatisticsBuilderTest<LongDecimalStatisticsBuilder, BigDecimal> {
    private static final BigDecimal MEDIUM_VALUE = new BigDecimal("890.37492");
    private static final BigDecimal LARGE_POSITIVE_VALUE = new BigDecimal("123456789012345678901234567890.12345");
    private static final BigDecimal LARGE_NEGATIVE_VALUE = LARGE_POSITIVE_VALUE.negate();
    private static final List<Long> ZERO_TO_42 = ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(42L)), (DiscreteDomain)DiscreteDomain.longs()).asList();

    public TestLongDecimalStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.DECIMAL, LongDecimalStatisticsBuilder::new, LongDecimalStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(BigDecimal.ZERO, BigDecimal.ZERO);
        this.assertMinMaxValues(MEDIUM_VALUE, MEDIUM_VALUE);
        this.assertMinMaxValues(LARGE_NEGATIVE_VALUE, LARGE_NEGATIVE_VALUE);
        this.assertMinMaxValues(LARGE_POSITIVE_VALUE, LARGE_POSITIVE_VALUE);
        this.assertMinMaxValues(BigDecimal.ZERO, MEDIUM_VALUE);
        this.assertMinMaxValues(MEDIUM_VALUE, MEDIUM_VALUE);
        this.assertMinMaxValues(LARGE_NEGATIVE_VALUE, MEDIUM_VALUE);
        this.assertMinMaxValues(MEDIUM_VALUE, LARGE_POSITIVE_VALUE);
        this.assertMinMaxValues(LARGE_NEGATIVE_VALUE, LARGE_POSITIVE_VALUE);
        this.assertValues(BigDecimal.ZERO, MEDIUM_VALUE, TestLongDecimalStatisticsBuilder.toBigDecimalList(BigDecimal.ZERO, MEDIUM_VALUE, ZERO_TO_42));
        this.assertValues(LARGE_NEGATIVE_VALUE, MEDIUM_VALUE, TestLongDecimalStatisticsBuilder.toBigDecimalList(LARGE_NEGATIVE_VALUE, MEDIUM_VALUE, ZERO_TO_42));
        this.assertValues(MEDIUM_VALUE, LARGE_POSITIVE_VALUE, TestLongDecimalStatisticsBuilder.toBigDecimalList(MEDIUM_VALUE, LARGE_POSITIVE_VALUE, ZERO_TO_42));
        this.assertValues(LARGE_NEGATIVE_VALUE, LARGE_POSITIVE_VALUE, TestLongDecimalStatisticsBuilder.toBigDecimalList(LARGE_NEGATIVE_VALUE, LARGE_POSITIVE_VALUE, ZERO_TO_42));
    }

    @Test
    public void testTotalValueBytes() {
        long longDecimalBytes = 17L;
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(longDecimalBytes, ImmutableList.of((Object)LARGE_POSITIVE_VALUE));
        this.assertTotalValueBytes(longDecimalBytes, ImmutableList.of((Object)LARGE_NEGATIVE_VALUE));
        this.assertTotalValueBytes(4L * longDecimalBytes, ImmutableList.of((Object)LARGE_POSITIVE_VALUE, (Object)LARGE_POSITIVE_VALUE, (Object)LARGE_POSITIVE_VALUE, (Object)LARGE_NEGATIVE_VALUE));
    }

    private static List<BigDecimal> toBigDecimalList(BigDecimal minValue, BigDecimal maxValue, List<Long> values) {
        return (List)values.stream().flatMap(value -> Stream.of(maxValue.subtract(BigDecimal.valueOf(value)), minValue.add(BigDecimal.valueOf(value)))).collect(ImmutableList.toImmutableList());
    }
}

