/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatisticsBuilder;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestMapColumnStatistics {
    private static final DwrfProto.KeyInfo INT_KEY1 = DwrfProto.KeyInfo.newBuilder().setIntKey(1L).build();
    private static final DwrfProto.KeyInfo INT_KEY2 = DwrfProto.KeyInfo.newBuilder().setIntKey(2L).build();
    private static final DwrfProto.KeyInfo INT_KEY3 = DwrfProto.KeyInfo.newBuilder().setIntKey(3L).build();
    private static final DwrfProto.KeyInfo STRING_KEY1 = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"s1")).build();
    private static final DwrfProto.KeyInfo STRING_KEY2 = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"s2")).build();
    private static final DwrfProto.KeyInfo STRING_KEY3 = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"s3")).build();

    @DataProvider
    public Object[][] keySupplier() {
        return new Object[][]{{INT_KEY1, INT_KEY2, INT_KEY3}, {STRING_KEY1, STRING_KEY2, STRING_KEY3}};
    }

    @Test(dataProvider="keySupplier")
    public void testEqualsHashCode(DwrfProto.KeyInfo[] keys) {
        MapColumnStatisticsBuilder builder1 = new MapColumnStatisticsBuilder(true);
        builder1.addMapStatistics(keys[0], new ColumnStatistics(Long.valueOf(3L), null));
        builder1.addMapStatistics(keys[1], new ColumnStatistics(Long.valueOf(5L), null));
        builder1.increaseValueCount(8L);
        ColumnStatistics columnStatistics1 = builder1.buildColumnStatistics();
        MapColumnStatisticsBuilder builder2 = new MapColumnStatisticsBuilder(true);
        builder2.addMapStatistics(keys[0], new ColumnStatistics(Long.valueOf(3L), null));
        builder2.addMapStatistics(keys[1], new ColumnStatistics(Long.valueOf(5L), null));
        builder2.increaseValueCount(8L);
        ColumnStatistics columnStatistics2 = builder2.buildColumnStatistics();
        MapColumnStatisticsBuilder builder3 = new MapColumnStatisticsBuilder(true);
        builder3.addMapStatistics(keys[1], new ColumnStatistics(Long.valueOf(5L), null));
        builder3.addMapStatistics(keys[2], new ColumnStatistics(Long.valueOf(6L), null));
        builder3.increaseValueCount(11L);
        ColumnStatistics columnStatistics3 = builder3.buildColumnStatistics();
        Assert.assertEquals((Object)columnStatistics1, (Object)columnStatistics2);
        Assert.assertEquals((int)columnStatistics1.hashCode(), (int)columnStatistics2.hashCode());
        Assert.assertNotEquals((Object)columnStatistics2, (Object)columnStatistics3);
        Assert.assertNotEquals((Object)columnStatistics2.hashCode(), (Object)columnStatistics3.hashCode());
    }
}

