/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.MapStatistics;
import com.facebook.presto.orc.metadata.statistics.MapStatisticsEntry;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestMapColumnStatisticsBuilder {
    private static final DwrfProto.KeyInfo INT_KEY1 = DwrfProto.KeyInfo.newBuilder().setIntKey(1L).build();
    private static final DwrfProto.KeyInfo INT_KEY2 = DwrfProto.KeyInfo.newBuilder().setIntKey(2L).build();
    private static final DwrfProto.KeyInfo INT_KEY3 = DwrfProto.KeyInfo.newBuilder().setIntKey(3L).build();
    private static final DwrfProto.KeyInfo STRING_KEY1 = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"s1")).build();
    private static final DwrfProto.KeyInfo STRING_KEY2 = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"s2")).build();
    private static final DwrfProto.KeyInfo STRING_KEY3 = DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)"s3")).build();

    @DataProvider
    public Object[][] keySupplier() {
        return new Object[][]{{INT_KEY1, INT_KEY2, INT_KEY3}, {STRING_KEY1, STRING_KEY2, STRING_KEY3}};
    }

    @Test
    public void testAddMapStatisticsNoValues() {
        MapColumnStatisticsBuilder builder = new MapColumnStatisticsBuilder(true);
        ColumnStatistics columnStatistics = builder.buildColumnStatistics();
        Assert.assertEquals(columnStatistics.getClass(), ColumnStatistics.class);
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)0L);
        Assert.assertNull((Object)columnStatistics.getMapStatistics());
    }

    @Test(dataProvider="keySupplier")
    public void testAddMapStatistics(DwrfProto.KeyInfo[] keys) {
        DwrfProto.KeyInfo key1 = keys[0];
        DwrfProto.KeyInfo key2 = keys[1];
        ColumnStatistics columnStatistics1 = new ColumnStatistics(Long.valueOf(3L), null);
        ColumnStatistics columnStatistics2 = new ColumnStatistics(Long.valueOf(5L), null);
        MapColumnStatisticsBuilder builder = new MapColumnStatisticsBuilder(true);
        builder.addMapStatistics(key1, columnStatistics1);
        builder.addMapStatistics(key2, columnStatistics2);
        builder.increaseValueCount(10L);
        MapColumnStatistics columnStatistics = (MapColumnStatistics)builder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)10L);
        MapStatistics mapStatistics = columnStatistics.getMapStatistics();
        List entries = mapStatistics.getEntries();
        Assert.assertEquals((int)entries.size(), (int)2);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(0)).getKey(), (Object)key1);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(0)).getColumnStatistics(), (Object)columnStatistics1);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(1)).getKey(), (Object)key2);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(1)).getColumnStatistics(), (Object)columnStatistics2);
    }

    @Test(dataProvider="keySupplier")
    public void testAddMapStatisticsNoValues(DwrfProto.KeyInfo[] keys) {
        DwrfProto.KeyInfo key1 = keys[0];
        DwrfProto.KeyInfo key2 = keys[1];
        ColumnStatistics columnStatistics1 = new ColumnStatistics(Long.valueOf(3L), null);
        ColumnStatistics columnStatistics2 = new ColumnStatistics(Long.valueOf(5L), null);
        MapColumnStatisticsBuilder builder = new MapColumnStatisticsBuilder(true);
        builder.addMapStatistics(key1, columnStatistics1);
        builder.addMapStatistics(key2, columnStatistics2);
        builder.increaseValueCount(0L);
        MapColumnStatistics columnStatistics = (MapColumnStatistics)builder.buildColumnStatistics();
        Assert.assertEquals((long)columnStatistics.getNumberOfValues(), (long)0L);
        MapStatistics mapStatistics = columnStatistics.getMapStatistics();
        List entries = mapStatistics.getEntries();
        Assert.assertEquals((int)entries.size(), (int)2);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(0)).getKey(), (Object)key1);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(0)).getColumnStatistics(), (Object)columnStatistics1);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(1)).getKey(), (Object)key2);
        Assert.assertEquals((Object)((MapStatisticsEntry)entries.get(1)).getColumnStatistics(), (Object)columnStatistics2);
    }

    @Test(dataProvider="keySupplier")
    public void testMergeMapStatistics(DwrfProto.KeyInfo[] keys) {
        MapColumnStatisticsBuilder builder1 = new MapColumnStatisticsBuilder(true);
        builder1.addMapStatistics(keys[0], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(3L), null, new IntegerStatistics(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L))));
        builder1.addMapStatistics(keys[1], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(5L), null, new IntegerStatistics(Long.valueOf(10L), Long.valueOf(20L), Long.valueOf(30L))));
        builder1.increaseValueCount(8L);
        ColumnStatistics columnStatistics1 = builder1.buildColumnStatistics();
        MapColumnStatisticsBuilder builder2 = new MapColumnStatisticsBuilder(true);
        builder2.addMapStatistics(keys[1], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(7L), null, new IntegerStatistics(Long.valueOf(25L), Long.valueOf(95L), Long.valueOf(100L))));
        builder2.addMapStatistics(keys[2], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(9L), null, new IntegerStatistics(Long.valueOf(12L), Long.valueOf(22L), Long.valueOf(32L))));
        builder2.increaseValueCount(16L);
        ColumnStatistics columnStatistics2 = builder2.buildColumnStatistics();
        MapStatistics mergedMapStatistics = (MapStatistics)MapColumnStatisticsBuilder.mergeMapStatistics((List)ImmutableList.of((Object)columnStatistics1, (Object)columnStatistics2)).get();
        this.assertMergedMapStatistics(keys, mergedMapStatistics);
    }

    @Test(dataProvider="keySupplier")
    public void testMergeMapStatisticsMissingStats(DwrfProto.KeyInfo[] keys) {
        MapColumnStatisticsBuilder builder1 = new MapColumnStatisticsBuilder(true);
        builder1.addMapStatistics(keys[0], new ColumnStatistics(Long.valueOf(3L), null));
        builder1.increaseValueCount(3L);
        ColumnStatistics columnStatistics1 = builder1.buildColumnStatistics();
        ColumnStatistics columnStatistics2 = new ColumnStatistics(Long.valueOf(7L), null);
        Optional mergedMapStats = MapColumnStatisticsBuilder.mergeMapStatistics((List)ImmutableList.of((Object)columnStatistics1, (Object)columnStatistics2));
        Assert.assertFalse((boolean)mergedMapStats.isPresent());
    }

    @Test(dataProvider="keySupplier")
    public void testMergeColumnStatistics(DwrfProto.KeyInfo[] keys) {
        MapColumnStatisticsBuilder builder1 = new MapColumnStatisticsBuilder(true);
        builder1.addMapStatistics(keys[0], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(3L), null, new IntegerStatistics(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L))));
        builder1.addMapStatistics(keys[1], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(5L), null, new IntegerStatistics(Long.valueOf(10L), Long.valueOf(20L), Long.valueOf(30L))));
        builder1.increaseValueCount(10L);
        ColumnStatistics columnStatistics1 = builder1.buildColumnStatistics();
        MapColumnStatisticsBuilder builder2 = new MapColumnStatisticsBuilder(true);
        builder2.addMapStatistics(keys[1], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(7L), null, new IntegerStatistics(Long.valueOf(25L), Long.valueOf(95L), Long.valueOf(100L))));
        builder2.addMapStatistics(keys[2], (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(9L), null, new IntegerStatistics(Long.valueOf(12L), Long.valueOf(22L), Long.valueOf(32L))));
        builder2.increaseValueCount(20L);
        ColumnStatistics columnStatistics2 = builder2.buildColumnStatistics();
        ColumnStatistics mergedColumnStatistics = ColumnStatistics.mergeColumnStatistics((List)ImmutableList.of((Object)columnStatistics1, (Object)columnStatistics2));
        Assert.assertEquals((long)mergedColumnStatistics.getNumberOfValues(), (long)30L);
        MapStatistics mergedMapStatistics = mergedColumnStatistics.getMapStatistics();
        this.assertMergedMapStatistics(keys, mergedMapStatistics);
    }

    private void assertMergedMapStatistics(DwrfProto.KeyInfo[] keys, MapStatistics mergedMapStatistics) {
        Assert.assertNotNull((Object)mergedMapStatistics);
        List entries = mergedMapStatistics.getEntries();
        Assert.assertEquals((int)entries.size(), (int)3);
        HashMap<DwrfProto.KeyInfo, ColumnStatistics> columnStatisticsByKey = new HashMap<DwrfProto.KeyInfo, ColumnStatistics>();
        for (MapStatisticsEntry entry : entries) {
            columnStatisticsByKey.put(entry.getKey(), entry.getColumnStatistics());
        }
        Assert.assertEquals(columnStatisticsByKey.get(keys[0]), (Object)new IntegerColumnStatistics(Long.valueOf(3L), null, new IntegerStatistics(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L))));
        Assert.assertEquals(columnStatisticsByKey.get(keys[1]), (Object)new IntegerColumnStatistics(Long.valueOf(12L), null, new IntegerStatistics(Long.valueOf(10L), Long.valueOf(95L), Long.valueOf(130L))));
        Assert.assertEquals(columnStatisticsByKey.get(keys[2]), (Object)new IntegerColumnStatistics(Long.valueOf(9L), null, new IntegerStatistics(Long.valueOf(12L), Long.valueOf(22L), Long.valueOf(32L))));
    }
}

