/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.BloomFilter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import org.apache.hive.common.util.Murmur3;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMurmur3 {
    private static final int SEED = 123;

    @Test
    public void testHashCodeM3_64() {
        byte[] origin = "It was the best of times, it was the worst of times, it was the age of wisdom, it was the age of foolishness, it was the epoch of belief, it was the epoch of incredulity, it was the season of Light, it was the season of Darkness, it was the spring of hope, it was the winter of despair, we had everything before us, we had nothing before us, we were all going direct to Heaven, we were all going direct the other way.".getBytes(StandardCharsets.UTF_8);
        long hash = BloomFilter.Murmur3.hash64((byte[])origin, (int)0, (int)origin.length);
        Assert.assertEquals((long)305830725663368540L, (long)hash);
        Assert.assertEquals((long)hash, (long)Murmur3.hash64((byte[])origin, (int)0, (int)origin.length));
        byte[] originOffset = new byte[origin.length + 150];
        Arrays.fill(originOffset, (byte)123);
        System.arraycopy(origin, 0, originOffset, 150, origin.length);
        hash = BloomFilter.Murmur3.hash64((byte[])originOffset, (int)150, (int)origin.length);
        Assert.assertEquals((long)305830725663368540L, (long)hash);
        Assert.assertEquals((long)hash, (long)Murmur3.hash64((byte[])originOffset, (int)150, (int)origin.length));
    }

    @Test
    public void test64() {
        ByteBuffer shortBuffer = ByteBuffer.allocate(2);
        ByteBuffer intBuffer = ByteBuffer.allocate(4);
        ByteBuffer longBuffer = ByteBuffer.allocate(8);
        Random rdm = new Random(123L);
        for (int i = 0; i < 1000000; ++i) {
            long ln = rdm.nextLong();
            int in = rdm.nextInt();
            short sn = (short)(rdm.nextInt(65533) - Short.MAX_VALUE);
            float fn = rdm.nextFloat();
            double dn = rdm.nextDouble();
            shortBuffer.putShort(0, sn);
            Assert.assertEquals((long)Murmur3.hash64((byte[])shortBuffer.array()), (long)BloomFilter.Murmur3.hash64((byte[])shortBuffer.array()));
            intBuffer.putInt(0, in);
            Assert.assertEquals((long)Murmur3.hash64((byte[])intBuffer.array()), (long)BloomFilter.Murmur3.hash64((byte[])intBuffer.array()));
            longBuffer.putLong(0, ln);
            Assert.assertEquals((long)Murmur3.hash64((byte[])longBuffer.array()), (long)BloomFilter.Murmur3.hash64((byte[])longBuffer.array()));
            intBuffer.putFloat(0, fn);
            Assert.assertEquals((long)Murmur3.hash64((byte[])intBuffer.array()), (long)BloomFilter.Murmur3.hash64((byte[])intBuffer.array()));
            longBuffer.putDouble(0, dn);
            Assert.assertEquals((long)Murmur3.hash64((byte[])longBuffer.array()), (long)BloomFilter.Murmur3.hash64((byte[])longBuffer.array()));
        }
    }
}

