/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.AbstractStatisticsBuilderTest;
import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.facebook.presto.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestShortDecimalStatisticsBuilder
extends AbstractStatisticsBuilderTest<ShortDecimalStatisticsBuilder, Long> {
    private static final int SCALE = 8;

    public TestShortDecimalStatisticsBuilder() {
        super(AbstractStatisticsBuilderTest.StatisticsType.DECIMAL, () -> new ShortDecimalStatisticsBuilder(8), ShortDecimalStatisticsBuilder::addValue);
    }

    @Test
    public void testMinMaxValues() {
        this.assertMinMaxValues(0L, 0L);
        this.assertMinMaxValues(42L, 42L);
        this.assertMinMaxValues(Long.MIN_VALUE, Long.MIN_VALUE);
        this.assertMinMaxValues(Long.MAX_VALUE, Long.MAX_VALUE);
        this.assertMinMaxValues(0L, 42L);
        this.assertMinMaxValues(42L, 42L);
        this.assertMinMaxValues(Long.MIN_VALUE, 42L);
        this.assertMinMaxValues(42L, Long.MAX_VALUE);
        this.assertMinMaxValues(Long.MIN_VALUE, Long.MAX_VALUE);
        this.assertValues(-42L, 0L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(-42L), (Comparable)Long.valueOf(0L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(-42L, 42L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(-42L), (Comparable)Long.valueOf(42L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(0L, 42L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(42L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(Long.MIN_VALUE, -9223372036854775766L, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(Long.MIN_VALUE), (Comparable)Long.valueOf(-9223372036854775766L)), (DiscreteDomain)DiscreteDomain.longs()).asList());
        this.assertValues(9223372036854775765L, Long.MAX_VALUE, ContiguousSet.create((Range)Range.closed((Comparable)Long.valueOf(9223372036854775765L), (Comparable)Long.valueOf(Long.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.longs()).asList());
    }

    @Test
    public void testTotalValueBytes() {
        long shortDecimalBytes = 9L;
        this.assertTotalValueBytes(0L, ImmutableList.of());
        this.assertTotalValueBytes(shortDecimalBytes, ImmutableList.of((Object)0L));
        this.assertTotalValueBytes(shortDecimalBytes, ImmutableList.of((Object)42L));
        this.assertTotalValueBytes(5L * shortDecimalBytes, ImmutableList.of((Object)0L, (Object)1L, (Object)42L, (Object)44L, (Object)52L));
    }

    @Override
    void assertRangeStatistics(RangeStatistics<?> rangeStatistics, Long expectedMin, Long expectedMax) {
        Assert.assertNotNull(rangeStatistics);
        Assert.assertEquals((Object)rangeStatistics.getMin(), (Object)new BigDecimal(BigInteger.valueOf(expectedMin), 8));
        Assert.assertEquals((Object)rangeStatistics.getMax(), (Object)new BigDecimal(BigInteger.valueOf(expectedMax), 8));
    }
}

